%% our ($faq_error, $faq_msg, $faq_id, $display_all_in_faq, $display_only_faq);

%% my $html;

<# use the separate template to build up a question link of the same style, faking it so it works with javascript variables #>
<& /nav/display_question_in_picker.tpl {
	'number'		=> "' + faqnum + '",
	'question_id'	=> "' + qid + '", 
	'question'		=> "' + question + '",
} >> $html &>

<# two minor adjustments - remove trailing whitespace and add on a trailing tickmark #>
%% $html =~ s/\s+$//g; $html =~ s/[\r\n]//g; $html = "'$html'";

<%
	$gramene_page->start_html(
		-title => 'Gramene FAQ',
		-style => {-src => '/faq/jk.css'},
		-script => [
			{-language => 'JavaScript', -src => '/faq/jk.js'},
			{-language => 'JavaScript',
			-code => qq!
			
					function display_question (img, url, callback, method, data_form, target) {

						if (target['loaded']) {
							disclose(img, target);
							return false;
						}
						else {
							target['loaded'] = 1;
							disclose(img, target);
					
							return makeHttpRequest(url, callback, method, data_form, target);
						};
					}
			
					function new_faq (link) {
		
						var new_faq = prompt('Please enter new faq:');
						if (new_faq) {
							link.href += '&name=' + new_faq;
							return true;
						}
						else {
							return false;
						}
					}
					
					function faq_save_callback (http, target) {
						if (http.readyState == 4) {
							target.innerHTML = http.responseText;
							
							var matchID		= new RegExp("ID{([0-9]+)}DI");
							var matchQ		= new RegExp("Q{Q{(.+)}Q}Q");
							var matchFAQ	= new RegExp("FAQ{([0-9]+)}QAF");
							var matchNUM	= new RegExp("NUM{([0-9]+)}MUN");
							var matchSAVED	= new RegExp("SAVED{([01]+)}DEVAS");
							
							var saved		= matchSAVED.exec(http.responseText)[1];
		
							if (saved == 0) {
								return;
							}
												
							var qid			= matchID.exec(http.responseText)[1];
							var question	= matchQ.exec(http.responseText)[1];
							var faqid		= matchFAQ.exec(http.responseText)[1];
							var faqnum		= matchNUM.exec(http.responseText)[1];
									
							var html		= $html;
		
					
							//new question, add it to the faq container
							if (document.getElementById('q_' + qid) == null) {
								var div = document.createElement('div');
								div.innerHTML = html;
								div.id = 'q_' + qid;
								div.style.backgroundColor = document.getElementById('cat_' + faqid).lastChild.previousSibling.previousSibling.previousSibling.style.backgroundColor;
								document.getElementById('cat_' + faqid).appendChild(div);
							}
							//existing question, change in place
							else {
								document.getElementById('q_' + qid).innerHTML = html;
							}
						}
					}
					
					function faq_delete_callback(http, target) {
						if (http.readyState == 4) {
							target.innerHTML = http.responseText;
							var matchID		= new RegExp("DELID{([0-9]+)}DILED");
							var matchFAQ	= new RegExp("FAQ{([0-9]+)}QAF");
							
							var qid			= matchID.exec(http.responseText)[1];
							var faqid		= matchFAQ.exec(http.responseText)[1];
							document.getElementById('cat_' + faqid).removeChild(document.getElementById('q_' + qid));
		
						}
					}
		!}]
	);

%>

<% $gramene_page->start_body %>

<div align = 'center'>
<h1>Gramene FAQ Database</h1>
<form method="GET" action="/db/searches/quick_search" style="display:inline">
<input type = 'hidden' name = 'module' value = 'faq'>
FAQ Quick Search: <input type="text" name="search_for" size="15" value="" maxlength="100">
<input type="submit" value="Search">
</form>
</div>

%% unless ($self->user->is_nobody) {
        <div style = 'text-align : center; position : fixed; left : 10px; top : 10px; border : 1px solid <% $self->permanent_session ? 'blue' : 'yellow' %>; background-color : lightgray; z-index: 999; font-size : 75%; padding : 2px'>
                <% $self->user->shortname %> is logged in.<br>
                <a href = "/db/faq?state=logout">logout</a>
        </div>
%% }
	
	%% if ($self->machine->state eq 'new_obj') {
		<div id = 'question'>
			<& /question.tpl &>
		</div>
	%% }

	<div id = 'faqnav' style = 'text-align : left;'>

		<& /picker.tpl
			{
				'title'					=> '',
				'objects'				=> \@faqs,
				'open_ids'				=> [$faq_id],
				'create_object_gizmo' 	=> '/nav/create_faq.tpl',
				'sub_picker'			=> '/nav/question_picker.tpl',
				'id'					=> 'faq_id',
				'name'					=> 'name',

				'faq_error'				=> $faq_error,
				'faq_msg'				=> $faq_msg,
				'at_question'			=> $question,
				'display_all_in_faq'	=> $display_all_in_faq,
				'display_only_faq'		=> $display_only_faq,
			}
		&>

	</div>

<% $gramene_page->end_body %>
</body>
</html>
