package GrameneTest;

# $Id: GrameneTest.pm,v 1.1 2007/06/06 20:48:43 kclark Exp $

=head1 NAME

Gramene::Test - a Gramene module

=head1 SYNOPSIS

  use Gramene::Test;

=head1 DESCRIPTION

Description of module goes here.

=head1 SEE ALSO

perl.

=head1 AUTHOR

Ken Youens-Clark E<lt>kclark@cshl.eduE<gt>.

=head1 COPYRIGHT

Copyright (c) 2007 Cold Spring Harbor Laboratory

This library is free software;  you can redistribute it and/or modify 
it under the same terms as Perl itself.

=cut

# ----------------------------------------------------

use strict;
use Exporter qw( import );
use File::Spec::Functions qw( catfile );
use FindBin qw( $Bin );
use Gramene::Config;
use Gramene::CDBI::Markers;
use Readonly;

use vars qw( @EXPORT_OK );

@EXPORT_OK = qw( set_conf_path setup_marker_db );

Readonly my $VERSION => sprintf "%d.%02d", q$Revision: 1.1 $ =~ /(\d+)\.(\d+)/;

sub set_conf_path {
    my $conf_path = catfile( $Bin, 'data', 'testing.conf' );
    $ENV{'GrameneConfPath'} = $conf_path;
}

sub setup_marker_db {
    my $db = shift;

    $db->do('set foreign_key_checks=0');

    for my $table ( Gramene::CDBI::Markers::Marker->represented_tables ) {
        $db->do("truncate table $table");
    }

    Gramene::CDBI::Markers::Species->create({ 
        species_id => 1,
        species    => 'UNKNOWN',
    });

    Gramene::CDBI::Markers::Germplasm->create({ 
        species_id     => 1,
        germplasm_name => 'UNKNOWN',
    });

    Gramene::CDBI::Markers::MarkerType->create({ 
        marker_type_id => 1,
        marker_type    => 'Undefined',
    });

    Gramene::CDBI::Markers::SynonymType->create({ 
        synonym_type_id => 1,
        synonym_type    => 'UNKNOWN',
    });

    return 1;
}

1;
