#!/usr/local/bin/perl
# vim: set ft=perl:

use strict;
use Cwd qw( cwd );
use File::Spec::Functions qw( catfile );
use FindBin qw( $Bin );
use Gramene::DB;
use Test::More tests => 11;

use lib "$Bin/tlib";
use GrameneTest qw( set_conf_path setup_marker_db );

set_conf_path();

use_ok('Gramene::Marker::Import');
use_ok('Gramene::Marker::Import::Tab');

my $importer = Gramene::Marker::Import->new;
isa_ok( $importer, 'Gramene::Marker::Import');

# 
# Tab file import
# 
my $db = Gramene::DB->new('markers');
ok( setup_marker_db($db), 'Setup test db' );

my $mdb  = Gramene::Marker::DB->new;
my @ssrs = $mdb->marker_search(
    marker_type => 'SSR',
);
is( scalar @ssrs, 0, 'Found no SSRs' );

my $ssr_data = catfile( $Bin, 'data', 'ssr.tab' );
ok( $importer->import_data( files => $ssr_data, verbose => 0 ), 
    'Import tab file' );

@ssrs = $mdb->marker_search(
    marker_type => 'SSR',
);
is( scalar @ssrs, 1, 'Found 1 SSR' );

my $ssr = shift @ssrs;
is( $ssr->{'marker_name'}, 'RM22', 'Found RM22' );

my $Marker = Gramene::CDBI::Markers::Marker->retrieve($ssr->{'marker_id'});
my $Details 
    = Gramene::CDBI::Markers::MarkerDetailsSsr->retrieve($ssr->{'marker_id'});
is(
    join(',', sort map { $_->marker_name } $Marker->marker_synonyms),
    'AF344022,GA580,RM22',
    'Synonyms'
);

is( $Details->anneal_temperature, '55', 'Anneal temp' );

is( $Details->repeat_motif, '(GA)22', 'Repeat mofit' );

