#!/usr/local/bin/perl
# vim: set ft=perl:

use strict;
use Cwd qw( cwd );
use File::Spec::Functions qw( catfile );
use FindBin qw( $Bin );
use Gramene::DB;
use Test::More tests => 5;

use lib "$Bin/tlib";
use GrameneTest qw( set_conf_path setup_marker_db );

set_conf_path();

use_ok('Gramene::Marker::Import');
use_ok('Gramene::Marker::Import::GenBank');

my $importer = Gramene::Marker::Import->new;
isa_ok( $importer, 'Gramene::Marker::Import');

my $db = Gramene::DB->new('markers');
ok( setup_marker_db($db), 'Setup test db' );

Gramene::CDBI::Markers::Species->find_or_create(
    species => 'Arabidopsis thaliana',
);

my $gb_file = catfile( $Bin, 'data', 'genbank-test.seq' );
ok( $importer->import_data( files => $gb_file, verbose => 1 ), 
    'Import GenBank file' );
