#!/usr/local/bin/perl

use strict;
use lib '/usr/local/gramene/lib/perl';
BEGIN { use Basset::Object;
use Gramene::Config;
use Gramene::FAQ::FAQ;
use Gramene::FAQ::Question;


my $config = Gramene::Config->new();
my $faq_config = $config->get('faq_edit');

Basset::Object->conf->{'Basset::DB'}->{'-dsn'} = $faq_config->{'db_dsn'};
Basset::Object->conf->{'Basset::DB'}->{'-user'} = $faq_config->{'db_user'};
Basset::Object->conf->{'Basset::DB'}->{'-pass'} = $faq_config->{'db_pass'};
}

use Cwd;
use Readonly;
use File::Spec::Functions;
use Perl6::Slurp qw( slurp );
use Template;

Readonly my $FOM_DIR  => '/usr/local/gramene/html/fom/item';
Readonly my $POD_DIR  => '/home/kclark/apache/htdocs/pod';
Readonly my $HTML_DIR => '/home/kclark/apache/htdocs/pod';

my %files;
my $num_files = 0;

opendir my $dir, $FOM_DIR or die $!;
while ( my $file = readdir $dir ) {
    next unless $file =~ /^\d+$/;

    my $path = catfile( $FOM_DIR, $file );
    my $data = slurp( $path );

    my $parent;
    if ( $data =~ /^Parent:\s+(\d+)/m ) {
        $parent = $1;
    }

    my $title;
    if ( $data =~ /^Title:\s+([^\n]+)/m ) {
        $title = $1;
    }

    my $content  = '';
    my @answers  = ();
    my @lines    = split /\n/, $data;
    my $cur_line = 0;

    for my $line ( @lines ) {
        $cur_line++;
        if ( $line =~ /^Lines:\s+(\d+)/ && !$content && $file != 1 ) {
            my $num_lines = $1 - 1;
            $content = join("\n", @lines[$cur_line .. $cur_line + $num_lines]);
        }
        elsif ( $line =~ /^<faqomatic:(\d+)>/ ) {
            push @answers, $1;
        }
    }

    $content =~ s/[^[:ascii:]]//g;
    $content =~ s/Subcategories:\s*Answers in this category:\s*[^>]*>//g;
    $content =~ s/[<]faqomatic:\d+[>]//g;

    $files{ $file } = {
        title   => $title,
        parent  => $parent,
        content => $content,
        answers => \@answers,
    };
#print "D $title, $parent, $content, @answers\n";

#    last if $num_files++ > 5;
}
closedir $dir;

#print Dumper(\%files); use Data::Dumper;

foreach my $faq_id (@{ $files{'1'}->{'answers'} } ) {
    my $faq = Gramene::FAQ::FAQ->create(
        'name' => $files{$faq_id}->{'title'},
        'user_id' => 1,
    ) or die Gramene::FAQ::FAQ->errstring;
    my $num = 1;
print "created faq : ", $faq->name, "\n";
    foreach my $q_id (@{ $files{$faq_id}->{'answers'} }) {
        if ($files{$q_id}->{'parent'} == $faq_id) {
            $files{$q_id}->{'content'} =~ s!http(s?)://([^\s(),]+[\w/])!l{http$1://$2}!g;
            Gramene::FAQ::Question->create(
                'faq_id' => $faq->faq_id,
                'number' => $num++,
                'question' => $files{$q_id}->{'title'},
                'answer' => $files{$q_id}->{'content'},
            ) or die Gramene::FAQ::Question->errstring;
            print "\tloaded Q $num\n";
        }
    }

}

