#!/usr/local/bin/perl

use strict;
use warnings;
use Gramene::DB;
use Gramene::CDBI::Qtl;
use Gramene::CDBI::Ontology;
use Text::RecordParser::Tab;

my $file = shift or die 'No file';
my $p    = Text::RecordParser::Tab->new( $file );
my $qdb  = Gramene::DB->new('qtl');

my %xref_type_id
    = map { $_->xref_type, $_->id } Gramene::CDBI::Qtl::XrefType->retrieve_all;

my ( $num_assocs, $i ) = ( 0, 0 );
RECORD:
while ( my $rec = $p->fetchrow_hashref ) {
    $i++;
    my $qtl_acc  = $rec->{'feature_accession_id'} 
                || $rec->{'qtl_accession_id'};

    if ( $qtl_acc =~ /^([A-Z0-9]+).*/ ) {
        $qtl_acc = $1;
    }
    else {
        print STDERR "Bad QTL accession '$qtl_acc'\n";
        next RECORD;
    }

    my ($Qtl) = Gramene::CDBI::Qtl::Qtl->search( 
        qtl_accession_id => $qtl_acc
    ) or die "Can't find QTL '$qtl_acc'\n";

    my @lit_ids;
    if ( my $lit_id = $rec->{'gramene_reference_id'} ) {
        @lit_ids = ( $lit_id );
    }
    else {
        @lit_ids = @{ $qdb->selectcol_arrayref(
            q[
                select x.xref_value
                from   xref x, xref_type xt
                where  x.record_id=?
                and    x.xref_type_id=xt.xref_type_id
                and    xt.xref_type=?
            ],
            {},
            ( $Qtl->id, 'Gramene Literature' )
        ) };
    }

    my @ont_accs;
    for my $arg ( qw[ po_id plant_structure po_gs_id_name
        plant_growth_and_development_stage gro
    ] ) {
        my $ont_acc = $rec->{ $arg } or next;
        for my $o ( split /,\s*/, $ont_acc ) {
            $o =~ /((?:PO|GRO):[^:]+)/;
            push @ont_accs, $o;
        }
    }

    my @onts;
    for my $ont_acc ( @ont_accs ) {
        my ($Ont) = Gramene::CDBI::Ontology::Term->search( 
            term_accession => $ont_acc,
        ) or die "No ontology term '$ont_acc'\n";

        push @onts, {
            term_accession => $ont_acc,
            term_type      => $Ont->term_type->term_type,
        };
    }

    for my $lit_id ( @lit_ids ) {
        for my $ont ( @onts ) {
            $num_assocs++;
            print "$num_assocs: $qtl_acc (", $Qtl->id, ") => '",
                $ont->{'term_accession'}, "' (lit '$lit_id')\n";

            my $Assoc 
            = Gramene::CDBI::Qtl::QtlOntologyAssociation->find_or_create({
                qtl_id         => $Qtl->id,
                term_type      => $ont->{'term_type'},
                term_accession => $ont->{'term_accession'},
            }); 

            my $Evidence =
            Gramene::CDBI::Qtl::QtlOntologyAssociationEvidence->find_or_create({
                qtl_ontology_association_id => $Assoc->id,
                evidence_code               => 'SM',
                gramene_reference_id        => $lit_id,
            }); 
        }
    }
}

print "Done, processed $i records, created $num_assocs associations.\n";
