#!/usr/local/bin/perl

use strict;
use warnings;
use Data::Dumper;
use Gramene::CDBI::Qtl;
use Text::RecordParser::Tab;
use Readonly;

Readonly my @CEREALS => ( 'wheat', 'tetraploid wheat', 'barley', 'oat' );

my $file = shift or die 'No file';
my $p    = Text::RecordParser::Tab->new( $file );

my %Species = map { lc $_->common_name, $_->id } 
    Gramene::CDBI::Qtl::Species->retrieve_all;

my $i;
while ( my $rec = $p->fetchrow_hashref ) {
    $i++;
    my $to_acc = $rec->{'to_accession'};

    for my $fld_name ( grep { /^(p|gr)o/ } $p->field_list ) {
        my @ont_accs = ( split /,\s*/, $rec->{ $fld_name } ) or next;
        my @f        = split /_/, $fld_name;
        my @species  = ( 
            $f[-1] eq 'id' 
            ? '' 
            : $f[-1] eq 'cereals' ? @CEREALS : $f[-1] 
        );

        for my $ont_acc ( @ont_accs ) {
            for my $species ( @species ) {
                next if $species && $species ne 'rice';
                my $species_id = $Species{ $species } || 0;
                print "$i: '$to_acc' => '$ont_acc' ($species: $species_id)\n";
                my $Assoc 
                = Gramene::CDBI::Qtl::TraitOntologyAssociation->find_or_create({
                    to_accession      => $to_acc,
                    related_accession => $ont_acc,
                    species_id        => $species_id,
                }); 
            }
        }
    }
}

print "Done, processed $i records.\n";
