#!/usr/local/bin/perl

use strict;
use warnings;
use Getopt::Long;
use Gramene::CDBI::Qtl;
use Gramene::CDBI::Ontology;

my $to_accessions = '';
GetOptions(
    't|to_accessions:s' => \$to_accessions,
);

my %to_accession = map { $_, 1 } split /,\s*/, $to_accessions;
use Data::Dumper 'Dumper';
warn "data = ", Dumper(\%to_accession), "\n";

my @Qtls = Gramene::CDBI::Qtl::Qtl->retrieve_all;

my ( $num_qtls, $num_added, $num_assoc_added ) = ( 0, 0, 0 );
QTL:
for my $Qtl ( @Qtls ) {
    $num_qtls++;

    my $to_accession = $Qtl->qtl_trait->to_accession;
    if ( %to_accession ) {
        next QTL if !$to_accession{ $to_accession };
    }

    my @Assoc = Gramene::CDBI::Qtl::QtlOntologyAssociation->search(
        qtl_id => $Qtl->id,
    );

    next QTL if @Assoc;

    @Assoc = Gramene::CDBI::Qtl::TraitOntologyAssociation->search(
        to_accession => $to_accession,
    ) or next QTL;

    $num_added++;

    ASSOC:
    for my $Assoc ( @Assoc ) {
        if ( $Assoc->species_id && $Assoc->species_id != $Qtl->species_id ) {
            next ASSOC;
        }

        my ($Ont) = Gramene::CDBI::Ontology::Term->search(
            term_accession => $Assoc->related_accession
        );

        if ( !$Ont ) {
            printf STDERR "Ontology accession '%s' not valid!\n",
                $Assoc->related_accession;
            next ASSOC;
        }

        printf "%s (%s) => %s (%s)\n",
            $Qtl->qtl_accession_id,
            $Qtl->qtl_trait->trait_name,
            $Assoc->related_accession,
            $Ont->term_type->term_type,
        ;

        my $QtlAssoc 
        = Gramene::CDBI::Qtl::QtlOntologyAssociation->find_or_create({
            qtl_id         => $Qtl->id,
            term_type      => $Ont->term_type->term_type,
            term_accession => $Assoc->related_accession,
        }); 

        my $Evidence 
        = Gramene::CDBI::Qtl::QtlOntologyAssociationEvidence->find_or_create({
            qtl_ontology_association_id => $QtlAssoc->id,
            evidence_code               => 'IC',
            gramene_reference_id        => 11453,
        }); 

        $num_assoc_added++;
    }
}

print "Done, examined $num_qtls QTLs, added $num_assoc_added ",
    "associations for $num_added.\n";
