#!/bin/bash

DATE=$1
MARKERSDB=$2

if test ! $DATE
then
    echo "Need a date"
    exit;
fi

if test ! $MARKERSDB
then
    echo "Need a markers db to load into"
    exit;
fi

echo "DATE IS $DATE, Markersdb is $MARKERSDB";

RUN_NAME=GB_markers_update_${DATE}
WK_DIR=/scratch/weix-tmp/${RUN_NAME}-2riceTIGRV4/

GB_DS=( Oryza_coding NonOryza_coding Oryza_GSS NonOryza_GSS )

cd $WK_DIR

for ds_root in ${GB_DS[@]}
do 
  ds=${ds_root}-$DATE
  echo "processing $ds"

  perl /home/weix/gramene/scripts/markers/convert_mapping_4import.pl -m 'gt0506' -ensembl -no-prompt -marker_id_required -analysis_name ${ds_root} -date_created $DATE final_filtered_${ds}.dat 

  /usr/local/mysql/bin/mysqlimport -c "marker_id,map_id,display_synonym_id,start,end,strand,marker_start,marker_end,marker_strand,cigar_line,score,percent_identity,analysis_id,date_created" -L --ignore-lines=1 --ignore -u markers_rw -p'()ryz@' -h cabot $MARKERSDB mapping.dat

  perl /home/weix/gramene/scripts/markers/create_mapping_4failed.pl -marker_id_required -no-prompt -m 'gt0506' -analysis_name ${ds_root} -date_created $DATE fail_mapped_${ds}.dat
  
  /usr/local/mysql/bin/mysqlimport -c"marker_id,map_id,display_synonym_id,start,end,strand,marker_start,marker_end,marker_strand,analysis_id,date_created" -L --ignore-lines=1 --ignore -u markers_rw -p'()ryz@' -h cabot $MARKERSDB mapping.notmapped_dat

done

echo "Start updating ensembl database"

#Note: the $DATE here is the markers update date, which is earlier than the mapping table update date, as long as there is no other process populating mapping table, this should be fine

perl  /home/weix/gramene/scripts/markers/import_mapping_markersdb2ensembl.pl -species rice -source entrez -mapset_acc gt0506 -date_created $DATE -dir /scratch/weix-tmp/load_markersdb_mappings2ensembl -no_prompt

perl  /home/weix/gramene/scripts/markers/import_mapping_markersdb2ensembl.pl -species rice -source entrez-OMAP -mapset_acc gt0506 -date_created $DATE -dir /scratch/weix-tmp/load_markersdb_mappings2ensembl -no_prompt

#This script use Ensembl API to load mapping, too slow, eventually lost connection to db
#perl /home/weix/gramene/scripts/markers/load_mapping_2ensembl.pl -species rice -source entrez -mapset_acc gt0506 -replace -dir /scratch/weix-tmp/load_markersdb_mappings2ensembl -no_prompt
#perl  /home/weix/gramene/scripts/markers/import_mapping_markersdb2ensembl.pl -species rice -source entrez -mapset_acc gt0506 -replace -dir /scratch/weix-tmp/load_markersdb_mappings2ensembl -no_prompt 

#perl  /home/weix/gramene/scripts/markers/import_mapping_markersdb2ensembl.pl -species rice -source entrez -mapset_acc gt0506 -date_created 20070129 -dir /scratch/weix-tmp/load_markersdb_mappings2ensembl -no_prompt -exclude Barley_est &
