# SQL to dump a FASTA file of all Oryza-genus EST markers
# that do not have an entry in the mapping table
# Use 'mysql --raw' to maintain the newline twixt header and seq. 
SELECT concat( ">",
               ms.marker_name," [dbID:",
               m.marker_id,"] type=",
               mt.marker_type," species=",
               s.species,"\n",
               md.sequence ) as fasta
FROM   marker m left join mapping ma on m.marker_id=ma.marker_id,
       marker_synonym ms,
       marker_details_est md,
       marker_type mt,
       species s
WHERE  m.marker_type_id=mt.marker_type_id
AND    m.display_synonym_id=ms.marker_synonym_id
AND    m.marker_id=md.marker_id
AND    m.source_species_id=s.species_id
AND    marker_type='est'
AND    species NOT LIKE "Oryza%"
AND    ma.marker_id is NULL
#LIMIT 10
;
