#!/usr/local/bin/perl
#Initially developed under /lab/bin/perl 

=head1 NAME

dump_QTL_from_markers.pl -conf_file /usr/loca/gramene/conf/gramene.conf   -out_file out
 
dump the QTL mappings from markers db, output the format for load_dna_align_feature.pl to load into ensembl db

Query to get QTL mappings:

select count(m.mapping_id), a.analysis_name
from   mapping m, analysis a
where  m.analysis_id=a.analysis_id
and    a.analysis_name in ('Gramene_inferred_QTL', 'Gramene_estimated_QTL') group by 2


=cut


BEGIN {
    $ENV{'GrameneDir'} ||= '/usr/local/gramene/'; 
    $ENV{'GrameneEnsemblDir'} ||= '/usr/local/'; 
}

# The first shall be last...
use lib map { $ENV{'GrameneDir'}."/$_" } qw ( lib/perl );

use lib map { $ENV{'GrameneEnsemblDir'}."/$_" } 
        qw ( bioperl-live modules ensembl/modules conf
	     ensembl-external/modules ensembl-draw/modules
	     ensembl-compara/modules );

use lib map { $ENV{'GrameneEnsemblDir'}."/ensembl-live/$_" } 
        qw ( bioperl-live modules ensembl/modules ensembl-external/modules
             ensembl-draw/modules ensembl-compara/modules );

use strict;
use warnings;


use Getopt::Long;
use Pod::Usage;

use Gramene::Config;
use DBI;
use Bio::EnsEMBL::Registry;
use Gramene::Marker::DB;

use Carp;
use Text::RecordParser;

use Data::Dumper qw(Dumper);

=head1 SYNOPSIS

dump_QTL_from_markers.pl  [options] 
 
 Options:

     --conf_file         Default is $GrameneDir/conf/gramene.conf
     --out_file          The output file name
     --help              help message
     --man               full documentation




=head1 OPTIONS

=over 4

=item B<--conf_file>

The configuration file for markers db

=item B<--out_file>

The output file


=item B<--help> 

print a help message and exit

=item B<--man> 

print documentation and exit

    
=back

=head1 ARGUMENTS

NONE

=cut

#global var
#my $ensembl_species=$ENV{ENSEMBL_SPECIES};


my $QUERY = qq{
               select m.* from mapping m, analysis a
               where  m.analysis_id=a.analysis_id
               and    a.analysis_name in ('Gramene_inferred_QTL', 'Gramene_estimated_QTL') 
             };


my $conf_file;
my $verbose;
my $out_file;
#my ($species, $mapset_acc);

my %all_mappings_for_a_qtl;

{  #Argument Processing
  my $help = 0;
  my $man  = 0;
  GetOptions( "help|?"          => \$help,
	      "man"             => \$man,
#	      "species=s"       => \$species,
#	      "cmap_map_set_accession" => \$mapset_acc,
	      "conf_file=s" => \$conf_file,
#	      "QTL_file=s"      => \$QTL_file,
	      "out_file=s"      => \$out_file,
	      "verbose|?"       => \$verbose,
	    )
    or pod2usage(2);

  pod2usage(-verbose => 2) if $man;
  pod2usage(1) if $help;
 
}

my $LOG;
if($out_file){
  open $LOG, ">$out_file" or die "Cannot write to $out_file";
}else{
  open $LOG, ">&STDOUT" or die "Cannot output to STDOUT";
}


$conf_file  && do{$ENV{GrameneConfPath} = $conf_file};
my $MDB     = Gramene::Marker::DB->new;
my $dbh     = $MDB->db;

my $sth = $dbh->prepare($QUERY) or die "Cannot prepare for $QUERY";
$sth->execute()or die "Cannot excute $QUERY";


my($marker_id, $map_id, $start, $end, $strand, $marker_start, $marker_end);
my %map_names;
my $count = 0;
my $syno_type_id_qtl_acc = $MDB->get_synonym_type_id('QTL_ACCESSION');
my $syno_type_id_qtl_trait = $MDB->get_synonym_type_id('TRAIT_SYMBOL');
my $syno_type_id_unknown = $MDB->get_synonym_type_id('UNKNOWN');

#print "type_ids = $syno_type_id_qtl_acc, $syno_type_id_qtl_trait\n";
my $a_mapping;
while ($a_mapping = $sth->fetchrow_hashref){
  
  ($marker_id, 
   $map_id, 
   $start, 
   $end, 
   $strand, 
   $marker_start, 
   $marker_end) = (
		   $a_mapping->{marker_id},
		   $a_mapping->{map_id},
		   $a_mapping->{start},
		   $a_mapping->{end},
		   $a_mapping->{strand},
		   $a_mapping->{marker_start},
		   $a_mapping->{marker_end}
		  );

  #print "$marker_id,  map_id = $map_id\n";
  unless($map_names{$map_id}){
    my $map_name = $MDB->retrieve_Map($map_id)->map_name();
    $map_name =~ s/chr\.\s+//i;
    $map_names{$map_id} = $map_name;
  }

  my %marker_synos = map{ $_->{synonym_type_id} => $_->{marker_name} }
    grep{  $_->{synonym_type_id} == $syno_type_id_unknown }
    @{$MDB->get_marker_synonyms( marker_id => $marker_id )};
 # next;
  #my $qtl_name = "$marker_synos{$syno_type_id_qtl_acc}-$marker_synos{$syno_type_id_qtl_trait}";

  #HIT_ID  HIT_NAME        CHR STRAND  HIT_START       HIT_STOP        CHR_START       CHR_STOP        SCORE   PERC_ID CIGAR_LINE
  
  my $len = abs($end - $start) + 1;
  if( !$marker_start || !$marker_end){
    $marker_start = 1;
    $marker_end   = $len;
  }

  $strand ||= 1;
  my $out_str     = join "\t", (++$count,
				$marker_synos{$syno_type_id_unknown},
				$map_names{$map_id},
				$strand,
				$marker_start,
				$marker_end,
				$start,
				$end,
				100, 100, "${len}M\n",
			       );

  print $LOG $out_str;
}



__END__




