# get the reference used by qtl in qtl db

#!/usr/local/bin/perl -w

use strict;
use DBI;
use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;


my $dsn=$config{'db_qtl'}->{'db_dsn'};

my $db=$config{'db_qtl'}->{'db_user'};

my $password=$config{'db_qtl'}->{'db_pass'};


my $dbh  = DBI->connect($dsn,$db,$password,$config{'db_opts'});



my $sql = qq[
	     select qtl_id,qtl_accession_id,x.xref_value
	     from qtl, xref_type xt, xref x 
	     where xt.xref_type_id = x.xref_type_id
	     and x.table_name='qtl'
	     and xt.xref_type = 'Gramene Literature'
	     and qtl.qtl_id=x.record_id
            ];


my $sth1 = $dbh->prepare($sql );
$sth1->execute();

my %refid_to_qtl;
while( my ($qtl_id,$qtl_acc,$ref)  = $sth1->fetchrow_array ) {

    $refid_to_qtl{$ref}->{$qtl_id}=$qtl_acc;
  
}

my $objxref_file="./ref_to_qtl/ref_to_qtl.txt"; 
open(RFL_OBJX,">$objxref_file") or die "cannot open $objxref_file for writing: $!"; 


foreach my $ref_id (keys %refid_to_qtl){

    my $qtlsRef = $refid_to_qtl{$ref_id};
    foreach my $qtl_id (keys %$qtlsRef){
      print RFL_OBJX "$ref_id\t$qtl_id\t$qtlsRef->{$qtl_id}\n";

    }

}



close (RFL_OBJX ) or die "can't close $objxref_file: $!\n"; 
############################################
$dbh->disconnect || warn $dbh->errstr;

exit;
