# get the reference used by gene in gene db

#!/usr/local/bin/perl -w

use strict;
use DBI;
use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;


my $dsn=$config{'db_genes'}->{'db_dsn'};

my $db=$config{'db_genes'}->{'db_user'};

my $password=$config{'db_genes'}->{'db_pass'};


my $dbh  = DBI->connect($dsn,$db,$password,$config{'db_opts'});



my $sql = qq[
	     select gene_id,accession,dto.dbxref_value
	     from gene_gene, gene_dbxref d, gene_dbxref_to_object dto
	     where d.dbxref_id=dto.dbxref_id
	     and dto.table_name='gene'
	     and dbxref_name = 'Gramene Literature'
	     and gene_gene.gene_id=dto.record_id
            ];


my $sth1 = $dbh->prepare($sql );
$sth1->execute();

my %refid_to_gene;
while( my ($gene_id,$gene_acc,$ref)  = $sth1->fetchrow_array ) {

    $refid_to_gene{$ref}->{$gene_id}=$gene_acc;
  
}

my $objxref_file="./ref_to_genes/ref_to_genes.txt"; 
open(RFL_OBJX,">$objxref_file") or die "cannot open $objxref_file for writing: $!"; 


foreach my $ref_id (keys %refid_to_gene){

    my $genesRef = $refid_to_gene{$ref_id};
    foreach my $gene_id (keys %$genesRef){
      print RFL_OBJX "$ref_id\t$gene_id\t$genesRef->{$gene_id}\n";

    }

}



close (RFL_OBJX ) or die "can't close $objxref_file: $!\n"; 
############################################
$dbh->disconnect || warn $dbh->errstr;

exit;
