# get the reference used by markers in markers db

#!/usr/local/bin/perl -w

use strict;
use DBI;
use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;


my $dsn=$config{'db_markers'}->{'db_dsn'};

my $db=$config{'db_markers'}->{'db_user'};

my $password=$config{'db_markers'}->{'db_pass'};


my $dbh  = DBI->connect($dsn,$db,$password,$config{'db_opts'});


my $table_name = 'marker';
my $xref_type = 'Gramene Literature';

my $sql = qq[
	     select record_id,xref_value
	     from xref, xref_type 
	     where xref.xref_type_id = xref_type.xref_type_id 
	     and table_name= ?
	     and xref_type = ? 
            ];


my $sth1 = $dbh->prepare($sql );
$sth1->execute(($table_name,$xref_type));

my %refid_to_markers;
while( my ($markers_id,$ref)  = $sth1->fetchrow_array ) {

    $refid_to_markers{$ref}->{$markers_id}=1;
  
}

my $objxref_file="./ref_to_markers/ref_to_markers.txt"; 
open(RFL_OBJX,">$objxref_file") or die "cannot open $objxref_file for writing: $!"; 


foreach my $ref_id (keys %refid_to_markers){

    my $markerssRef = $refid_to_markers{$ref_id};
    foreach my $markers_id (keys %$markerssRef){
      print RFL_OBJX "$ref_id\t$markers_id\n";

    }

}



close (RFL_OBJX ) or die "can't close $objxref_file: $!\n"; 
############################################
$dbh->disconnect || warn $dbh->errstr;

exit;
