#!/usr/local/bin/perl -w

use strict;
use DBI;
use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;


my $dsn=$config{'db_new_build'}->{'db_dsn'};

my $db=$config{'db_new_build'}->{'db_user'};

my $password=$config{'db_new_build'}->{'db_pass'};


my $dbh  = DBI->connect($dsn,$db,$password,$config{'db_opts'});
$dbh->{AutoCommit} = 0;


my $objxref_file="./ref_to_diversity/ref_to_div_exp.txt"; 
open(RFL_OBJX,"$objxref_file") or die "cannot open $objxref_file for writing: $!"; 

my $out_dbx_file = './ref_to_diversity/db_dbxref.txt';
open(OUT_DBX,">$out_dbx_file") or die "$!";
my $out_obx_file = './ref_to_diversity/db_objxref.txt';
open(OUT_OBX,">$out_obx_file") or die "$!";


my $xref_dbname = 'gramene.diversity.experiment';
my $xref_keytype = 'id';
my $table_name = 'gramene.literature';

my $dbxrefs = $dbh->selectall_hashref(
    q[
	SELECT dbxref_id FROM dbxref
	WHERE  xref_dbname = ?
	AND    xref_keytype = ?
    ],'dbxref_id', {}, ($xref_dbname,$xref_keytype));

my $sth_dbxref = $dbh->prepare(
    q[
            INSERT INTO dbxref (dbxref_id,xref_key,xref_keytype,xref_dbname)
	    VALUES (?,?,?,?)
    ]);

my $sth_objxref = $dbh->prepare(
    q[
            INSERT INTO objectxref (objectxref_id,table_name,row_id,dbxref_id)
	    VALUES (?,?,?,?)
    ]);

my ($dbxref_id) = $dbh->selectrow_array('select max(dbxref_id) from dbxref') || 0;
my ($objx_id) = $dbh->selectrow_array('select max(objectxref_id) from objectxref') || 0;


eval{


    foreach my $dbxref_id (keys %$dbxrefs){
	$dbh->do(
	    q[
		DELETE FROM objectxref
		WHERE  dbxref_id = ?
		AND    table_name = ?
	    ],{},($dbxref_id,$table_name)
	);

	$dbh->do(
	    q[
		DELETE FROM dbxref
		WHERE  dbxref_id = ?
	    ], {}, ($dbxref_id)
	);

    }

  while(<RFL_OBJX>){
     chomp;
     next if /^!/; 
     my($ref_id,$diversity_exp_id) = split/\t/;
     unless($ref_id =~/\D+/){ 
	 my ($dbx_id ) = $dbh->selectrow_array(
	    q[
		SELECT dbxref_id FROM dbxref
		WHERE xref_key = ?
		AND   xref_dbname = ?
		AND   xref_keytype = ?
	    ],{},($diversity_exp_id,$xref_dbname,$xref_keytype));

	unless($dbx_id){
	    $dbxref_id ++;
	    $sth_dbxref->execute(($dbxref_id,$diversity_exp_id,$xref_keytype,$xref_dbname)) or die $dbh->errstr;
	    print OUT_DBX join("\t",($dbxref_id,$diversity_exp_id,$xref_keytype,$xref_dbname)),"\n";
	    $dbx_id = $dbxref_id;
	}

	$objx_id ++;
	$sth_objxref->execute(($objx_id, $table_name,$ref_id,$dbx_id)) or die $dbh->errstr;
	print OUT_OBX join("\t",($objx_id, $table_name,$ref_id,$dbx_id)), "\n";
     
    }	    
  }
  $dbh->commit();
 print "Loading done\n"; 
};
if($@){
  warn "Unable to save to database: $@\n";
  $dbh->rollback();
}
close(OUT_DBX);
close(OUT_OBX);

close (RFL_OBJX ) or die "can't close $objxref_file: $!\n"; 
############################################
$dbh->disconnect || warn $dbh->errstr;
exit;
