# get the reference used by gene in gene db

#!/usr/local/bin/perl -w

use strict;
use DBI;
use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;


my $dsn=$config{'db_diversity'}->{'db_dsn'};

my $db=$config{'db_diversity'}->{'db_user'};

my $password=$config{'db_diversity'}->{'db_pass'};


my $dbh  = DBI->connect($dsn,$db,$password,$config{'db_opts'});



my $sql = qq[
	     select x.record_id as div_experiment_id, x.xref_value as ref_id 
	     from xref x, xref_type xt
	     where x.xref_type_id=xt.xref_type_id
	     and   x.table_name='div_experiment'
	     and   xt.xref_type like 'Gramene Literature%'
            ];


my $sth1 = $dbh->prepare($sql );
$sth1->execute();

my %refid_to_div;
while( my ($div_exp_id,$ref)  = $sth1->fetchrow_array ) {

    $refid_to_div{$ref}->{$div_exp_id}=1;
  
}

my $objxref_file="./ref_to_diversity/ref_to_div_exp.txt"; 
open(RFL_OBJX,">$objxref_file") or die "cannot open $objxref_file for writing: $!"; 


foreach my $ref_id (keys %refid_to_div){

    my $divsRef = $refid_to_div{$ref_id};
    foreach my $div_id (keys %$divsRef){
      print RFL_OBJX "$ref_id\t$div_id\n";

    }

}



close (RFL_OBJX ) or die "can't close $objxref_file: $!\n"; 
############################################
$dbh->disconnect || warn $dbh->errstr;

exit;
