# get the reference used by maps in markers db

#!/usr/local/bin/perl -w

use strict;
use DBI;
use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;


my $dsn=$config{'db_markers'}->{'db_dsn'};

my $db=$config{'db_markers'}->{'db_user'};

my $password=$config{'db_markers'}->{'db_pass'};


my $dbh  = DBI->connect($dsn,$db,$password,$config{'db_opts'});


my $table_name = 'map_set';
my $xref_type = 'Gramene Literature';

my $sql = qq[
	     select xref_value,cmap_map_set_accession
	     from xref X, xref_type XT, map_set M 
	     where X.xref_type_id = XT.xref_type_id 
	     and X.record_id = M.map_set_id
	     and table_name= ?
	     and xref_type = ? 
            ];


my $sth1 = $dbh->prepare($sql );
$sth1->execute(($table_name,$xref_type));

my %refid_to_maps;
while( my ($ref, $cmap_map_set_acc)  = $sth1->fetchrow_array ) {
    next unless $cmap_map_set_acc;
    $refid_to_maps{$ref}->{$cmap_map_set_acc}=1;
  
}

my $objxref_file="./ref_to_cmap/ref_to_cmap.txt"; 
open(RFL_OBJX,">$objxref_file") or die "cannot open $objxref_file for writing: $!"; 


foreach my $ref_id (keys %refid_to_maps){

    my $mapsRef = $refid_to_maps{$ref_id};
    foreach my $map_acc (keys %$mapsRef){
      print RFL_OBJX "$ref_id\t$map_acc\n";

    }

}



close (RFL_OBJX ) or die "can't close $objxref_file: $!\n"; 
############################################
$dbh->disconnect || warn $dbh->errstr;

exit;
