#!/bin/perl -w

use strict;

use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;

my $current_db=$config{'db_last_build'}->{'db_user'};
my $current_db_pass=$config{'db_last_build'}->{'db_pass'};

my $new_db=$config{'db_new_build'}->{'db_user'}; 
my $new_db_pass=$config{'db_new_build'}->{'db_pass'}; 

my $schema=$config{'db_schema'}; 
my $date=$config{'date'};


&make_copy_ref_script();

&make_ref_to_qtl_script();
&make_ref_to_protein_script();
&make_ref_to_markers_script();
&make_ref_to_cmap_script();

########################################################


########################################################
sub make_copy_ref_script{

 my $out_file = "copy_ref.script";
 open (OUT, ">$out_file") || die "cannot open $out_file for writing: $!";


 print OUT ( "perl ./copy_ref/make_cp_ref_sql.pl\n" );


 print OUT ( "sqlplus $new_db/$new_db_pass <./copy_ref/insert_ref_tables.sql\n\n" );
 
 print OUT ("./copy_ref/update_dbxref_objxref.pl\n\n");

 print OUT ( "exit 0\n" ); 

 close(OUT) || die "can't close $out_file: $!\n";

 system("chmod","755","copy_ref.script");

}


sub make_ref_to_qtl_script{

 my $out_file = "ref_to_qtl.script";
 open (OUT, ">$out_file") || die "cannot open $out_file for writing: $!";
print OUT <<SCRIPT;

./ref_to_qtl/get_qtl_ref.pl

./ref_to_qtl/load_ref_to_qtl.pl

SCRIPT

 close(OUT) || die "can't close $out_file: $!\n";

 system("chmod","755","$out_file");

}


sub make_ref_to_protein_script{

 my $out_file = "ref_to_protein.script";
 open (OUT, ">$out_file") || die "cannot open $out_file for writing: $!";
print OUT <<SCRIPT;

./ref_to_protein/get_protein_ref.pl

./ref_to_protein/load_ref_to_protein.pl

SCRIPT

 close(OUT) || die "can't close $out_file: $!\n";

 system("chmod","755","$out_file");

}



sub make_ref_to_markers_script{

 my $out_file = "ref_to_markers.script";
 open (OUT, ">$out_file") || die "cannot open $out_file for writing: $!";
print OUT <<SCRIPT;

./ref_to_markers/get_markers_ref.pl

./ref_to_markers/load_ref_to_markers.pl

SCRIPT

 close(OUT) || die "can't close $out_file: $!\n";

 system("chmod","755","$out_file");

}



sub make_ref_to_cmap_script{

 my $out_file = "ref_to_cmap.script";
 open (OUT, ">$out_file") || die "cannot open $out_file for writing: $!";
print OUT <<SCRIPT;

# ./ref_to_cmap/get_cmap_ref.pl

./ref_to_cmap/load_ref_to_cmap.pl

SCRIPT

 close(OUT) || die "can't close $out_file: $!\n";

 system("chmod","755","$out_file");

}
