#!/bin/perl -w


# create grant select statements and insert statements based on schema

use strict;
use DBI;


use strict;
use DBI;
use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;

my $current_db=$config{'db_last_build'}->{'db_user'};
my $new_db=$config{'db_new_build'}->{'db_user'}; 

#my $label = "_" .$config{'date'};

my $schema = $config{'db_schema'};
open(SCHEMA,$schema) or die "$!";

my @tables;
while(<SCHEMA>){
  chomp;
  if(/CREATE\s+TABLE\s+(\w+)\s*/i){
     if(($_ !~ /--/) && ($_ !~ /\/\*/) && ($_ !~ /COMMENT ON/i)){ # not comment
          push @tables, $1;
     }
  }

}
close(SCHEMA);

my $insert_file = "./db/insert_ref_tables.sql";
open (OUT, ">$insert_file") or die "cannot open $insert_file for writing: $!";

my $grant_file = "./db/grant_select.sql";
open (GRANT,">$grant_file") or die "$!";

print OUT "SPOOL ./db/insert_log\n";

foreach my $tbl (@tables){
 print GRANT "GRANT SELECT ON $tbl TO $new_db;\n";

 print OUT "INSERT INTO $tbl SELECT * FROM $current_db.$tbl;\n";

}
 print OUT "SPOOL OFF;\n";

close(OUT);
close(GRANT);

