#!/usr/local/bin/perl -w

#
# write a drop tables file
#

use strict;
use DBI;
use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;


my $dbh  = DBI->connect(
        $config{'db_new_build'}->{'db_dsn'},
        $config{'db_new_build'}->{'db_user'},
        $config{'db_new_build'}->{'db_pass'},
        $config{'db_opts'}
    );



my $sth = $dbh->prepare("select * from tab");

$sth->execute;
my @tbls;
my @views;
while(my ($tbl,$type,$o) = $sth->fetchrow_array()){
    push @tbls, $tbl if $type =~/TABLE/i; 
    push @views, $tbl if $type =~/VIEW/i
}



my $file="./db/clean_db.sql";
open(OUT,">$file") or die "$!";

print OUT "SPOOL ./db/clean_db_log;\n";

for (@tbls){
 print OUT "drop table $_  CASCADE CONSTRAINTS;\n";
}

for (@views){
 print OUT "drop view $_  CASCADE CONSTRAINTS;\n";
}

print OUT "SPOOL OFF;\n";

close(OUT);
$dbh->disconnect;
