#!/usr/local/bin/perl -w

use strict;
use DBI;
use POSIX qw(strftime);

use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;



my $curr_dsn=$config{'db_last_build'}->{'db_dsn'};
my $curr_db=$config{'db_last_build'}->{'db_user'};
my $curr_password=$config{'db_last_build'}->{'db_pass'};

my $dbh  = DBI->connect($curr_dsn,$curr_db,$curr_password,$config{'db_opts'});


my $dsn=$config{'db_new_build'}->{'db_dsn'};
my $new_db=$config{'db_new_build'}->{'db_user'};
my $password=$config{'db_new_build'}->{'db_pass'};


my $dbh_new  = DBI->connect($dsn,$new_db,$password,$config{'db_opts'});

$dbh_new->{AutoCommit}=0;

my $label = "_" . (strftime "%m%d%y", localtime);

 

my $sql =" select row_id,xref_key from 
	   dbxref DBX, objectxref OBX
	   where  DBX.dbxref_id = OBX.dbxref_id
	   and   table_name = 'gramene.literature' 
	   and xref_dbname='PubMed'";
	   
# and   table_name like '%reference'

my $sth1 = $dbh->prepare($sql );
$sth1->execute();

my @curr_ref_pubmeds;
while( my ($refer_id,$pubMed)  = $sth1->fetchrow_array ) {
    push @curr_ref_pubmeds, "$refer_id\t$pubMed";
}

my $sth1_new = $dbh_new->prepare($sql);
$sth1_new->execute();

my %newdb_refs;
while( my ($ref_id,$pubMed)  = $sth1_new->fetchrow_array ) { 
    $newdb_refs{$ref_id}=1;
  }

my $ref_arr = $dbh_new->selectall_arrayref("select reference_id from reference");
my %ref_ids;
foreach (@$ref_arr){
  $ref_ids{$_->[0]}=1;
}

my @new_records;
foreach my $refer (@curr_ref_pubmeds){
   my @fields=split(/\t/,$refer);
   my $refer_id = $fields[0];
   my $pubMed = $fields[1];
   unless($newdb_refs{$refer_id}){  # no pubmed in new db
   
     if(exists $ref_ids{$refer_id}){ # but the ref id exists in new db (some ref id maybe delete from the new db because of duplication
       push (@new_records,"$refer_id\t$pubMed");
     }
   }

 }


my $dbxref_file="./copy_ref/db_dbxref.txt";
open (RFL_DBX,">$dbxref_file") or die "cannot open $dbxref_file for writing: $!";

my $objxref_file="./copy_ref/db_objxref.txt"; 
open (RFL_OBJX,">$objxref_file") or die "cannot open $objxref_file for writing: $!"; 
 


my $sth1_insert = $dbh_new->prepare("insert into dbxref 
                                   (dbxref_id,xref_key,xref_keytype,xref_dbname)
                                 values (?,?,?,?)");
my $sth2_insert = $dbh_new->prepare("insert into objectxref values (?,?,?,?)");

my $sth101 = $dbh_new->prepare( "SELECT MAX(dbxref_id) from dbxref" );

my $sth102 = $dbh_new->prepare( "SELECT MAX(objectxref_id) from objectxref" );


eval{
  $sth101->execute();
  my $dbxref_id = $sth101->fetchrow_array;
  unless( $dbxref_id ) {
    $dbxref_id = 0;
  }

  $sth102->execute();
  my $objxref_id = $sth102->fetchrow_array;
  unless( $objxref_id ) {
    $objxref_id = 0;
  }
  
  my $table_name="gramene.literature";
  my $xref_dbname="PubMed";
  my $xref_keytype="acc";

  foreach my $refer (@new_records){
     my @fields=split(/\t/,$refer);
   
     $dbxref_id ++;
     $sth1_insert->bind_param( 1, $dbxref_id ); 
     $sth1_insert->bind_param( 2, $fields[1] );
     $sth1_insert->bind_param( 3, $xref_keytype);  
     $sth1_insert->bind_param( 4, $xref_dbname ); 
     my $rv1 = $sth1_insert->execute() or die $sth1_insert->errstr;
     print RFL_DBX ("$dbxref_id\t$fields[1]\t$xref_keytype\t$xref_dbname\n");    
 
     $objxref_id ++;
     $sth2_insert->bind_param( 1, $objxref_id ); 
     $sth2_insert->bind_param( 2, $table_name );
     $sth2_insert->bind_param( 3, $fields[0]);  
     $sth2_insert->bind_param( 4, $dbxref_id ); 
     my $rv2 = $sth2_insert->execute() or die $sth2_insert->errstr;
     print RFL_OBJX ("$objxref_id\t$table_name\t$fields[0]\t$dbxref_id\n");

   }
 
  $dbh_new->commit();
  
};
if($@){
  warn "Unable to save to database: $@\n";
  $dbh_new->rollback();
}



close (RFL_DBX) or die "can't close $dbxref_file: $!\n";  
close (RFL_OBJX ) or die "can't close $objxref_file: $!\n"; 
############################################

$sth1_insert->finish;
$sth2_insert->finish;
$sth101->finish;
$sth102->finish;


$sth1_new->finish;
$sth1->finish;
$dbh->disconnect || warn $dbh->errstr;
$dbh_new->disconnect || warn $dbh->errstr; 
exit;
