#!/bin/perl -w

use strict;
use DBI;
use POSIX qw(strftime);


use Config::General;


my $conf = new Config::General("build.conf");
my %config = $conf->getall;

my $curr_db_dsn=$config{'db_last_build'}->{'db_dsn'};

my $curr_db;
if( $curr_db_dsn =~/;database=(.+)/) {
    $curr_db = $1;
}
my $new_db_dsn=$config{'db_new_build'}->{'db_dsn'};

my $new_db_usr=$config{'db_new_build'}->{'db_user'};

my $password=$config{'db_new_build'}->{'db_pass'};


my $dbh  = DBI->connect($new_db_dsn,$new_db_usr,$password,$config{'db_opts'});




my $label = "_" . (strftime "%m%d%y", localtime);



my $sth1 = $dbh->prepare("SELECT  max(source_id) FROM source");
$sth1->execute();
my ( $max_source_id ) = $sth1->fetchrow_array() || 0;
$sth1->finish;


my $sth2 = $dbh->prepare("SELECT  max(reference_id) FROM reference"); 
$sth2->execute(); 
my ( $max_ref_id ) = $sth2->fetchrow_array() || 0; 
$sth2->finish; 

my $sth3 = $dbh->prepare("SELECT  max(contributor_id) FROM contributor"); 
$sth3->execute(); 
my ( $max_contributor_id ) = $sth3->fetchrow_array() || 0; 
$sth3->finish; 

$dbh->disconnect || warn $dbh->errstr;

#########################################

my $insert_file = "copy_ref/insert_ref_tables.sql";
open (IN, ">$insert_file") or die "cannot open $insert_file for writing: $!";

write_insert_file();

close(IN);


sub write_insert_file{
        print IN  " INSERT INTO source SELECT * from $curr_db.source where source_id > $max_source_id;\n"; 
        print IN  " INSERT INTO source_url SELECT * from $curr_db.source_url where source_id > $max_source_id;\n"; 
        print IN  " INSERT INTO source_synonym SELECT * from $curr_db.source_synonym where source_id > $max_source_id;\n"; 

        print IN  " INSERT INTO old_source SELECT * from $curr_db.old_source where source_id > $max_source_id;\n"; 

        print IN  " INSERT INTO reference SELECT * from $curr_db.reference where reference_id > $max_ref_id;\n"; 
        print IN  " INSERT INTO reference_abstract SELECT * from $curr_db.reference_abstract where reference_id > $max_ref_id;\n"; 
        print IN  " INSERT INTO reference_extra SELECT * from $curr_db.reference_extra where reference_id > $max_ref_id;\n"; 
        print IN  " INSERT INTO reference_load_help SELECT * from $curr_db.reference_load_help where reference_id > $max_ref_id;\n"; 
     #   print IN  " INSERT INTO reference_to_object SELECT * from $curr_db.reference_to_object where reference_id > $max_ref_id;\n"; 
        print IN  " INSERT INTO reference_url SELECT * from $curr_db.reference_url where reference_id > $max_ref_id;\n"; 
        print IN  " INSERT INTO reference_comment SELECT * from $curr_db.reference_comment where reference_id > $max_ref_id;\n"; 
 
        print IN  " INSERT INTO contributor SELECT * from $curr_db.contributor where contributor_id > $max_contributor_id;\n"; 
        print IN  " INSERT INTO author SELECT * from $curr_db.author where reference_id > $max_ref_id;\n"; 
         


}
