#!/bin/perl
=This takes a parsed FPC file and creates two files for populating the fpc_contigs and fpc_features tables.
=cut

use Getopt::Std;
use strict;
use DBI;

my %option;
my $hit_id;
my $USAGE="
perl format_fpc.pl -i input_fpc -s fpc_contigs_summary  -d  fpc_feature_details-t type_id\n\n";
getopt("isdt",\%option); 

unless (defined $option{i} && defined $option{s} && defined $option{d} && defined $option{t}) {die $USAGE};

open(IN_FILE,"$option{i}") or  die "Can't open the file: $option{i}. $!\n";
open(SUMMARY_FILE,">$option{s}") or  die "Can't open the file: $option{s}. $!\n";
open(DETAIL_FILE,">$option{d}") or  die "Can't open the file: $option{d}. $!\n";

my $type_id=$option{t};
my $dbh=DBI->connect('DBI:Oracle:','user','password',{RaiseError=>1,AutoCommit=>1} );
my $sql_statement='SELECT MAX(fpc_id) FROM fpc_contigs';
my $sth=$dbh->prepare($sql_statement);
$sth->execute;
$hit_id=$sth->fetchrow_array;

my %clone_hash=();
while (<IN_FILE>){

  chomp;
  my ($clone,$contig,$start,$stop, $chrom, @markers)=split /\t/;
  unless (exists $clone_hash{$clone}){
    $hit_id++;
    $clone_hash{$clone}{id}=$hit_id;
    print SUMMARY_FILE "$clone_hash{$clone}{id}\t$clone\t$contig\t$start\t$stop\t$chrom\t$type_id\n";
  }
  foreach my $marker (@markers){
    print DETAIL_FILE "$clone_hash{$clone}{id}\t$marker\n";
  }

}

close IN_FILE or die "Can't close the IN_FILE file: $!\n";
close SUMMARY_FILE or die "Can't close the SUMMARY_FILE file: $!\n";
close DETAIL_FILE or die "Can't close the DETAIL_FILE file: $!\n";
exit;
