#!/usr/local/bin/perl

use strict;
use warnings;
use Gramene::CDBI::DiversityRice;

my @e = Gramene::CDBI::DiversityRice::DivExperiment->retrieve_all;

my $XrefType = Gramene::CDBI::DiversityRice::XrefType->find_or_create(
    xref_type    => 'Gramene Literature',
    url_template => '/db/literature/pub_search?ref_id=%s&show_qtl=1',
);

for my $e ( @e ) {
    my $desc = $e->comments;
    if ( $desc =~ /ref_id=(\d+)/ ) {
        printf "%s => %s\n", $e->id, $1;

        Gramene::CDBI::DiversityRice::Xref->find_or_create(
            table_name   => 'div_experiment',
            record_id    => $e->id,
            xref_type_id => $XrefType->id,
            xref_value   => $1,
        );
    }
}
