#!/usr/local/bin/perl

=pod

=head1 NAME

  mk-aln-file.pl

=head1 SYNOPSIS

  ./mk-aln-file.pl -d markers24 -o /scratch/kyc-tmp/alignments
    [-m map_set_acc1[,map_set_acc2]]

=head1 DESCRIPTION

This script creates alignment files for CMap to use when creating the 
stacked/ordered maps.

=head1 AUTHOR

Ken Youens-Clark

=cut

use strict;
use warnings;
use File::Path;
use File::Spec::Functions qw( catfile );
use Getopt::Long;
use Pod::Usage;
use Readonly;

Readonly my @MAP_SET_ACCESSSIONS => qw(
    oaab0605
    oabb0607
    ob_b0607
    oc_b0605
    ogab0604
    ogbb0602h
    om_b0609
    oo_b0607
    op_b0607
    orab0605
    orbb0602h
    orcb0602h
);

my $out_dir      = '';
my $markers_db   = '';
my $map_set_accs = '';

GetOptions(
    'o=s' => \$out_dir,
    'd=s' => \$markers_db,
    'm=s' => \$map_set_accs,
);

if ( !$out_dir ) {
    pod2usage('No out dir');
}

if ( !$markers_db ) {
    pod2usage('No markers db name');
}

if ( !-d $out_dir ) {
    mkpath( $out_dir );
}

my @map_set_accs = 
    $map_set_accs 
    ? map { s/^\s+|\s+$//g; $_ } split(/,/, $map_set_accs) 
    : @MAP_SET_ACCESSSIONS;

my $sql =q[
    select distinct
           concat('omap-',ref_map.cmap_map_accession) as ref_map_acc,
           contig_map.cmap_map_accession as contig_map_acc
    from   mapping mp_loc,
           mapping mp_to_contig,
           map     ref_map,
           map     contig_map,
           map_set,
           marker,
           marker_type,
           synteny_analysis.contig_clone_hit_detail hd
    where  mp_loc.marker_id = marker.marker_id
    and    marker.marker_type_id = marker_type.marker_type_id
    and    marker_type.marker_type = 'FPC'
    and    (mp_loc.analysis_id = 324 or mp_loc.analysis_id = 244)
    and    mp_loc.score > 1
    and    mp_loc.map_id = ref_map.map_id
    and    mp_loc.marker_id = mp_to_contig.marker_id
    and    mp_to_contig.analysis_id = 76
    and    mp_to_contig.map_id = contig_map.map_id
    and    contig_map.cmap_map_accession is not null
    and    contig_map.map_set_id=map_set.map_set_id
    and    map_set.cmap_map_set_accession=?
    and    mp_loc.marker_id = hd.contig_marker_id
    and    hd.contig_region_hit_detail_id >= 1
    order by ref_map.map_id, mp_loc.start, mp_loc.end
];

for my $ms ( @map_set_accs ) {
    open my $fh, '>', 'sql' or die $!;
    ( my $s = $sql ) =~ s/\?/$ms/;
    print $fh $s;
    close $fh;
    my $out_file = "${ms}.tab";
    my $out_path = catfile( $out_dir, $out_file );
    my $cmd 
        = qq[/usr/local/mysql/bin/mysql -h cabot -umarkers_rw ]
        . qq[-p'()ryz\@' $markers_db < sql > $out_path]
    ;

    print "$cmd\n";
    system( $cmd ) == 0 or die $?;
    unlink 'sql';
}
