package Panzea::FormConfig;

our $VERSION = '0.02';

# $Id: FormConfig.pm,v 1.6.2.1 2007/06/14 19:03:22 kclark Exp $

=head1 NAME

Panzea::FormConfig - Panzea simple config wrapper

=head1 DESCRIPTION

Simple config wrapper.

=cut

use warnings;
use strict;

use base qw(Exporter);

our @EXPORT = qw[cfg
  val
];
our @EXPORT_OK;

use Carp;
use Config::General;
use Tie::IxHash;

=head3 new

 Function  : Returns a config object
 Arguments : $config_file
 Returns   : $config_obj
 Notes     : None specified.

=cut

sub new {
    my ($class, $config_file) = @_;

    croak("A config file is required!") unless $config_file;

    # Parse hardcoded config file and store in a global
    tie my %config, 'Tie::IxHash';
    %config = Config::General::ParseConfig(
        -ConfigFile      => $config_file,
        -Tie             => 'Tie::IxHash',
        -InterPolateVars => 1,
    );

    my $config_obj = {'config' => \%config};

    my $self = bless $config_obj, $class;

    return $self;
}

=head3 cfg

 Function  : Return config value key, checks if it exists
 Arguments : $key
 Returns   : $value
 Notes     : None specified.

=cut

sub cfg {
    my ($self, $key) = @_;

    return $self->{config}->{$key};
}

=head3 val

 Function  : Return config value key, does *not* check if it exists
 Arguments : $key
 Returns   : $value
 Notes     : None specified.

=cut

sub val {
    my ($self, $key) = @_;
    return $self->{config}->{$key};
}

=head1 AUTHOR

Payan Canaran <canaran@cshl.edu>

=head1 BUGS

=head1 VERSION

Version 0.02

=head1 ACKNOWLEDGEMENTS

=head1 COPYRIGHT & LICENSE

Copyright (c) 2005-2007 Cold Spring Harbor Laboratory

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself. See DISCLAIMER.txt for
disclaimers of warranty.

=cut

1;
