package LookAlign::Panzea::WebFormUtils;

our $VERSION = '0.01';

# $Id: WebFormUtils.pm,v 1.1.2.1 2007/06/14 19:03:07 kclark Exp $

=head1 NAME

LookAlign::Panzea::WebFormUtils - Panzea web display utility module

=head1 DESCRIPTION

Simple utility module.

=cut

use strict;

=head3 code2sampstat

 Function  : Returns a hasref that converts a sampstat code
             to sampstat per GDPDM 2.1 documentation
 Arguments : none
 Returns   : $hashref
 Notes     : None specified.

=cut

sub code2sampstat {
    my ($class) = @_;

    # Official sampstat designations
    # 114 'Inbred line (developed from wild material)'
    # 314 'Inbred line (developed from a landrace)'
    # 414 'Inbred line (parent of hybrid cultivar)'

    my $code2sampstat = {
        100 => 'Wild',
        110 => 'Natural',
        114 => 'Inbred line (from wild material)',
        120 => 'Semi-natural/wild',
        200 => 'Weedy',
        300 => 'Traditional cultivar/landrace',
        314 => 'Inbred line (from a landrace)',
        400 => 'Breeding/research material',
        410 => 'Breeders line',
        411 => 'Synthetic population',
        412 => 'Hybrid',
        413 => 'Founder stock/base population',
        414 => 'Inbred line',
        415 => 'Segregating population',
        420 => 'Mutant/genetic stock',
        500 => 'Advanced/improved cultivar',
        999 => 'Other',
    };

    return $code2sampstat;
}

=head1 AUTHOR

Payan Canaran <canaran@cshl.edu>

=head1 BUGS

=head1 VERSION

Version 0.01

=head1 ACKNOWLEDGEMENTS

=head1 COPYRIGHT & LICENSE

Copyright (c) 2004-2007 Cold Spring Harbor Laboratory

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself. See DISCLAIMER.txt for
disclaimers of warranty.

=cut

1;
