package LookAlign::Alignment::Container::Sq;

our $VERSION = '0.01';

# $Id: Sq.pm,v 1.1.2.1 2007/06/14 19:08:07 kclark Exp $

=head1 NAME

LookAlign::Alignment::Container::Sq

=head1 DESCRIPTION

Simple container object to represent a sequence (of an
Alignment::Container).

=cut

use warnings;
use strict;

use Carp;

###############
# CONSTRUCTOR #
###############

sub new {
    my ($class, %args) = @_;
    eval {
        $args{alignment} or croak("An 'alignment' is required");
        $args{id}        or croak("An 'id' is required");
    } or return;
    my %obj;
    $obj{_alignment} = $args{alignment};
    $obj{_id}        = $args{id};

    bless \%obj, $class;
}

###########
# METHODS #
###########

sub _params {
    my ($self) = @_;
    return ($self->{_alignment}, $self->{_id});
}

sub id {
    my ($self, $value) = @_;
    my ($al,   $id)    = $self->_params;
    return $id;
}

sub al {
    my ($self, $value) = @_;
    my ($al,   $id)    = $self->_params;
    return $al;
}

sub sequence {
    my ($self, $value) = @_;
    my ($al,   $id)    = $self->_params;
    if ($value)
    {    # Set the sequence, but don't forget to set the sequence_ary as well
        $al->{_sequences}{$id}{sequence} = uc $value;
    }
    return $al->{_sequences}{$id}{sequence};
}

sub len {
    my ($self) = @_;
    my $sequence = $self->sequence;
    return length $sequence;
}

sub valid_len {
    my ($self)    = @_;
    my $sequence  = $self->sequence;
    my $valid_len = 0;
    while ($sequence =~ /([ATCGatcg]+)/g) { $valid_len += length($1); }
    return $valid_len;
}

sub sequence_ary {
    my ($self)    = @_;
    my $sequence  = $self->sequence;
    my $delimiter = '';
    if ($sequence =~ /,/) { $delimiter = ','; }
    return split($delimiter, $sequence);
}

sub base_pair {
    my ($self, $i)  = @_;
    my ($al,   $id) = $self->_params;
    return $al->{_sequences}{$id}{sequence_ary}[$i];
}

sub label {
    my ($self) = @_;
    my ($al, $id) = $self->_params;
    return $al->{_sequences}{$id}{label};
}

sub order {
    my ($self) = @_;
    my ($al, $id) = $self->_params;
    return $al->{_sequences}{$id}{order};
}

sub attributes {
    my ($self) = @_;
    my ($al, $id) = $self->_params;
    return keys %{$al->{_sequences}{$id}{attributes}};
}

sub exists_attribute {
    my ($self, $key) = @_;
    my ($al,   $id)  = $self->_params;
    defined $al->{_sequences}{$id}{attributes}{$key} ? return 1 : return;
}

sub attribute_value {
    my ($self, $key, $value) = @_;
    my ($al, $id) = $self->_params;
    if ($value) {
        $al->{_sequences}{$id}{attributes}{$key} = $value;
    }
    $self->exists_attribute($key)
      or croak("Attribute key ($key) does not exist");
    return $al->{_sequences}{$id}{attributes}{$key};
}

sub attribute_value_ary {
    my ($self, $key) = @_;
    my ($al,   $id)  = $self->_params;
    $self->exists_attribute($key)
      or croak("Attribute key ($key) does not exist");
    my $value = $al->{_sequences}{$id}{attributes}{$key};

    my @value = split(',', $value);

    return (@value);
}

=head1 AUTHOR

Payan Canaran <canaran@cshl.edu>

=head1 BUGS

=head1 VERSION

Version 0.01

=head1 ACKNOWLEDGEMENTS

=head1 COPYRIGHT & LICENSE

Copyright (c) 2004-2007 Cold Spring Harbor Laboratory

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself. See DISCLAIMER.txt for
disclaimers of warranty.

=cut

1;
