package JIM::User;

#JIM::User, copyright and (c) 2005 Jim Thomason

$VERSION = '2.00';

use Basset::Object;
our @ISA = Basset::Object->pkg_for_type('persistentobject');

use strict;
use warnings;

=pod

=head1 JIM::User

=head1 ATTRIBUTES

=over

=cut

=item user_id
=item user_group_id
=item permalogin
=item username
=item password
=item name
=item email
=item created_date
=item last_modified

=cut

__PACKAGE__->add_attr('user_id');
__PACKAGE__->add_attr('permalogin');
__PACKAGE__->add_attr('username');
__PACKAGE__->add_attr('password');
__PACKAGE__->add_attr('name');
__PACKAGE__->add_attr('email');
__PACKAGE__->add_attr('created_date');
__PACKAGE__->add_attr('last_modified');

__PACKAGE__->add_tables(
	__PACKAGE__->factory(
		'type' 				=> 'table',
		'name'				=> 'user',
		'primary_column'		=> 'user_id',
		'autogenerated'			=> 1,
		'non_primary_columns'		=> [qw(permalogin username password name email created_date last_modified)],
	)
);

sub is_nobody {
	my $self = shift;
	
	return $self->username eq 'nobody';
};

sub shortname {
	my $self = shift;
	$self->name =~ /^(\w+) /;

	return $1;
};

sub write_access {
	my $self = shift;
	my $object = shift or return $self->error("Cannot determine write access w/o object", "XXX");
	
	if ($object->can('user_id')) {
		return $object->user_id == $self->user_id
	}
	elsif ($object->can('write_access_validation')) {
		return $object->write_access_validation($self);
	}
	else {
		return 1;
	}
}

sub login {
	my $class		= shift;
	
	my $username	= shift;
	my $password	= shift;

	my %args = (
		'username' => $username
	);
	
	$args{'password'} = $password if $username ne 'nobody';

	return $class->load_one_where(%args);
	
};

1;

