package JIM::FAQ::Question;

#JIM::FAQ::Question, copyright and (c) 2005 Jim Thomason

$VERSION = '2.00';

use Basset::Object;
our @ISA = Basset::Object->pkg_for_type('persistentobject');

use strict;
use warnings;

=pod

=head1 JIM::FAQ::Question

=head1 ATTRIBUTES

=over

=cut

=item faq_question_id
=item faq_id
=item number
=item answer
=item question
=item created_date
=item last_modified

=cut

__PACKAGE__->add_attr('faq_question_id');
__PACKAGE__->add_attr('faq_id');
__PACKAGE__->add_attr('number');
__PACKAGE__->add_attr('answer');
__PACKAGE__->add_attr('question');
__PACKAGE__->add_attr('created_date');
__PACKAGE__->add_attr('last_modified');

__PACKAGE__->add_tables(
	__PACKAGE__->factory(
		'type' 					=> 'table',
		'name'					=> 'faq_question',
		'primary_column'		=> 'faq_question_id',
		'autogenerated'			=> 1,
		'non_primary_columns'	=> [qw(faq_id number answer question created_date last_modified)],
		'db_write_translation'	=>
			{
				'created_date' => {
					'I' => {
						'val' => 'NOW()',
						'binds' => 0
					}
				},
				'last_modified' => {
					'A' => {
						'val' => 'NOW()',
						'binds' => 0
					},
				}	
			},
		'references' => {
			'faq_id' => 'faq.faq_id'
		}
	)
);

__PACKAGE__->has_a(
	'faq' => 'JIM::FAQ::FAQ'
);

sub delete {
	my $self = shift;

	$self->begin;

	$self->SUPER::delete(@_) or return;
	
	my $questions = $self->faq->questions;
	
	foreach my $question (@$questions) {
		if ($question->number > $self->number) {
			$question->number($question->number - 1);
			$question->commit or return $self->fatalerror($question->errvals);
		}
	}
	
	$self->end;
	
	return $self;
}

sub write_access_validation {
	my $self = shift;
	my $user = shift or return $self->error("Cannot validate write access w/o user", "XXX");

	return $user->write_access($self->faq);	
}

sub machinelink { return '/db/faq' };

sub weblink {
	my $self = shift;
	my $full = shift;
	my $state = shift || 'display_question';
	
	return #$self->SUPER::weblink(
		sprintf($self->machinelink . "?state=$state&faq_question_id=%s",
			$self->faq_question_id,
		);
		#$full
	#);

}


1;

