package JIM::FAQ::FAQ;

#JIM::FAQ::FAQ, copyright and (c) 2005 Jim Thomason

$VERSION = '2.00';

use Basset::Object;
our @ISA = Basset::Object->pkg_for_type('persistentobject');

use strict;
use warnings;

=pod

=head1 JIM::FAQ

=head1 ATTRIBUTES

=over

=cut

=item faq_id
=item user_id
=item publishdate
=item name
=item created_date
=item last_modified

=cut

__PACKAGE__->add_attr('faq_id');
__PACKAGE__->add_attr('user_id');
__PACKAGE__->add_attr('publishdate');
__PACKAGE__->add_attr('name');
__PACKAGE__->add_attr('created_date');
__PACKAGE__->add_attr('last_modified');

__PACKAGE__->add_tables(
	__PACKAGE__->factory(
		'type' 				=> 'table',
		'name'				=> 'faq',
		'primary_column'		=> 'faq_id',
		'autogenerated'			=> 1,
		'non_primary_columns'		=> [qw(user_id publishdate name created_date last_modified)],
		'db_write_translation' =>
			{
				'created_date' => {
					'I' => {
						'val' => 'NOW()',
						'binds' => 0
					}
				},
				'last_modified' => {
					'A' => {
						'val' => 'NOW()',
						'binds' => 0
					},
				}	
			},
	)
);

__PACKAGE__->has_many(
	'question' => 'JIM::FAQ::Question',
	{
		'clauses' => {
			'order by' => 'number'
		}
	}
);

sub max_number {
	my $self = shift;

	my $record = $self->arbitrary_sql(
		'query' => qq{
			select
				max(number) as number
			from
				faq_question
			where
				faq_id = ?
		},
		'vars'	=> [$self->faq_id],
	) or return;

	return $record->[0]->{'number'};
	
}

sub weblink {
	my $self = shift;
	my $full = shift;		
	
	return #$self->SUPER::weblink(
		sprintf("/db/faq?state=display_faq&faq_id=%s",
			$self->faq_id,
		);
		#$full;
	#);

}

sub webname {
	my $self = shift;

	return $self->name;
}


1;

