package JIM::CGI;

use Basset::CGI;
@ISA = qw(Basset::CGI);

use strict;
use warnings;

=pod

=item extractor_stack

The extractor_stack is an additional location for you to place values that you want to try and extract.

=cut

__PACKAGE__->add_class_attr('extractor_stack', {});

=pod

=begin btest(extractor_stack)

=end btest(extractor_stack)

=cut

sub param {
	my $class = shift;
	
	my @return = ();
	
	foreach my $param (@_) {
		my @values = defined $class->extractor_stack->{$param}
			? ($class->extractor_stack->{$param})
			: CGI::param($param);
		push @return, map {defined($_) && length($_) ? $_ : undef} @values;
	};
	
	return wantarray ? @return : $return[0];
};

1;
