package Gramene::Web;

$VERSION = '1.00';

use Basset::Object;
our @ISA = Basset::Object->pkg_for_type('object');

use Gramene::Config;
use Gramene::Page;

use strict;
use warnings;

use JIM::User;

Basset::Object->types->{'template'} = 'Gramene::Template';
Basset::Object->types->{'extractor'} = 'JIM::CGI';


__PACKAGE__->add_attr('args');
__PACKAGE__->add_attr('template');
__PACKAGE__->add_attr('extractor');
__PACKAGE__->add_attr('state');
__PACKAGE__->add_attr('using_editor');

__PACKAGE__->add_attr('user');
__PACKAGE__->add_attr('permanent_session');

__PACKAGE__->add_class_attr('systemdown');

sub init {
	my $self = shift;
	
	$self = $self->SUPER::init(
		'using_editor'	=> 0,
		'template' 		=> '/index.tpl',
		'args'			=> {},
		'extractor'		=> $self->pkg_for_type('extractor'),
		@_,
	) or return;

	$self->extractor->extractor_stack($self->args);	#JIM::CGI introduces the extractor_stack.

	my $session = $self->session();
	
	my $user;
	
	$user = JIM::User->load($session->user_id) if $session;
	
	$user = JIM::User->login('nobody') unless $user;
	
	$self->user($user);
	$self->permanent_session($session ? $session->permanent : 0);
	
	$self->extract_and_save('state');
	
	return $self;
	
}

sub extract {
	my $self = shift;
	my $extractor = $self->extractor or return $self->error("Cannot extract w/o extractor", "XXX");
	
	return $extractor->extract(@_) or $self->error($extractor->errvals);
}

sub extract_and_save {
	my $self = shift;
	return $self->error("Cannot extract w/o param", "JKW-01") unless @_;
	
	my @return = ();
	foreach my $param (@_) {
		push @return, $self->args->{$param} = $self->extract($param);
	}
	
	return wantarray ? @return : $return[0];
}

sub extract_into_hash_and_save {
	my $self = shift;
	return $self->error("Cannot extract w/o param", "JKW-02") unless @_;
	
	my $return = {};
	foreach my $param (@_) {
		$return->{$param} = $self->args->{$param} = $self->extract($param);
	}
	
	return $return;
}

sub start {
	my $self = shift;
	
#	my $tpl	= $self->pkg_for_type('template')->new();	
#	
#	if (-e $tpl->cache_dir . 'main.html') {
#		print STDERR "USES MAIN!\n";
#		print $self->extractor->content('text/html');
#		open (MAIN, '<' , $tpl->cache_dir . 'main.html');
#		print <MAIN>;
#		close MAIN;
#		return $self;
#	}
#	else {
		return $self->output;
#	}
}

sub edit { 
	my $self = shift;
	$self->using_editor(1);
	return $self->view(@_);
};

sub output {
	my $self 	= shift;

	my $tplpath 	= shift || $self->template || return $self->error("Cannot output w/o template");
	my $args 		= shift || $self->args || {};

    $args->{'gramene_page'} = Gramene::Page->new(Apache->request);

	if ($self->systemdown) { $tplpath = '/downtime.tpl' };

	my $Template	= $self->pkg_for_type('template');

	my $tpl = $Template->new(
		'template'			=> $tplpath,
		'user'				=> $self->user,
		'permanent_session'	=> $self->permanent_session,
		'machine'			=> $self,
	) or return $self->error($Template->errvals);

	my $page = $tpl->process($args)
		or return $self->error($tpl->errvals);

	print $self->extractor->content('text/html');
	print $page;
	
#	if ($self->pkg eq 'Gramene::Web' && $self->state eq 'start') {
#		print STDERR "CACHES MAIN!\n";
#		open (MAIN, '>' , $tpl->cache_dir . 'main.html');
#		print MAIN $page;
#		close MAIN;
#	}

	return $self;

}

sub prompt {
	my $self = shift;
	
	$self->template('/login.tpl');
	
	return $self->output;
}

sub login {
	my $self = shift;

    #switch to the edit connection
    my $config = Gramene::Config->new();

    my $faq_config = $config->get('faq_edit');

    Basset::Object->conf->{'Basset::DB'}->{'-dsn'} = $faq_config->{'db_dsn'};
    Basset::Object->conf->{'Basset::DB'}->{'-user'} = $faq_config->{'db_user'};
    Basset::Object->conf->{'Basset::DB'}->{'-pass'} = $faq_config->{'db_pass'};
    Basset::Object->pkg_for_type('persistentobject')->driver(undef);
	
	my $username = $self->extract_and_save('username');
	my $password = $self->extract_and_save('password');

	my $user = JIM::User->login($username, $password);
	if ($user) {
	
		my $session = $self->pkg_for_type('session')->new(
			'user_id'	=> $user->user_id,
			'ip'		=> $ENV{'REMOTE_ADDR'},
			'permanent'	=> $self->extract('permalogin') && $user->permalogin ? 1 : 0,
		);
		
		$session->generate_expiration($self->extract('permalogin') && $user->permalogin ? 1 : 0);
		$session->commit;
		
		$self->notify('login', 'Logging in: ' . $user->username . " from $ENV{REMOTE_ADDR} at " . $self->now);
		
		$self->extractor->add_header(
			'Set-Cookie:'
			. $self->extractor->set_cookie(
				$session->cookiename,
				$session->sessionkey,
				$self->extract('permalogin') && $user->permalogin ? '2010-12-31 23:59:59' : ''
			)
		);
		
		$self->user($user);
		$self->permanent_session($session->permanent);
		
		#return $self->state('output');
		return $self->extractor->redirect($ENV{'SCRIPT_URI'});
	
	}
	else {
		$self->notify('login', "Break in attempt: for ($username) & ($password) from $ENV{REMOTE_ADDR} at " . $self->now);
		$self->args->{'error'} = 'Could not log in ' . JIM::User->errstring;
		return $self->prompt;
	}
}

sub logout {
	my $self = shift;
	
	$self->notify('login', 'Logging out: ' . $self->user->username . ", from $ENV{REMOTE_ADDR} at " . $self->now); 
	
	$self->extractor->add_header('Set-Cookie:' . $self->extractor->drop_cookie($self->pkg_for_type('session')->cookiename));
	my $session = $self->session->delete;
	
	return $self->prompt;

}

sub session {
	return shift->extractor->read_session();
}

sub test {
	my $self = shift;
	
	$self->template('/test.tpl');
	
	return $self->output;
}
	
1;

