use strict;
################### 
### pack things into byte arrays
########### 
package Gramene::Util::packProp;
my $BYTES;
my $BITS;
##### ##### ##### ##### ##### ##### ##### 
##### new constructor.
##### ##### ##### ##### ##### ##### #####
sub new{	
 my $name = shift;
 $BYTES=shift;
 my $class = ref($name) || $name;
 my $this = {};
 bless $this,$class;
 $BITS=8*$BYTES;
 if (!defined($BYTES)) 
   {$BYTES=2;print STDERR "usage new(BYTES), using Default 2 Bytes\n";}
 return $this;
}
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## 
## init_flgs
## input is ref to list ("monoAsian","heteroCau"etc.);
### returns ref to an array that contains the guys
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## 
sub init_flags{
  my $this=shift;
  my $P_arr=shift;
  my $cnt=0;
  foreach(@{$P_arr}){$this->{$_}=$cnt++;}
} 
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
## init_array
### input [[snp],[snp]],[flag1,flag2..]
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## 
sub init_array{
  my $this=shift;
  my $P_arr=shift;
  my $P_flg=shift;
  print "initarr=@$P_flg\n";
  if(!defined($P_flg)){$P_flg=[];} 


  my @tmp1 = (0,0,0,0,0,0,0,0);
  my @tmp;
  foreach (my $i=0;$i<$BYTES;$i++) {@tmp = (@tmp,@tmp1);}

  foreach(@$P_flg){$tmp[$this->{$_}]=1;}

  my $p = pack("B$BITS",join("",@tmp));
  for(my $i=0;$i<@$P_arr;$i++){$P_arr->[$i]->[1]=$p;}
}
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## 
## update_array
## input([[snp,pack],[snp,pack]]
### output, all the packs get updated with the new flag
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## 
sub update_array{
  my $this=shift;
  my $P_arr=shift;
  my $flg=shift;
  for(my $i=0;$i<@$P_arr;$i++){
    my @tmp = split(//,unpack("B$BITS",$P_arr->[$i]->[1]));
    foreach(@$P_arr){$tmp[$this->{$_}]=1;}
    $P_arr->[$i]->[1]=pack("B$BITS",join("",@tmp));  
  } 
} 
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## 
## check_array
#$# input[[snp,$pck],[snp,pck]]
## output[[snp,$pck,$flag],[snp,pck,$flag]]
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## 
sub check_array{
  my $this=shift;
  my $P_arr=shift;
  my $P_flg=shift;
  for(my $i=0;$i<@$P_arr;$i++){
    my @tmp = split(//,unpack("B$BITS",$P_arr->[$i]->[1]));
    $P_arr->[$i]->[2]=0;    
    foreach my $flg(@$P_flg){
      if($tmp[$this->{$flg}]==1 || $P_arr->[$i]->[2]==1 ){ 
	$P_arr->[$i]->[2]=1;
      }
    } 
  } 
} 

1;


=head1 NAME

packProp.pm - utility to pack several properties (upto 16) into 2 bytes 

=head1 SYNOPSIS

    use packProp;
    $pP =  packProp->new();
    $pP->init_flags(["genotype","caucasian"]);
    $pP->init_array([[id1],[id2],[id3]]);
    $pP->update_array([[id1,pck1],[id2,pck2],[id3,pck3]],
		      ["genotype","caucasian"]);
    $pP->check_array([[id1,pck1],[id2,pck2],[id3,pck3]],
		      ["genotype","caucasian"]);


=head1 METHODS AND USAGE

=over 6

=item    packProp->new();

No special inputs required

=item     $pP->init_flgs($P_arr);

I<$P_arr> is a reference to an array of types that need to be
packed into 2 byte things.


=item      $pP->init_array([[id1],[id2],[id3]],$P_arr);

input is a reference to a list of lists, the list gets modified so that 
all the guys get the flags for the list in I<$P_arr>, P_arr could be undefined.


=item    $pP->update_array([[id1,pck1],[id2,pck2]],$P_arr);

like init_array, except the pck values get modified by what is in P_Arr


=item    $pP->check_array([[id1,pck1],[id2,pck2]],$P_arr);

checks in any in list has the flags in P_arr turned on, adds a third element
to each element in the input array (id,pck,flag), where the flag is 1 or 0.

=back

=head1 AUTHOR

Ravi Sachidanandam, CSHL. ravi@cshl.org


=cut


