#!/opt/bin/perl -w
#######  #######  #######  #######  
## myUtil.pm
## Version 1.0 prefinal release
#######  #######  #######  #######  
use strict;
package Gramene::Util::myUtil;

# for the time packages 
# from ~dbi/system/Time-modules-98.112901/lib/Time/

#use Time::CTime;
#use Time::ParseDate;
#use Time::Timezone;

my %month = (
          JAN => '01', FEB => '02', MAR => '03', APR => '04',
          MAY => '05', JUN => '06', JUL => '07', AUG => '08',
          SEP => '09', OCT => '10', NOV => '11', DEC => '12'
);

#  s/(\d\d)-([A-Z][A-Z][A-Z])-(\d\d)/$3-$month{$2}-$1/g;      

##### ##### ##### ##### ##### ##### ##### 
##### new constructor.
##### ##### ##### ##### ##### ##### #####
sub new{	
 my $name = shift;
 my $class = ref($name) || $name;
 my $this = {};
 bless $this,$class;
 return $this;
}
#### #### #### #### #### #### #### #### #### 
#### maxSeparator
#### given an ordered list, generates an ordered list that is 
#### maximally separated, puts it back into the same list.
#### #### #### #### #### #### #### #### ####

sub maxSeparator{
    my $this=shift;
    my $P_arr=shift;
    my $cnt = @{$P_arr};
    if ($cnt<2) {return;}
    $cnt--;
    my @seplist=(0,$cnt);
#    print "BEgin--@seplist\n";
    $this->generateInter(\@seplist);
#    my $num = @seplist;print "Final-num=$num-@seplist\n";  exit;
    my @tmp;
    foreach(@seplist){push(@tmp,$P_arr->[$_]);}
    @{$P_arr}=@tmp;
}
### ### ### ### ### ### ### ### ### ### ### ### ### 
### takes list, generates points in between, then 
#### randomizes it and inserts it.
### ### ### ### ### ### ### ### ### ### ### ### ### 
sub generateInter{
    my $this=shift;
    my $P_list=shift;
    my @tmp = @{$P_list};
    @tmp=sort{$a<=>$b}@tmp;
    my $cnt=0;
    my @tmp2; ## holds temporarily stuff
    for (my $i=0;$i<(@tmp-1);$i++) {
	if (($tmp[$i+1]-$tmp[$i])==1) {next;}
	else {
	    $cnt++;
	    # push(@$P_list,int(($tmp[$i+1]+$tmp[$i])/2));
	    push(@tmp2,int(($tmp[$i+1]+$tmp[$i])/2));
	}
    }
    if ($cnt==0) {return;}
    $this->randomizeArr(\@tmp2);
    @{$P_list}=(@{$P_list},@tmp2);
    $this->generateInter($P_list);
    return;
}
### ### ### ### ### ### ### ### ### ### ### ### 
### 
### ### ### ### ### ### ### ### ### ### ### ### 
sub randomizeArr{
    my $this=shift;
    my $P_arr=shift;
    my @tmp;
    while (@{$P_arr}>1) {
	push(@tmp,$P_arr->[0]);
	push(@tmp,$P_arr->[-1]);
	shift(@{$P_arr});
	pop(@{$P_arr});
    }
    if (@{$P_arr}==1) {push(@tmp,$P_arr->[0]);}
    @{$P_arr}=(@tmp);
}

#### #### #### #### #### #### ####  #### #### 
#### Print any complicated hash/array, send in reference
#### #### #### #### #### #### ####  #### #### 
sub prettyPrint{
    my $this = shift;
    my $P_tmp = shift;
    if(!defined($P_tmp)){
	print "UNDEFINED \n";
    }
    my $body = shift;
    my $local = "";
    my $tmp = ref($body);
    my $printlocal = 0;
    if(!defined($tmp) || $tmp eq ""){
	$printlocal = 1;
	$body = \$local;
	#print "prettyPrint:GIVE ME A BODY REF AFTER THE OBJECT POINTER \n";
    }
    #$body = $$body;
    my $prefix = shift;
    if(!defined($prefix)){
	$prefix = "";
    }
    my $name = ref($P_tmp);
    # my $body ="\n";
    if($name =~/\bHASH\b/){
	$$body .= $prefix."HASH = \n";
	foreach(sort keys %$P_tmp){
	    if(ref($P_tmp->{$_})){
		$$body .=  $prefix."\t <<$_>> => \n";
		$this->prettyPrint($P_tmp->{$_},$body,$prefix."\t"); 
	    }else {
		if(!defined($P_tmp->{$_})) {# take care of undefined values.
		    $$body .=  $prefix."\t $_ => UNDEFINED \n"; 
		}else {
		    $$body .=  $prefix."\t $_ => <<".$P_tmp->{$_}.">>\n";
		}
	    }
	}
    }elsif($name =~/\bARRAY\b/){
	$$body .= $prefix."ARRAY = ";
	my $i =0;
	foreach(@$P_tmp){
	    if(!defined($_)){
		$$body .=  "\n".$prefix."\t [$i] = UNDEFINED ";
	    } else {
      		if(ref($_)){
		    $$body .=  "\n".$prefix."\t [$i] = ";
		    $this->prettyPrint($_,$body,$prefix."\t"); 
		}else {
		    $$body .=  "\n".$prefix."\t [$i] = <<$_>>\n";
		}
	    }
	    $i++;
	}
    }elsif($name =~/\bSCALAR\b/){
	$$body .= $prefix."SCALAR = \n";
	$$body .= $prefix."\t".$$P_tmp;
    }
    print "$local \n" if($printlocal ==1);
    return ;
}
#### #### #### #### #### #### #### 
#### iniReader reads all the inifiles (ext .ini) in the local
#### directory and loads them into a hash.  
#### #### #### #### #### #### #### 
sub iniReader {
    my $this = shift;
    my $datain = shift;
    ## get the current directory
    # PWD is the Present Working Directory

    open (PWD,"pwd | "); 
    my $dir = <PWD>;
    if(defined($dir)) {chop($dir);}
    $dir .= "/";
    my $PH_tmp = {};

    opendir(DIR,$dir) or die "$dir cannot be opened ";
    my @filelist = readdir(DIR);
    closedir(DIR);
    @filelist= sort (@filelist); 

    #@filelist=<$dir/*.ini>;

    my $filewpath;
    foreach(@filelist){
	$filewpath = $dir.$_;
	if(-d $filewpath) { 
	} 
	elsif(-f $filewpath) {
	  if((defined($datain) && $_ =~/^$datain$/) ||
	    (!defined($datain) && $_ =~/^\w.*\.ini$/)) { 
	   #  if($_=~/\.ini$/){
#  print "filewpath = <$filewpath>\n";
		  
	    open INI, "<$filewpath" ||
	      die "have problems opening ini file $filewpath ";
	    while(<INI>){
		    my $init = $_;
		    next if($init =~ /^\s*\#/);
		    my @init = split(/[^\\]\#/,$init);
		    $init = $init[0];
		    # get rid of empty spaces in begin/end of lines
		    $init =~ s/^\s+//;
		    $init =~ s/\s+$//;
		    next if($init eq ""); # get rid of empty lines
		    my @tmp = split(/\s+/,$init);
		    for(my $i=2;$i<@tmp;$i++)
		      {$tmp[1] .= " $tmp[$i]";}
		    if(defined($tmp[1])){
		      $tmp[1] =~ s/^\s+//; $tmp[1] =~ s/\s+$//;
		      if($tmp[1] eq "" || $tmp[1] =~ /^\s+$/){$tmp[1] = undef;}
		      elsif($tmp[1] =~ /\byes\b/i){$tmp[1] = 1;}
		      elsif($tmp[1] =~ /\bNo\b/i){$tmp[1] = 0;}
		    }

		    if(defined($tmp[0])){
		      if($tmp[0] =~ /\bschemasToDump\b/i){
			$tmp[1] =~ s/\s+//g;
			my @schemasList =  split(/,/,$tmp[1]);
			$tmp[1] = \@schemasList ;
		      }
		    }

		    $PH_tmp->{$tmp[0]} = $tmp[1];
		  }
	    last; ## read only one ini file.
	  }
	}
    }
    return ($PH_tmp);
}

#### #### #### #### #### #### #### 
#### iniBareReader reads specified ini file, in a nice fashion
#### ignores escaped \#, like iniReader, except values with spaces in them
#### can be specified using quotes.
#### #### #### #### #### #### #### 
sub iniBareReader {
    my $this = shift;
    my $datain = shift;
    if(!defined($datain) || $datain !~ /\.ini$/){ 
      die "usage iniBareReader(data.ini)"; 
    } 
    ## get the current directory
    open (PWD,"pwd | "); 
    my $dir = <PWD>;
    if(defined($dir)) {chop($dir);}
    $dir .= "/";
    my $PH_tmp = {};
    
    my $filewpath = $dir.$datain;
		  
    open INI, "<$filewpath" ||
      die "have problems opening ini file $filewpath ";
    while(<INI>){
      my $init = $_;
      my @init = split(/[^\\]\#/,$init);
      $init = $init[0];
      # get rid of empty spaces in begin/end of lines
      $init =~ s/^\s+//;
      $init =~ s/\s+$//;
      next if($init eq ""); # get rid of empty lines
      $init =~ s/\\\#/\#/g;
      my @tmp;
      if($init =~ /\".+\"/){ 
	@tmp = split(/\s+\"/,$init);
	$tmp[1] =~ s/\"//;
      } else { 
	@tmp = split(/\s+/,$init);
      } 
      for(my $i=2;$i<@tmp;$i++){
	$tmp[1] .= " $tmp[$i]";
      }
      if(defined($tmp[1])){
	$tmp[1] =~ s/^\s+//; $tmp[1] =~ s/\s+$//;
	if($tmp[1] eq "" || $tmp[1] =~ /^\s+$/){$tmp[1] = undef;}
	elsif($tmp[1] =~ /\byes\b/i){$tmp[1] = 1;}
	elsif($tmp[1] =~ /\bNo\b/i){$tmp[1] = 0;}
      }

      $PH_tmp->{$tmp[0]} = $tmp[1];
    } 
    return ($PH_tmp);
  }
##### ##### ##### ##### ##### ##### ##### 
#####  Returns the UTC time now
#####  in a format that we like for the database
##### ##### ##### ##### ##### ##### ##### 
sub UTCnow{
# I return the current time in a string compatible with our Oracle requirements
    my $this = shift;
    my $offset = tz_local_offset();
    my $now = time();
    my $UTC = $now - $offset;
    $now = ctime($UTC);
    return $this->oracleTime($now);
}
##### ##### ##### ##### ##### ##### ##### 
#####  Returns the UTC Date now
#####  in a format that we like for the database
##### ##### ##### ##### ##### ##### ##### 
sub UTCdatenow{
# I return the current Date in a string compatible with our Oracle requirements
    my $this = shift;
#    my $offset = tz_local_offset();
#    my $now = time();
#    my $UTC = $now - $offset;
#    $now = ctime($UTC);
#    return $this->oracleDate($now);
}

##### ##### ##### ##### ##### ##### ##### 
#####  Returns the UTC Date now
#####  in a format that we like for the database
##### ##### ##### ##### ##### ##### ##### 
sub UTCmysqldatenow{
# I return the current Date in a string compatible with our Oracle requirements
    my $this = shift;
    my $offset = tz_local_offset();
    my $now = time();
    my $UTC = $now - $offset;
    $now = ctime($UTC);
    return $this->mysqlDate($now);
}

##### ##### ##### ##### ##### ##### ##### 
#####  Returns the normal Date now
#####  in a format that we like for the database
##### ##### ##### ##### ##### ##### ##### 
sub datenow{
# I return the current Date in a string compatible with our Oracle requirements
    my $this = shift;
    my $now = time();
    $now = ctime($now);
    return $this->oracleDate($now);
}
##### ##### ##### ##### ##### ##### ##### 
#####  takes time in a reasonable format and returns 
#####  in a format that we like for the database
##### ##### ##### ##### ##### ##### ##### 
sub oracleTime {
# Give me an arbitrary time string and I will give you the time.
# returns time in the format preferred by oracle. 
    my $this = shift;
    my $template = shift(@_);
    $template = parsedate($template);
    if(!defined($template)) {
	return (undef,undef,&testP::errHandler( "you gave an invalid date "));
    }
     $template = ctime($template);
    my @t_array = split(/\s+/,$template);
    my @time_array = split(/:/,$t_array[3]);
    my $timeEnd = "A.M.";
    my $format = "DD-MON-YYYY HH:MI:SS";

    ##### Fix the AM PM thing, carefully for the noon and midnight cases.

    if($time_array[0] == 0){
	$time_array[0] = 12;
	$timeEnd="A.M.";
    }elsif($time_array[0] == 12){
	$timeEnd="P.M.";
    }elsif($time_array[0] > 12){
	$time_array[0]=$time_array[0]-12;
	$timeEnd="P.M.";
    }

    if($time_array[0] <10){
	$time_array[0]="0".$time_array[0];
    }
    $t_array[3] = $time_array[0].":".$time_array[1].":".$time_array[2];
    
    my $i=0;
    if($t_array[2] <10){
	$t_array[2]="0".$t_array[2];
    }
    $template = $t_array[2];
    $template = $template."-".$t_array[1]."-".$t_array[5]." ".$t_array[3]." ".
	$timeEnd;
    return ($template,$format." ".$timeEnd,1,"sub::oracleTime::success");
}


##### ##### ##### ##### ##### ##### ##### 
#####  takes time in a reasonable format and returns 
#####  in a format that we like for the database
##### ##### ##### ##### ##### ##### ##### 
sub oracleDate {
# Give me an arbitrary time string and I will give you the time.
# returns date in the format preferred by oracle. 
## but 
    my $this = shift;
    my $template = shift(@_);
    # print "template oracleDate:<$template>\n";   
    $template = parsedate($template);
    if(!defined($template)) {
	return (undef,undef,0,"you gave an invalid date ");
    }
    # print "template oracleDate2:<$template>\n";   
    $template = ctime($template);
    # print "template oracleDate3:<$template>\n";   

    my @t_array = split(/\s+/,$template);
    my @time_array = split(/:/,$t_array[3]);

    # my $timeEnd = "A.M.";
    # my $format = "DD-MON-YYYY HH:MI:SS";
    my $format = "DD-MON-YYYY";

    my $i=0;

    if($t_array[2] <10){$t_array[2]="0".$t_array[2];}

    $template = $t_array[2];

    #$template = $template."-".$t_array[1]."-".$t_array[5]." ".$t_array[3]." ".
    #$timeEnd;

    ## NOTEBOOK
    $template = $template."-".$t_array[1]."-".$t_array[-1];

    ###  $template = $template."-".$t_array[1]."-".$t_array[4];
    ###  print "$template in oracleDate \n";
    ###  print "<@t_array> in oracleDate \n";
    return ($template,$format,1,"sub::oracleTime::success");
}

##### ##### ##### ##### ##### ##### ##### 
#####  takes time in a reasonable format and returns 
#####  in a format that we like for the database
##### ##### ##### ##### ##### ##### ##### 
sub mysqlDate {
# Give me an arbitrary time string and I will give you the time.
# returns date in the format preferred by oracle. 
## but 
    my $this = shift;
    my $template = shift(@_);
    # print "template oracleDate:<$template>\n";   
    $template = parsedate($template);
    if(!defined($template)) {
	return (undef,undef,0,"you gave an invalid date ");
    }
    # print "template oracleDate2:<$template>\n";   
    $template = ctime($template);
   #    print "template oracleDate3:<$template>\n";   

    my @t_array = split(/\s+/,$template);
    my @time_array = split(/:/,$t_array[3]);

    # my $timeEnd = "A.M.";
    # my $format = "DD-MON-YYYY HH:MI:SS";
    my $format = "DD-MON-YYYY";

    my $i=0;

    if($t_array[2] <10){$t_array[2]="0".$t_array[2];}

    $template = $t_array[2];

    #$template = $template."-".$t_array[1]."-".$t_array[5]." ".$t_array[3]." ".
    #$timeEnd;

    ## NOTEBOOK
    $template = $template."-".$t_array[1]."-".$t_array[-1];
    $template =~ tr/a-z/A-Z/;
    $template =~  s/(\d\d)-([A-Z][A-Z][A-Z])-(\d\d\d\d)/$3-$month{$2}-$1/g;      

    ###  $template = $template."-".$t_array[1]."-".$t_array[4];
    ###  print "$template in oracleDate \n";
    ###  print "<@t_array> in oracleDate \n";
    return ($template,$format,1,"sub::mysqlTime::success");
}
### ### ### ### ### ### ### ### ### ### ### ### ### 
## flattens tree to make it useable in programs
## for traversal, gets ref to a list and fills it up, recursively.
###  Usage lister($top_dir,\@list);
### ### ### ### ### ### ### ### ### ### ### ### ### 
sub lister{			#matches bracket 1
  my $this = shift;
  my $dir = shift;
  my $P_flist = shift;
  # print "lister = <$dir> \n";
  opendir(DIR,$dir) or die "$dir cannot be opened ";
  my @flist = readdir(DIR);
  closedir(DIR);
  # print "dir = <$dir> and flist = <@flist>\n";
  foreach(@flist){
    next if($_ =~/^\.+$/);
    $_ = $dir."/$_";
    if(-d $_){ 
      # print "directory <$_>\n";
      $this->lister($_,$P_flist);
      next;  
    } 
    push(@{$P_flist},$_);
  } 
}  
### ### ### ### ### ### ### ### ### ### ### ### ### 
## listdir -- same as lister, but lists only the directories.
### ### ### ### ### ### ### ### ### ### ### ### ### 
sub listdir{			#matches bracket 1
  my $this = shift;
  my $dir = shift;
  my $P_flist = shift;
  opendir(DIR,$dir) or die "$dir cannot be opened ";
  my @flist = readdir(DIR);
  closedir(DIR);
  push(@{$P_flist},$dir); ## include self in the list.
  # print "dir = <$dir> and flist = <@flist>\n";
  foreach(@flist){
    next if($_ =~/^\.+$/);
    my $file = $dir."/$_";
    if(-d $file){ 
      $this->listdir($file,$P_flist);
      push(@{$P_flist},$file);
      next;  
    } 
  } 
}  
####### ####### ####### ####### ####### ####### ####### ####### 
#####  pads zeros to num to make them alphabetically sortable.
####### ####### ####### ####### ####### ####### ####### ####### 
sub padzeros{
  my $this = shift;
  my $num=shift;
  my $base=shift;## 1e7
  if($num=~/^0/){ return $num;} ## probably padded.
  my $pad="";
  while($base>1){
    if($num<$base){$pad.="0";}else{last;}
    $base/=10;
  }
  return "$pad$num";
}
#####   #####   #####   #####   #####   #####   #####   
#####  repeat_report
#####  send in the sequence and it returns the 
#####   number of x's, a list of indexes, and a corresponding list of 
#####    x-region lengths    uses 1-based counting.
#####   #####   #####   #####   #####   #####   #####   
sub repeatReport{
  my $this = shift;
  my $P_line = shift;
  my $pat = shift;
  $$P_line =~ s/\s+$//;
  my $len = length($$P_line);
  my $xnum = ($$P_line =~ s/($pat)/$1/g);

  my @tmp = split(/$pat+/,$$P_line);
  my $rnum;

  if($$P_line=~/$pat$/){$rnum = @tmp;} else { $rnum = @tmp-1; } 
  my @lets = split(//,$$P_line);
  my $length = 0;my @index;my @lens;
  for(my $i=0;$i<$rnum;$i++){
    my $len = length($tmp[$i]);
    $length += $len;
    ####### 
    ### Repeat_Report -- report repeats using 1-based counting.
    #######
    push(@index,($length+1));
    my $tmp =0;
    while($lets[$length] =~ /$pat/){
      $length++;$tmp++;
      if(!defined($lets[$length])){last;} 
    }
    push(@lens,$tmp);
  }
  my $perc = 100*$xnum/$len;
  return($perc,\@index,\@lens);
}
### ### ### ### ### ### ### ### ### ### 
### rc
### ### ### ### ### ### ### ### ### ### 
sub rc
  {
      my $this=shift;
      my $str=shift;
      $str = reverse($str);
      $str=~tr/ACGT/TGCA/;
      return $str;
  }
####   #####   #####   #####   #####   #####   #####   
#### cleanAnn remove undesirables
####   get rid of any labels that do not need to be in the sequence
####   #####   #####   #####   #####   #####   #####   
sub cleanAnn{
  my $this = shift;
  my $P_ann = shift; ## of form [[1,a_start,stuff],[2,a_end,stuff]]
  my $P_exclude=shift;
  @{$P_ann}=sort{$a->[0]<=>$b->[0]}@$P_ann;##normal sort

  my @tmp;
  my $num = @{$P_ann};
  for (my $i=0;$i<$num;$i++) {
      my ($element1,$stend1,$num1,$typ1)=
	$P_ann->[$i]->[1]=~/^([^_]+)_(start|end)_(\d+)_(\S+)/;
      if (defined($P_exclude->{$element1})) {next;}
      push(@tmp,[@{$P_ann->[$i]}]);
  }
  @{$P_ann}=@tmp;
}
######################################################
######################################################
###sort annotations in .ann files for webdraw etc.
###   make sure not overlapping guys,
###only two kinds considered
##### 1)    a_start,b_start,b_end,a_end
##### 2)    a_start,b_start,a_end,b_end
######################################################
######################################################
sub ann_sort{
  my $this = shift;
  my $P_ann = shift; ## of form [[1,a_start,stuff],[2,a_end,stuff]]

  @{$P_ann}=sort{$a->[0]<=>$b->[0]}@$P_ann;##normal sort
  my @tmp;
  my $num = @{$P_ann};
  for (my $i=0;$i<($num-1);$i++) {
      my ($pos1,$stuff1)=($P_ann->[$i]->[0],$P_ann->[$i]->[2]);
      my ($element1,$stend1,$num1,$typ1)=
	$P_ann->[$i]->[1]=~/^([^_]+)_(start|end)_(\d+)_(\S+)/;

      my ($pos2,$stuff2)=($P_ann->[$i+1]->[0],$P_ann->[$i+1]->[2]);
      my ($element2,$stend2,$num2,$typ2)=
	$P_ann->[$i+1]->[1]=~/^([^_]+)_(start|end)_(\d+)_(\S+)/;
      if (
	  ($element1 eq $element2)&& ($stend1 eq "start")
	  && ($stend2 eq "end") && ($num1==$num2) &&($typ1 eq $typ2)
	 ) {
	  push(@tmp,[@{$P_ann->[$i]}]);
	  push(@tmp,[@{$P_ann->[$i+1]}]);
	  $i++;
	  next;
      }

      ## if this does not exist, we are in really deep doo-doo
      my ($pos3,$stuff3)=($P_ann->[$i+2]->[0],$P_ann->[$i+2]->[2]);
      my ($element3,$stend3,$num3,$typ3)=
	$P_ann->[$i+2]->[1]=~/^([^_]+)_(start|end)_(\d+)_(\S+)/;

      if(
	 ( $element1 eq $element3 )
	 && ( $stend1 eq "start")
	 && ( $stend3 eq "end" )
	 && ( $num1 == $num3 )
	 &&( $typ1 eq $typ3 )
	) {
	  ## exchange elements 2 and 3 (along with positions and you are
	  ## hunky-dory)
	  my $tmp=$P_ann->[$i+2]->[0];
	  $P_ann->[$i+2]->[0]=$P_ann->[$i+1]->[0];
	  push(@tmp,[@{$P_ann->[$i]}]);
	  push(@tmp,[@{$P_ann->[$i+2]}]);
	  @{$P_ann->[$i+2]}=@{$P_ann->[$i+1]};
	  $i++;next;
      }
      elsif(
	    ($element2 eq $element3)  && ( $stend2 eq "start") && 
	    ($stend3 eq "end") && ($num2 == $num3) && ($typ2 eq $typ3)
	   ){
	    ## close element  1 before element 2 and
	    ## open element 1 after element 3
	    #($pos1,$stuff1) ($element1,$stend1,$num1,$typ1)=
	    push(@tmp,[@{$P_ann->[$i]}]);
	    push(@tmp,[$pos2-1,"$element1"."_end"."_$num1"."_$typ1",
		       $stuff1]);
	    push(@tmp,[@{$P_ann->[$i+1]}]);
	    push(@tmp,[@{$P_ann->[$i+2]}]);
	    @{$P_ann->[$i+2]}=
	      ($pos3+1,"$element1"."_start"."_$num1"."_$typ1",
	       $stuff1);
	    $i++;
	    next;
	} 
      else {die "bad nesting in the ann file";}
  }
  @{$P_ann}=@tmp;
  @{$P_ann}=sort{$b->[0]<=>$a->[0]}@$P_ann;##reverse sort
}
######################################################
######################################################
###sort annotations in .ann files for webdraw etc.
###   make sure not overlapping guys,
###only two kinds considered
##### this takes care of deep nesting.
######################################################
######################################################
sub ann_sort_nest{
  my $this = shift;
  my $P_ann = shift; ## of form [[1,a_start,stuff],[2,a_end,stuff]]

  ## annsort makes sure start comes before end, even if they are at the same spot
  @{$P_ann}=sort{annsort($a,$b)}@$P_ann;##reverse sort
#   @{$P_ann}=sort{$a->[0]<=>$b->[0]}@$P_ann;##normal sort

  my $num = @{$P_ann};

  ## separate guys on top of each other, by at least one
  for (my $i=1;$i<$num;$i++) {
      if ($P_ann->[$i]->[0]<=$P_ann->[$i-1]->[0]){ 
	  $P_ann->[$i]->[0]=($P_ann->[$i-1]->[0]+1);
      }
  } 
  my @newlist;
  my @open;
  my $newnum =$num+1;
  for (my $i=0;$i<$num;$i++) {
#      $this->prettyPrint($P_ann->[$i]);
#      print "---open below-------\n";
#      $this->prettyPrint(\@open);
#      print "++++++i=$i+++++++++++++++++++++++++++++++++++++++++++++++\n";
      my $pos=$P_ann->[$i]->[0];
      my ($type,$stend,$num,$name)=$P_ann->[$i]->[1]=~
	/^([^_]+)_(start|end)_(\d+)_(\S+)/;
      my $defn=$P_ann->[$i]->[2];
      if ($stend=~/start/) {
	  my $P_elem=pop(@open);
	  if (defined($P_elem)){
	      my @elem=@{$P_elem};
	      ## worry about guys right next to each other at some point
	      if (($pos-$elem[0])<1) 
		  ## the guys are too close, so use the same coordinate
		{ 
		    push(@newlist,[$pos,$elem[1]."_end_".
				 $elem[3]."_".$elem[4],""]);
		}else{
		    push(@newlist,[$pos-1,$elem[1]."_end_".
				   $elem[3]."_".$elem[4],""]);
		}
	      push(@open,[@elem]);
	  }
	  push(@newlist,[$pos,$type."_$stend"."_$num"."_$name",$defn]);
	  push(@open,[$pos,$type,$stend,$num,$name,$defn]);
      }elsif ($stend=~/end/) {
	  my $P_elem=pop(@open);
	  if (defined($P_elem)){
	      my @elem=@{$P_elem};
	      if ($type eq $elem[1] &&  $num==$elem[3] &&  $name eq $elem[4])
		{
		    ## they are the same guys, so no problema
	    push(@newlist,[$pos,$type."_$stend"."_$num"."_$name",$defn]);
	    ## start the other open guy
	  my $P_elem=pop(@open);
	  if (defined($P_elem)){
	      my @elem=@{$P_elem};
	      push(@newlist,[$pos+1,$elem[1]."_start"."_$elem[3]".
			     "_$elem[4]",$elem[5]]);
	      push(@open,$P_elem);
	  } 
	}
	      else {
		  ## you found a different open, so get rid of this close.
		  ## get rid of corresponding open in the @open list
		  my $badi;
		  for (my $jk=0;$jk<@open;$jk++) {
		      my ($type2,$num2,$name2)=
			($open[$jk]->[1],$open[$jk]->[3],$open[$jk]->[4]);
			  if (
			      ($type eq $type2) &&  ($num==$num2)&& 
			      ($name eq $name2)
			     )
			  {
#			      print "anem-type,jk=$jk\n$name,$type,$num\n";
#			      print "$name2,$type2,$num2\nanem-type\n";
			      $badi=$jk;last;
			  }
		  }
		  if(defined($badi)){
		      splice(@open,$badi,1);
		  } else {
		      die "should have found a corresponding open, something bad";
		  }
		  push(@open,$P_elem);
	      }
	  } else 
	    {
		## nothing in open
		die "something wrong because you have an end".
	       "without a begin\ni=$i\n$pos,$type,$stend,$num,$name,$defn\n";
	    }
      }
  }
  @{$P_ann}=@newlist;
  ## annsort makes sure start comes before end, even if they are at the same spot
  @{$P_ann}=sort{annsort($b,$a)}@$P_ann;##reverse sort
}

sub annsort{
    my $a=shift;
    my $b=shift;
    if ($a->[0] != $b->[0])
      {return $a->[0] <=> $b->[0];}
    else {
	if ($a->[1]=~/_start_/) {return 0<=>1;}
	elsif($b->[1]=~/_start_/) {return 1<=>0;}
	else{return $a->[1] cmp $b->[1];}
    }
}
1;

=head1 NAME

SNP::myUtil.pm - set of utilities for my use.

=head1 SYNOPSIS

    use SNP::myUtil;
    $mUtil =  SNP::myUtil->new();
    $mUtil->prettyPrint($PH_tmp,$body,$prefix);
    $PH_tmp = $mUtil->iniReader();
    $retVal = $mUtil->isNumber($number);
    ($time,$errCode,$errMessage) = $mUtil->UTCnow();
    ($time,$errCode,$errMessage) = $mUtil->oracleTime($TimeString);

=head1 REQUIRES

B<Needs the following to be installed> I<Time::CTime, Time::ParseDate,
Time::Timezone>

=head1 EXPORTS

nothing

=head1 METHODS AND USAGE

There are several methods in this package for making life easier.
They do not fit into any other package, so appear here.

=over 6

=item SNP::myUtil->new()

No special inputs required

=item $myUtil->prettyPrint($PH_tmp,\$body,[$prefix]);

I<$PH_tmp> is a reference to the structure to be printed. 
I<$body> is where the pretty print string is placed, print
it from your program, I<$prefix> if used, could be something
like "\t" or "***" to beautify output.

=item  $myUtil->iniReader()

iniReader reads *.ini files in the working directory and returns a 
reference to a Hash which contains the key/value pairs. Nice thing 
about this is the files can have blank lines, comments are marked 
with # and you can store many alternative definitions for variables, 
the last one is always chosen (or the value in the alphabetically 
last file). Translates all the Yes to 1 and all No to 0, since this 
is the code used internally in the programs.

=item  $myUtil->isNumber($number)

isNumber returns 1  if $number is  a string that can be 
interpreted as a number by PERL, else returns 0. 

=item  $myUtil->UTCnow()

returns an array ($time,$format,$errCode,$errMessage), with time
in the format recognised by Oracle, $format the format string and
$errCode (0,1) for error (yes,no) and an error message if there is one.

=item  $myUtil->oracleTime($timeString)

oracleTime take as input a string which can be reasonably taken
to be a time value, and returns an array 
($time,$format,$errCode,$errMessage)  with time in the format 
recognised by Oracle, $format the format string and
$errCode (0,1) for error (yes,no) and an error message if there 
is one. $time and $format can be used in the sqlplus function sysdate. 


=back

=head1 AUTHOR

Ravi Sachidanandam, CSHL. ravi@cshl.org


=cut


