#!/opt/bin/perl -w
#######################
### dbUtil.pm
#######################
use strict;
######   ######   ######   ######   ######   ######   ######   
package Gramene::Util::dbUtil;
use lib("/a/swiss/export/home/shuly/ravi");
use DBI qw(:sql_types);
use Gramene::Util::myUtil;
my $myUtil;

# my ($DSN,$oraUser,$oraPW,$dbh);
my ($errCode,$errMessage) = (1,"OKAY");
my (@sql_types,@tableNames);
# my $sth;
# my $enterData;

my $RaiseError;
my $AutoCommit;

my @sthinsertList;
my @sqlinsertList;
my @colinsertList;

my @sthselectList;
my @sqlselectList;
my @colselectList;
my @whereselectList;

my @sthupdateList;
my @sqlupdateList;
my @colupdateList;
my @whereupdateList;

my @multiSelectTables;
##### ##### ##### ##### ##### ##### ##### 
##### new constructor.
##### ##### ##### ##### ##### ##### #####
sub new{
 my $name = shift;
 my $datain = shift;
 my $class = ref($name) || $name;
 my $this = {};
 bless $this,$class;
 $myUtil=new Gramene::Util::myUtil();
 my $PH_tmp = $myUtil->iniReader($datain);
 $this->{enterData}  = $PH_tmp->{enterData};
 $this->{commitEachStep} = $PH_tmp->{commitEachStep};
 $this->{debug} = $PH_tmp->{debug};
 if(!defined($this->{debug})) { $this->{debug} = 0; } 
 if(!defined($this->{commitEachStep})) {$this->{commitEachStep} = 1;} 
 my $DSN = $PH_tmp->{DSN};
 my $oraUser = $PH_tmp->{oraUser};         
 my $oraPW = $PH_tmp->{oraPW}; 
 ($this->{dbh},$errCode,$errMessage) = $this->createDBH($DSN,$oraUser,$oraPW);
 return(undef,$errCode,$errMessage) if($errCode ==0);

 my $tmp; 
 if($DSN =~ /Oracle/i){$tmp =  $this->tNames();@tableNames = @{$tmp};}
 return ($this,$errCode,$errMessage);
}
#### #### #### #### #### #### #### 
#### createDBH
#### #### #### #### #### #### #### 
sub createDBH{
  my $this = shift;
  my $DSN = shift;
  my $oraUser = shift;
  my $oraPW = shift;
  # print "$DSN,$oraUser,$oraPW \n";
  my  $dbh;
  my $RaiseError=1;
  # my $AutoCommit = 0;
  if($DSN =~ /mysql/i){ ## for transaction business
    $AutoCommit = undef;
    $dbh = DBI->connect($DSN,$oraUser,$oraPW,{RaiseError => $RaiseError})
    ||   return(0,"sub::createDBH::Cannot connect: $DBI::errstr") ;

  } else { 
    $AutoCommit = 0;
    $dbh = DBI->connect($DSN,$oraUser,$oraPW,{RaiseError => $RaiseError,
					      AutoCommit =>$AutoCommit})


    #$dbh = DBI->connect("dbi:Oracle:",
    #                   q{$oraUser/$oraPW@(DESCRIPTION=
    #                                 (ADDRESS=(PROTOCOL=TCP)
    #                                  (HOST=raclette)(PORT=1521))
    #                                 (CONNECT_DATA=(SID=gramene)))},
    #                   "")
    ||   return(0,"sub::createDBH::Cannot connect: $DBI::errstr") ;

  } 
  $dbh->{LongReadLen} = 100*65535;
  $dbh->{LongTruncOk} = 0;
  return($dbh,$errCode,$errMessage);
}
#### #### #### #### #### #### #### 
####  Get Ref to DB pointer
#### #### #### #### #### #### #### 
sub getdbh{
  my $this = shift;
  my $dbh = $this->{dbh};
  return (\$dbh);
}
#### #### #### #### #### #### #### 
#### tNames
#### #### #### #### #### #### #### 
sub tNames{
    my $this = shift;
    ###  ###  ###  ###  ###  ###  
    ### Another way of doing it. 
    ###  ###  ###  ###  ###  ###  
    # @tableNames = $dbh->tables;
    my @tmp = $this->selectSQL(Tables=>["cat"],
			       Columns=>["table_name"],
			       Where=>["table_type = 'TABLE'"]
			       );
    if($tmp[1] == 0) {
	print "Error in tName <<$tmp[2]>> \n";
	die "what a death";
    }
    my @ttmp = @{$tmp[0]};my @tlist;
    foreach(@ttmp){push(@tlist,$$_[0]);}
    @tableNames = @tlist;
    return \@tlist;
}
sub schemaTables{
    my $this = shift;
    my $owner = shift;
    ###  ###  ###  ###  ###  ###  
    ### Another way of doing it. 
    ###  ###  ###  ###  ###  ###  
    # @tableNames = $dbh->tables;
    my @tmp = $this->selectSQL(Tables=>["all_tables"],
			       Columns=>["table_name"],
			       Where=>["owner='$owner'"]
			       );
    if($tmp[1] == 0) {
	print "Error in schemaTables <<$tmp[2]>> \n";
	die "what a death";
    }
    my @ttmp = @{$tmp[0]};my @tlist;
    foreach(@ttmp){push(@tlist,$$_[0]);}
    @tableNames = @tlist;
    return \@tlist;
}
#### #### #### #### #### #### #### 
#### getTables
#### #### #### #### #### #### #### 
sub getTables{return \@tableNames;}
#### #### #### #### #### #### #### 
#### getTypes
#### #### #### #### #### #### #### 
sub getTypes{return \@sql_types;}
#### #### #### #### #### #### #### 
#### commit
### to prevent accidental commits via ini file
#### #### #### #### #### #### #### 
sub commit{
  my $this = shift;
  my $mess = shift;
  my $dbh = $this->{dbh};
  if(defined($AutoCommit)){
    if($this->{enterData} ==1){
	$dbh->commit();
	if(!defined($mess)) {return (1,"committed ");}
      else {return (1,$mess."committed");} 
    } else { 
      if(defined($AutoCommit)){
	$this->rollback();
      } 
      if(!defined($mess)) {  return (1,"rolled back ");} 
      else {return (1,$mess."rolled back");} 
    } 
  } 
}
#### #### #### #### #### #### #### 
#### finish
#### #### #### #### #### #### #### 
sub finish{
  my $this = shift;
  my $dbh = $this->{dbh};
  foreach(@sthinsertList){$_->finish();}
  foreach(@sthselectList){$_->finish();}
  foreach(@sthupdateList){$_->finish();}
  $dbh->disconnect();
  $dbh = undef;
}

#### #### #### #### #### #### #### 
#### rollback
#### #### #### #### #### #### #### 
sub rollback{
  my $this = shift;
  my $dbh = $this->{dbh};
  if(defined($AutoCommit)){$dbh->rollback();}
  return(1,"dbUtil rolled back");
}
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
## This takes in a 
## usage $dbUtil->selectSQL(Tables=>["",""],
##                          Columns=>["",""],
##                          Where=>["",""],
##                          glue=>"AND",
##                          groupBy=>"",
##                          orderBy=>"",
##                          having=>"");
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
sub selectSQL{
    my $this = shift;
    my %H_sql = @_;
    my $table = $H_sql{Tables};
    my @tables = @$table;
    my $tableList = join(",",@tables);
    #### ORACLE  take out the "as" in table aliasing
    my $cols = $H_sql{Columns};
    # my @ret = ([""]);
    my $sql;
    if(defined($cols)){
	my @columns = @$cols;
	my $columnList = join(",",@columns);
	$sql = qq{SELECT $columnList FROM $tableList };
    } else {
	$sql =  qq{SELECT * FROM $tableList };
    }
    my $where = $H_sql{Where};
    my $glue = $H_sql{glue};
    if(defined($where) && defined($glue)){
	my @wheres = @$where;
	my $whereList = join(" $glue ",@wheres);
	$sql .= " WHERE $whereList ";
    } elsif(defined($where)){
	my @wheres = @$where;
	my $whereList = join(", ",@wheres);
	$sql .= " WHERE $whereList ";
    }
    my $groupBy = $H_sql{groupBy};
    $sql .= " GROUP BY $groupBy " if(defined($groupBy));
    my $orderBy = $H_sql{orderBy};
    $sql .= " ORDER BY $orderBy " if(defined($orderBy));
    my $having = $H_sql{having};
    $sql .= " HAVING $having " if(defined($having));
    # print "sql in selectSQL is <<$sql>> \n";
    my $dbh = $this->{dbh};
    my $sth = $dbh->prepare($sql);
    # my $num_fields;
    eval{$sth->execute();}; if($@) {
	my $tmp = $DBI::errstr;
	if(defined($AutoCommit)){
	  $this->rollback();
	} 
	return(undef,0,"selectSQL ERROR:$tmp");
    }
    my @result;
    #####       #####       #####       #####   
    ## put the results in an array.
    #####       #####       #####       #####   
    while(my @tmp = $sth->fetchrow) {push(@result,\@tmp); }
    $sth->finish();
    return (\@result,1,"selectSQL successful");
}
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
## This takes in a 
## usage $dbUtil->initSelectSQL(Tables=>["",""],
##                          Columns=>["",""],
##                          Where=>["",""],
### EACH GUY in where must contain a ? (for binding);
##                          glue=>"AND",
##                          groupBy=>"",
##                          orderBy=>"",
##                          having=>"");
### Bug, Cannot be used for queries that return more than one value.
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
sub initSelectSQL{
    my $this = shift;
    my %H_sql = @_;
    my $table = $H_sql{Tables};
    my @tables = @$table;
    print STDERR "MultiSelectSQL, does last column NULL result in error\n";
    if(@tables==0){die "give me tables, in initSelectSQL ";} 
    my $tableList = join(",",@tables);


    #### ORACLE  take out the "as" in table aliasing

    push(@multiSelectTables,$tableList);
    my $cols = $H_sql{Columns};
    # my @ret = ([""]);
    my $sql;
    my $index = @sthselectList;
    if(defined($cols)){
	my @columns = @$cols;
	push(@colselectList,\@columns);
	my $columnList = join(",",@columns);
	$sql = qq{SELECT $columnList FROM $tableList };
    } else {
	print "ERROR:call initSelectSQL with columns,<$tableList> \n"; exit;
    }
    my $where = $H_sql{Where};
    my $glue = $H_sql{glue};
    if(defined($where) && defined($glue)){
	my @wheres = @$where;
	push(@whereselectList,\@wheres);
	my $whereList = join(" $glue ",@wheres);
	$sql .= " WHERE $whereList ";
    } elsif(defined($where)){
	my @wheres = @$where;
	my $whereList = join(", ",@wheres);
	$sql .= " WHERE $whereList ";
    }
    my $groupBy = $H_sql{groupBy};
    $sql .= " GROUP BY $groupBy " if(defined($groupBy));
    my $orderBy = $H_sql{orderBy};
    $sql .= " ORDER BY $orderBy " if(defined($orderBy));
    my $having = $H_sql{having};
    $sql .= " HAVING $having " if(defined($having));
    
 #   print "sql in initSelectSQL is <<$sql>> \n";

    my $dbh = $this->{dbh};
    my $sth = $dbh->prepare($sql);
    push(@sthselectList,$sth);
    return $index;
  }
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
## Does it have a bug, last column cannot be a null
## 
## 
###
###
## 
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
sub MultiSelectSQL{
    my $this = shift;
    my %H_sql = @_;
    my $index = $H_sql{index};
    my $tableName = $multiSelectTables[$index];
    delete $H_sql{index};
    if(!defined($index)){ 
      return (undef,0,"index <$index> to MmultiSelectSQL not valid");
    } elsif( $index > (@sthselectList-1)) {
      return (undef,0,"index <$index> to MmultiSelectSQL is too big");
    } 
    my $sth = $sthselectList[$index];
    my @kys = keys(%H_sql);
    my @cols = @{$colselectList[$index]};
    @kys = sort{$a<=>$b} @kys; ### take this out later.
    for(my $i = 0;$i<@kys;$i++){
      #  print "keys <$kys[$i]> , <$H_sql{$kys[$i]}>\n" if($index==8);
      $sth->bind_param($kys[$i],$H_sql{$kys[$i]});
    }
    eval{$sth->execute();};
    if($@) {
	my $tmp = $DBI::errstr;
	$this->rollback();
	return(undef,0,"MultiselectSQL ERROR<$tableName>:$tmp,columns<@cols>");
    }
    my @test = @cols;
    my @tmp;
    for(my $i=0;$i<@cols;$i++){$tmp[$i] = \$cols[$i];}       
    $sth->bind_columns(undef,@tmp);
    my @result;
    while(my @trash = $sth->fetchrow){push(@result,\@trash);}
    for(my $ii=0;$ii<@test;$ii++){
      if(defined($cols[$ii]) && ($test[$ii] eq $cols[$ii])) {
	return (undef,-1,"MmultiselectSQL unsuccessful<$tableName> <@cols>");
      }
    }
    return (\@result,1,"multi selectSQL successful");
} 
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
## This is a modification of multiSelectSQL, to fix a bug there, 
## wherein, it does not let you get back more than one record.
## the data structure returned is identical to that returned by
### the normal select, but the usage is like multiSelectSQL
### returns a -1 if no columns returned.
## returns more than one set of values
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
sub MmultiSelectSQL{
    ###### HAS ABUG, the last columns cannot be null, or it returns nothing. 
    my $this = shift;
    my %H_sql = @_;
    my $index = $H_sql{index};
    my $tableName = $multiSelectTables[$index];
    delete $H_sql{index};


    if(!defined($index)){ 
      return (undef,0,"index <$index> to MmultiSelectSQL not valid");
    } elsif( $index > (@sthselectList-1)) {
      return (undef,0,"index <$index> to MmultiSelectSQL is too big");
    } 
    my $sth = $sthselectList[$index];
    my @kys = keys(%H_sql);
    my @cols = @{$colselectList[$index]};

    @kys = sort{$a<=>$b} @kys; ### take this out later.


    for(my $i = 0;$i<@kys;$i++){
      #  print "keys <$kys[$i]> , <$H_sql{$kys[$i]}>\n" if($index==8);
      $sth->bind_param($kys[$i],$H_sql{$kys[$i]});
    }       
    eval{$sth->execute();}; if($@) {
	my $tmp = $DBI::errstr;
	$this->rollback();
	return(undef,0,"selectMmultiSQL ERROR<$tableName>:$tmp, columns<@cols>");
    }


    my @test = @cols;

   #  my $pr =1;
    # print "Mmulti Start \n" if($pr==1);
    # $myUtil->prettyPrint(\%H_sql) if($pr==1);
    # print "cols <@cols> \n" if ($pr==1);

    my @tmp;
    for(my $i=0;$i<@cols;$i++){$tmp[$i] = \$cols[$i];}       
    $sth->bind_columns(undef,@tmp);
    my @result;

    while(my @trash = $sth->fetchrow) 
      {	
	# print "results of fetchrow \n";
	#$myUtil->prettyPrint(\@tmp);
	#### ORIGINAL
	#### my @tmp2 = map{$$_} @tmp; push(@result,\@tmp2);
	push(@result,\@trash);
	#$myUtil->prettyPrint(\@tmp2);
      }

   # print "printing results \n";
   # $myUtil->prettyPrint(\@result);
   # $sth->finish();

    for(my $ii=0;$ii<@test;$ii++){
      # print  "test/tmp <$test[$ii]>,<$cols[$ii]> \n" if($pr==1); 
      if(defined($cols[$ii]) && ($test[$ii] eq $cols[$ii])) {
	# print "Mmulti End 2 \n\n\n" if($pr==1);
	return (undef,-1,"MmultiselectSQL unsuccessful<$tableName> <@cols>");
      }
    }
#      print "Mmulti End 1 \n\n\n" if($pr==1);
    return (\@result,1,"multi selectSQL successful");
}
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
## This dumps a table with selected criterion into a 
## text file. You specify the delimiter. Returns 
## reference to a String. That can be printed in a file.
## specify DOS in input for dos output.
## usage $dbUtil->dump(tableName=>"tbl_trash",
##                     delimiter=>"\t",
##                     DOS=>1,
##                     Columns=>["name","id"],
##                     Where=>["name = 'trash'","id = 24"],
##                     glue=>" OR ")
##                     
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
sub dump{
    my $this = shift;
    my %H_sql = @_;
    my $tableName = $H_sql{tableName};
    if(!defined($tableName)) {die "please define table name in dump";}
    my $delimiter = $H_sql{delimiter};
    my $file = $H_sql{file};
    if(!defined($delimiter)) {$delimiter = "\t";}
    my $cols = $H_sql{Columns};
    my $sql;
    if(defined($cols)){
	my @columns = @$cols;
	my $columnList = join(",",@columns);
	$sql = qq{SELECT $columnList FROM $tableName };
    } else {$sql =  qq{SELECT * FROM $tableName };}
    my $where = $H_sql{Where};
    my $glue = $H_sql{glue};
    if(defined($where) && defined($glue)){
	my @wheres = @$where;
	my $whereList = join(" $glue ",@wheres);
	$sql .= " WHERE $whereList ";
    } elsif(defined($where)){
	my @wheres = @$where;
	my $whereList = join(", ",@wheres);
	$sql .= " WHERE $whereList ";
    }
    my $groupBy = $H_sql{groupBy};
    $sql .= " GROUP BY $groupBy " if(defined($groupBy));
    my $orderBy = $H_sql{orderBy};
    $sql .= " ORDER BY $orderBy " if(defined($orderBy));
    my $having = $H_sql{having};
    $sql .= " HAVING $having " if(defined($having));
    # print "sql in selectSQL is <<$sql>> \n";
    my $dbh = $this->{dbh};
    my $sth = $dbh->prepare($sql);
    eval{$sth->execute();}; if($@) {
	my $tmp = $DBI::errstr;
	$this->rollback();
	return(undef,0,"dumpSQL ERROR:$tmp");
    }
    my @result;
    #####       #####       #####       #####   
    ## put the results in an array.
    #####       #####       #####       #####  
    my $body = "";
    my $nl = "\n";
    while(my @tmp = $sth->fetchrow) {
	for(my $i =0;$i <@tmp;$i++){
	    if(!defined($tmp[$i])){
		$tmp[$i]= "";
	    }
	}
	for(my $i=0;$i<@tmp;$i++) {  ## take out any delimiters in the text
	  $tmp[$i] =~ s/$delimiter/_t_t_/g;
	  $tmp[$i] =~ s/$nl/_n_n_/g;
	} 
	my $tmp = join("$delimiter",@tmp);
	$body .= $tmp;
	if(defined($H_sql{DOS})){$body .= "\r\n";} else {$body .= "\n";}
	if(defined($file)){ print $file $body;}
	else {print $body;}
	$body = "";
    }
    $sth->finish();
    return (1,"dump successful");
}
sub dump_sequences{
    my $this = shift;
    my %args = @_ ;
    my $owner = $args{owner};
    my $file = $args{file};
    my $delimiter = $args{delimiter};
    if(!defined($delimiter)) {$delimiter = "\t";}
    
    my $sql_where_clause;
    if (defined $owner){
      $sql_where_clause = "sequence_owner='$owner'";
    }
    #my $owner = shift;
    ###  ###  ###  ###  ###  ###  
    ### Another way of doing it. 
    ###  ###  ###  ###  ###  ###  
    # @tableNames = $dbh->tables;
    my @tmp = $this->selectSQL(Tables=>["all_sequences"],
			       Columns=>["sequence_name,last_number"],
			       Where=>[$sql_where_clause]
			       #Where=>["sequence_owner='$owner'"]
			       );
    if($tmp[1] == 0) {
	print "Error in schemaSequences <<$tmp[2]>> \n";
	die "what a death";
    }
    my @ttmp = @{$tmp[0]};
    my @seqlist;
    
    my $body;
    my $tmp;
    foreach(@ttmp){
      push (@seqlist,{seqname=>$$_[0],last_number=>$$_[1]});
      
      if (defined $file){
	$tmp = join("$delimiter",@$_);
	$body .= $tmp;
	if(defined($args{DOS})){$body .= "\r\n";} else {$body .= "\n";}
	if(defined($file)){ print $file $body;}
	else {print $body;}
	$body = "";
      }
    }
    return \@seqlist;
}
####  ####  ####  ####  ####  ####  
####  execSQL
####  ####  ####  ####  ####  ####  
sub execSQL {
    my $this = shift;
    my $sql = shift;
    my $dbh = $this->{dbh};
    my $sth = $dbh->prepare($sql);

    eval{$sth->execute();}; if($@) {
	my $tmp = $DBI::errstr;
	$this->rollback();
	return(0,"execSQL ERROR:$tmp");
    }
    # while(my @tmp = $sth->fetchrow) {push(@result,\@tmp); }
    return (1,"execSQL successful");
}

###   ###   ###   ###   ###   
###   Prints the results returned by selectSQL
###   ###   ###   ###   ###   
sub printSelectResult{
    my $this = shift;
    my $result = shift;
    my @result = @{$result};
    foreach(@result){
	my @tmp = @{$_};
	foreach(@tmp){
	    if(defined($_)){
		print "$_, ";
	    }else{
		print "NULL, ";
	    }
	}
	print "\n";
    } 
}


####  ####  ####  ####  ####  ####  ####  ####  ####  
sub updateSQL{
    my $this = shift;
    my %H_sql = @_;

    my $tableName = $H_sql{tableName};
    if(!defined($tableName)) {die "please define table name in updateSQL";}
    my $set = $H_sql{Set};
    my @sets = @$set;
    my $setList = join(",",@sets);

    my $where = $H_sql{Where};
    my @wheres = @$where;
    my $glue = $H_sql{glue};
    my $whereList;
    if(defined($glue)){
	$whereList = join(" $glue ",@wheres);
    } else {
	$whereList = join(", ",@wheres);
    }
    my $sql = qq{UPDATE $tableName SET $setList  WHERE $whereList};



    my $dbh = $this->{dbh};
    my $sth = $dbh->prepare($sql); 
    my $enterData = $this->{enterData};
    eval{$sth->execute(); }; if($@) {
	my $tmp = $DBI::errstr;
	$this->rollback();
	return(0,"updateSQL ERROR:$tmp");
    }
    # $sth->finish();
    if($this->{commitEachStep} == 1){
      if($enterData==1){ 
	$this->commit();
	return (1,"updateSQL successful, commit");
      }
       else {
	 $this->rollback();
	 return (1,"updateSQL successful, rollback");
       }
    }
    return (1,"updateSQL successful");
}

####  ####  ####  ####  ####  ####  ####  ####  ####  
####  initUpdateSQL -- usage initUpdateSQL(tableName=>"tbl_trash",
####               Set=>["",""], Where=>["",""],glue=>"")
####  
####  ####  ####  ####  ####  ####  ####  ####  ####  
sub initUpdateSQL{
    my $this = shift;
    my %H_sql = @_;

    my $tableName = $H_sql{tableName};
    if(!defined($tableName)) {die "please define table name in initupdateSQL";}
    my $set = $H_sql{Set};
    my @sets = @$set;
    my $setList = join(",",@sets);

    my $where = $H_sql{Where};
    my @wheres = @$where;
    my $glue = $H_sql{glue};
    my $whereList;
    if(defined($glue)){
	$whereList = join(" $glue ",@wheres);
    } else {
	$whereList = join(", ",@wheres);
    }
    my $sql = qq{UPDATE $tableName SET $setList  WHERE $whereList};
    # print "sql in initUpdate <$sql> \n";
    # push(@sqlupdateList,$sql);

    my $dbh = $this->{dbh};

    my $sth;
  
    $sth = $dbh->prepare($sql); 
  

    my $index = @sthupdateList;
    push(@sthupdateList,$sth);
    # print "sth initupdate is <$sth>\n";
    # print "index of update is $index \n";
    return $index;
  }
###   ###   ###   ###   ###   ###   
###   ###   ###   ###   ###   ###   
## This takes in a 
## usage $dbUtil->multiUpdateSQL
##                         (index=>1,
##                          1=>"trash",
##                          2=>123);
sub MultiUpdateSQL{
    my $this = shift;
    my %H_sql = @_;
    my $index = $H_sql{index}; 
#    print "index in multiUpdateSQL <$index>\n";
    delete $H_sql{index};
    if(!defined($index)){ 
      return (undef,0,"index <$index> to multiUpdateSQL not valid");
    } elsif( $index > (@sthupdateList-1)) {
      return (undef,0,"index <$index> to multiUpdateSQL is too big");
    } 
    my $sql = $sqlupdateList[$index];
    # print "sql in <multiUpdateSQL> \n";
    my $sth = $sthupdateList[$index];
  #   print "sth is <$sth>\n";
    my @kys = keys(%H_sql);
    @kys = sort{$a<=>$b} @kys; ### take this out later.

    for(my $i = 0;$i<@kys;$i++){
      # print "keys <$kys[$i]> , <$H_sql{$kys[$i]}>\n";
      $sth->bind_param($kys[$i],$H_sql{$kys[$i]});
    }
    my $enterData = $this->{enterData};
    eval{$sth->execute(); }; if($@) {
	my $tmp = $DBI::errstr;
	$this->rollback();
	return(0,"updatemultiSQL ERROR:$tmp");
    }
    if($this->{commitEachStep} == 1){
      if($this->{enterData} ==1){ 
	$this->commit("multiupdateSQL committed ");
      } else { 
	$this->rollback("multiupdateSQL rolled back ");
      } 
    }
    return (1,"multiUpdateSQL successful");
}
###### ###### ###### ###### ###### ###### ###### ###### ###### ###### 
###### ###### ###### ###### ###### ###### ###### ###### ###### 
###### insertSQL syntax (tableName=>"tbl_blah",col1=>"",col2=>"");
###### ###### ###### ###### ###### ###### ###### ###### ###### 
###### ###### ###### ###### ###### ###### ###### ###### ###### 
sub insertSQL{
    my $this = shift;
    my %H_sql = @_;
    my $tableName = $H_sql{tableName};
    if(!defined($tableName)) {die "please define table name in insertSQL";}
    delete $H_sql{tableName}; # to make the rest of them only useful
    # $myUtil->prettyPrint(\%H_sql);

    my @columns = keys(%H_sql);
    my $columnList = join(",",@columns);
    # print "columnList is $columnList \n";
     my @values;
    foreach(@columns){	push(@values,$H_sql{$_}); }
    my $valueList;

    my $colnum = @values;
    foreach(@values){$valueList .=  " ? ,";}
    $valueList =~ s/,$//;
    my $sql = qq{INSERT INTO $tableName ($columnList) VALUES ($valueList)};
   #  print  STDERR "sql is <<$sql>> \n";
   # print  STDERR "values is <<@values>> \n";
    
    my $dbh = $this->{dbh};
    my $sth = $dbh->prepare($sql); 
    my $num_fields = $sth->{NUM_OF_FIELDS};
    my $enterData = $this->{enterData};
    my $store = "";
    eval{ 
	for (my $j=0;$j<$colnum;$j++)
	  { 
	    if($this->{debug} ==1) { 
	      if(!defined($values[$j])){
		# print  STDERR "<<$sql>> values <$store>\n";
	      } else { $store .= "<$j>"." <$values[$j]>";} 
	    } 
	    $sth->bind_param($j+1,$values[$j]);} 
	$sth->execute();
    }; if($@) {
	my $tmp = $DBI::errstr;
	$this->rollback();
	# print  STDERR "sql is <<$sql>> ERROR  is <$tmp> for values $store\n";
	return(0,"insertSQL ERROR:$tmp,\n <$sql>\n<$store>\n");
    }
    if($this->{commitEachStep} == 1){
      if($this->{enterData} ==1){ 
	$this->commit() ;
	return (1,"insertSQL committed ");
      } else { 
	$this->rollback();
	return (1,"insertSQL rolled back ");
      } 
    } 
    return (1,"insertSQL successful");
}

###### ###### ###### ###### ###### ###### ###### ###### ###### ###### 
###### initInsertSQL is used to create a statement handle,
###### it returns an integer
###### then multiInsertSQL is used to do the actual insert without 
###### preparing the handle each time, just give it the integer from
#####  initInsertSQL. 
###### Syntax for both is similar to 
######  insertSQL syntax (tableName=>"tbl_blah",col1=>"",col2=>"");
###### but use fillers for initInsertSQL

### USAGE:
#  my $index = $dbUtil->initInsertSQL(tableName=>"tbl_institute_info",
#		   institute_id=>$id,
#		   institute_code=>"blah",
#		   institution_name=>"blah institute");

### @res = $dbUtil->multiInsertSQL(index=>$index,
#				 tableName=>"tbl_institute_info",
#				 institute_id=>$id,
#				 institute_code=>"blah",
#				 institution_name=>"blah institute");
#
###### ###### ###### ###### ###### ###### ###### ###### ###### 
###### ###### ###### ###### ###### ###### ###### ###### ###### 
sub initInsertSQL{
    my $this = shift;
    my %H_sql = @_;
    my $tableName = $H_sql{tableName};
    if(!defined($tableName)) {die "please define table name in initinsertSQL";}
    delete $H_sql{tableName}; # to make the rest of them only useful
    # $myUtil->prettyPrint(\%H_sql);

    my @columns = keys(%H_sql);
    push(@colinsertList,\@columns);
    my $columnList = join(",",@columns);

   # print "initInsert columnList  for <$tableName> is <$columnList> \n";

    my @values;
    foreach(@columns){	push(@values,$H_sql{$_}); }
    my $valueList;

    my $colnum = @values;
    foreach(@values){$valueList .=  " ? ,";}
    $valueList =~ s/,$//;
    my $sql = qq{INSERT INTO $tableName ($columnList) VALUES ($valueList)};

    # print  STDERR "sql is <<$sql>> \n";
    # print  STDERR "values is <<@values>> \n";
    
    my $dbh = $this->{dbh};


    my $sth = $dbh->prepare($sql); 
    my $num_fields = $sth->{NUM_OF_FIELDS};
    
    my $ret = @sthinsertList;
    push(@sqlinsertList,$sql);
    push(@sthinsertList,$sth);
    return $ret;
}

######################################################################
############# multiInsertSQL
######################################################################
sub MultiInsertSQL{
    my $this = shift;
    my %H_sql = @_;


    my $index = $H_sql{index};
    delete $H_sql{index}; # to make the rest of them only useful
    if(!defined($index)) { 
      return(0," index not defined in multiInsertSQL");
    } elsif( $index > (@sthinsertList -1)){
      return(0," index <$index> not valid in  multiInsertSQL");
    }  
    my $tableName = $H_sql{tableName};
 # if(!defined($tableName)) {die "please define table name in multiinsertSQL";}
    delete $H_sql{tableName}; # to make the rest of them only useful
    my @columns = @{$colinsertList[$index]};
    my $columnList = join(",",@columns);

    # print "multiInsert columnList  for <$tableName> is <$columnList> \n";
    my @kys = keys %H_sql;
    my %kys = map{$_ => 1}@kys;
    my @values;
    foreach(@columns){
      if(!defined($kys{$_}))
	{
	  return(0,"multiinsertSQL $tableName ERROR:<column $_ not present in input>:");
	}
      push(@values,$H_sql{$_});
    }
    # $myUtil->prettyPrint(\%H_sql);
    # print "multiInsert columnList  for <$tableName> is <$columnList> \n";
    # print "values are <@values> \n";
    #  @values = reverse(@values);
    my $colnum = @values;
    my $dbh = $this->{dbh};
    my $sth = $sthinsertList[$index];
    my $enterData = $this->{enterData};
    my $store = "";
	for (my $j=0;$j<$colnum;$j++)
	  {
	    if($this->{debug} ==1) {
	      if(!defined($values[$j])){
		$store .= "<$j>"." <>";
		# print  STDERR "<<$sqlinsertList[$index]>> values <$store>\n";
	      } else {
		$store .= "<$j>"." <$values[$j]>";
	      }
	    }
	    $sth->bind_param($j+1,$values[$j]);}
    eval{$sth->execute();}; 
    if($@){
	my $tmp = $DBI::errstr;
	# $this->rollback();
	return(0,"multiinsertSQL $tableName ERROR:<$store>:$tmp");
      }
  ## do the commiting explicitly elsewhere, maybe batch processing is required
  ## etc.
    if($this->{commitEachStep} == 1){
      if($this->{enterData} ==1){
	$this->commit() ;
	return (1,"multiinsertSQL $tableName  committed ");
      } else {
	$this->rollback();
	return (1,"multiinsertSQL $tableName rolled back ");
      }
    }
    return (1,"multiinsertSQL successful");
}
1;
##########################################
