package Gramene::Util::StatM;

=head1 SYNOPSIS

Linux only - get memory usage info for this process from /proc/PID/statm

=over 4

=item current() 
a string with current values

=item change()
a string describing the change since the last call to current()
or change() or update()

=item %value
Keyword to value

=item update()
update %value

=back

Currently values are in pages.  Probably they should be in bytes.

=cut

use warnings; 
use strict;

use constant COLUMNS => [  qw(total rss shared text data/stack library dirty) ];

my %value;
my $statmfh;
my $pid;

sub current {
    update();
    return join(", ", map { "$_=".(defined $value{$_}?$value{$_}:'?') } 
                     @{&COLUMNS} );
}

sub change {
    my %last=%value or return current;
    update();
    return join(", ", map { "$_=".
                 (defined $last{$_}?(sprintf "%+d",$value{$_}-$last{$_}):'?') } 
		     grep { !defined($last{$_}) || $value{$_} != $last{$_} }
                     @{&COLUMNS} ) ;#|| "no change";
}

sub update {
    if ($statmfh and $pid != $$) {
	close $statmfh ;
	undef $statmfh;
    }
    unless ($statmfh) {
       open $statmfh,"/proc/$$/statm" or die "/proc/$$/statm: $!";
       $pid=$$;
    }
    seek $statmfh,0,0;
    my $line=<$statmfh>;
    #warn($line);
    @value{@{&COLUMNS}}=split /\s/,$line;
}


1;

=head2 AUTHOR

Steven Schmidt schmidt@cshl.edu
Gramene Project http://www.gramene.org
Stein Lab
Cold Spring Harbor Laboratory

This is free software and may be distributed on the same
terms as Perl itself.

=cut
