 #!/usr/local/bin/perl -w
 ###########
 #Add more comments in the code.
 #Add Error checking code in sendSmtp
 # always close sockets !!!!!!!!!!!!
 # check using netstat for possible problems.
 # If there is a space or two in the begining of the body, then 
 # the body seems to get concatenated with the subject line. 
 # is it a bug here or else where ? 
 #############



package Gramene::Util::Smtpclient;

use strict;
use sigtrap;
use Socket; 
$main::SIG{'INT'} = 'getOut';sub getOut { die "Smtpclient died "; exit}
my ($errCode,$errMessage) = (1,"All A-Okay");

my $def_mailServer = 'mailhost.cshl.org';
my $def_replyTo = 'SNP_SCRIPT@ROMANO.CSHL.ORG';

my ($packFormat)=('S n a4 x8');

my ($port,$serverAddr); 

sub new {
    my($name) = shift;
    my(%inlist) = @_;		
    my $this = \%inlist;
    bless $this,$name;
    if(!defined($this->{mailServer})){
	$this->{mailServer} = $def_mailServer;
    }
    if(!defined($this->{replyTo})){
	$this->{replyTo}= $def_replyTo;
    }
    # $main::SIG{'INT'} = 'SNP::Smtpclient::closeSocket';
    ($errCode,$errMessage) = $this->initSocket();
    return ($this,$errCode,$errMessage);	
}

sub initSocket { 
    my($this)=shift;	
    my $proto      = getprotobyname("tcp") || 6; 
    $port       = getservbyname("SMTP", "tcp") || 25;
    $serverAddr =(gethostbyname($this->{"mailServer"}))[4];
    if (!defined($serverAddr)) {
	return(0,"gethostbyname failed. for the host ".
	       $this->{"mailServer"});
    }
    socket(Smtpclient::SMTP,AF_INET(),SOCK_STREAM(),$proto)  || 
	return (0,"socket: $!");
    $packFormat = 'S n a4 x8';   # Windows 95, SunOs 4.1+
    #$Smtpclient::packFormat = 'S n c4 x8';   # SunOs 5.4+, (Solaris 2)
    connect(Smtpclient::SMTP,
	    pack($packFormat,AF_INET(),$port, $serverAddr))
	|| return (0, "Smtpclient::initSocket::connect:$!");

    select(Smtpclient::SMTP); 
    $| = 1;  # turn off buffering for sockets writes and reads.
    select (STDOUT); # so that the print statements work with STDOUT.

    my $inpBuf;
    #####      #####   the first message on contact
    ($errCode,$errMessage) = $this->recvSMTP(); 
    if($errCode ==0){
	return(0,$errMessage);
    }

    my $tmpServer = $this->{"mailServer"};
    $this->sendSMTP("HELO $tmpServer"); 
    return (1,"socket initialised ");
}

sub sendMail {
    my($this)=shift;
    my($mailToListRef,$body,$subject)=@_; 
          #references to list of recipients and body and actual subject
    
    my($inpBuf); 
    $this->sendSMTP("MAIL FROM: <$this->{replyTo}>"); 
    foreach  (@{$mailToListRef}){
	$this->sendSMTP("RCPT TO: <$_> ",0); 
    }
    $this->sendSMTP("DATA");
    my $tmp_rName = $this->{"replyTo"};
    my $totalbody = "From: $tmp_rName  \r\n"."Subject: $subject \r\n";
    $totalbody = $totalbody."$$body"."\r\n.";
    $this->sendSMTP($totalbody); 
    return (1,"success in sending message ");
}

sub closeSocket {     # close smtp socket on error
    send(Smtpclient::SMTP, "QUIT \r\n",0); 
    close(Smtpclient::SMTP);
#     die("SMTP socket closed due to SIGINT\n"); 
}  

sub sendSMTP {
    my($this) = shift;
    my($buffer) = @_;
    $buffer = $buffer."\r\n";
#    $this->closeSocket();
    send(Smtpclient::SMTP, $buffer, 0) 
  	    ||   return($errCode=0,"Failed to send message <$!>");
    ($errCode,$errMessage) = $this->recvSMTP();
    return ($errCode,$errMessage);
}

sub recvSMTP {
    my($this) = shift;
    my ($buffer);
    recv(Smtpclient::SMTP, $buffer, 200, 0);
    ###########
    #Add Error checking code here.
    #############
    $errMessage = $buffer;
    if((split(/ /, $buffer))[0] > 399) {
	$errCode =0;
    }
    return($errCode,$errMessage);
}

1;	
 	

