package Gramene::Test::Marker;

# $Id: Marker.pm,v 1.2 2007/06/06 19:24:46 kclark Exp $

=head1 NAME

Gramene::Test::Marker - a Gramene module

=head1 SYNOPSIS

  use Gramene::Test::Marker;

=head1 DESCRIPTION

Description of module goes here.

=head1 SEE ALSO

perl.

=head1 AUTHOR

Ken Youens-Clark E<lt>kclark@cshl.eduE<gt>.

=head1 COPYRIGHT

Copyright (c) 2007 Cold Spring Harbor Laboratory

This library is free software;  you can redistribute it and/or modify 
it under the same terms as Perl itself.

=cut

# ----------------------------------------------------

use strict;
use Gramene::DB;
use Gramene::CDBI::Markers;
use Readonly;

Readonly my $VERSION => sprintf "%d.%02d", q$Revision: 1.2 $ =~ /(\d+)\.(\d+)/;

use base qw( Gramene::Test );

sub test_foo {
    my $self = shift;
    my $db   = $self->db;
#    print "db = ", $self->{'db'}->{'Name'}, "\n";
#    print "foo = $self->{foo}\n";
    $self->assert_equals(1, 1, 'foo: 1 = 1');
}

sub test_bar {
    my $self = shift;
    my $db   = $self->db;
#    print "db = ", $self->{'db'}->{'Name'}, "\n";
#    print "foo = $self->{foo}\n";
    $self->assert_equals(2, 1, 'bar: 2 = 1');
}

sub db {
    my $self = shift;

    use Data::Dumper;
    print "db = ", Dumper($self->{'db'}), "\n";

    if ( !$self->{'db'} ) {
        $self->{'db'} = Gramene::DB->new('markers');
    }

    return $self->{'db'};
}

sub set_up {
    my $self = shift;
    my $db   = $self->db;

#    $self->{'foo'} = 'foo';
#    print STDERR "In ", __PACKAGE__, " set_up\n";
    

#
#    $db->do('set foreign_key_checks=0');
#
#    for my $table ( Gramene::CDBI::Markers::Marker->represented_tables ) {
#        $db->do("truncate table $table");
#    }
#
#    Gramene::CDBI::Markers::Species->create({
#        species_id => 1,
#        species    => 'UNKNOWN',
#    });
#
#    Gramene::CDBI::Markers::Germplasm->create({
#        species_id     => 1,
#        germplasm_name => 'UNKNOWN',
#    });
#
#    Gramene::CDBI::Markers::MarkerType->create({
#        marker_type_id => 1,
#        marker_type    => 'Undefined',
#    });
#
#    Gramene::CDBI::Markers::SynonymType->create({
#        synonym_type_id => 1,
#        synonym_type    => 'UNKNOWN',
#    });

    return 1;
}

1;
