package Gramene::Template;
use Basset::Template;
our @ISA = qw(Basset::Template);

use strict;
use warnings;

our @month_to_color	= qw(888888 DDDDDD EE9999 00DD00 FFAAAA FFFF00 00FF00 AAAAFF 00EE00 EEEE00 FF8000 996633 00BB00);
our @alt_month_to_color	= qw(888888 FFFFFF EEBBBB AADDAA FFCCCC FFFFCC CCFFCC CCCCFF BBEEBB EEEEBB FFC066 DA943C 66BB66);

__PACKAGE__->add_attr('comments');

__PACKAGE__->add_class_attr('default_bg_color');
__PACKAGE__->add_class_attr('alternate_bg_color');

__PACKAGE__->add_class_attr('default_sub_bg_color');
__PACKAGE__->add_class_attr('alternate_sub_bg_color');

__PACKAGE__->add_class_attr('default_new_link_bg_color');

__PACKAGE__->add_class_attr('user');
__PACKAGE__->add_class_attr('machine');
__PACKAGE__->add_class_attr('permanent_session');

__PACKAGE__->pipe_flags->{'blog'} = 'blog_processor';
__PACKAGE__->pipe_flags->{'translate'} = 'translate';
__PACKAGE__->pipe_flags->{'truncate'} = 'truncate';

__PACKAGE__->add_class_attr('document_root');

__PACKAGE__->add_class_attr('link_class_lookup',
	{
		'f'	=> 'Gramene::FAQ::FAQ',
	}
);



sub blog_processor {
	my $self = shift;
	my $value = shift;

	return '' unless defined $value;
	
	$self->comments({});
	
	#we ignore anything within {{ }}
	my $key_index = 0;
	$value =~ s/{{(.+?)}}/$self->comment_out($1, $key_index++)/gems;
	
	#normalize with unix line endings
	$value =~ s/\r\n?/\n/g;
	
	#unordered lists. Put first so it doesn't conflict with bold text ( *bold* )
	# starts with *

	$value =~ s!((?:^\*.+(?:\n|\z))+)!$self->unordered_list($1)!gem;

	#ordered lists starts with #
	$value =~ s!((?:^\#.+(?:\n|\z))+)!$self->ordered_list($1)!gem;
	
	#struck wrapped in -
	$value =~ s!\B-(\w[\w ]*\w?)-\B!<span style = 'text-decoration : line-through'>$1</span>!g;
	
	#bold wrapped in *
	$value =~ s!\B\*(\w[\w ]*\w?)\*\B!<span style = 'font-weight : bold'>$1</span>!g;
	
	#italic wrapped in ~
	$value =~ s!\B~(\w[^~]*)~\B!<span style = 'font-style : italic'>$1</span>!g;
	
	#underline wrapped in _
	$value =~ s!\b_(\w[\w ]*\w?)_\b!<span style = 'text-decoration : underline'>$1</span>!g;

	#add in links to additional content FLAG{id} or FLAG{id}[TITLE]
	$value =~ s!([mjplehifs]){(\w[^}]*)}(?:\[([^]]+)\])?!$self->template_link($1, $2, $3)!ge;
	
	#add in headers Set up with ^s
	$value =~ s!^(\^{1,6})(.+)$!"<h" . length($1) . ">" . $2 . "</h" . length($1) . ">"!gem;


	#add in paragraphs, as necessary
	$value =~ s!^([^<\s]\s*\S+.*)$!<p>$1</p>!gm;
	
	#replace what we had previously hidden
	$value =~ s/{{(.+?)}}/$self->comment_in($1)/gem;

	return $value;
}

sub comment_out {
	my $self = shift;
	my $value = shift;
	my $key_index = shift || 0;
	
	my $key = $self . $key_index;
	
	$self->comments->{$key} = $value;

	return "{{$key}}";
	
}

sub comment_in {
	my $self = shift;
	my $key = shift;
	
	return $self->comments->{$key};
}

sub template_link {

	my $self	= shift;
	my $tag		= shift;
	my $id		= shift;
	my $name	= shift;
	
	my $class = $self->link_class_lookup->{$tag};
	my $link;
	
	if ($tag eq 'l') {
		$link = $id;
		$name ||= $link;
	}
	elsif ($tag eq 'e') {
		$link = "mailto:$id";
		$name ||= $link;
	}
	elsif ($tag eq 'h') {
		if ($self->user->is_nobody) {
			return '';
		}
		else {
			return $id;
		}
	}
	elsif ($tag eq 's' && defined $class) {
	
		eval "use $class";
	
		my $obj = $class->load($id) or return $class->errstring;
		$link = $obj->web_path;
		my ($width, $height) = $obj->bounds;
		($width, $height) = split(/,/, $name) if $name;
		
		my $alt = $obj->webname;
		
		return "<img src = '$link' width = '$width' height = '$height' alt = '$alt'>";
		
	}	
	elsif (defined $class) {
		eval "use $class";
		
		my $obj = $class->load($id) or return $class->errstring;
		
		$name ||= $obj->webname;
	
		$link = $obj->weblink;
		$name ||= $obj->webname;
	}
	else {
		$self->error("No such class to link to for $tag", "XXX");
		return $self->error;
	}
	return '<a href = "' . $link . '" target = "_blank">' . $name . "</a>";
	
}


sub unordered_list {
	my $self	= shift;
	my $list	= shift;
	my $level	= shift || 1;

	$list =~ s!^(?:\*{$level})([^*].*)$!<li>$1</li>!gm;

	my $nextlevel = $level + 1;

	# versions of perl 5.8.x have problems with recursive regular expressions, so this 
	# nice tidy easy line doesn't work. So instead we do it the hard way and skip the
	# recursion on $1. Stupid bug.

	# $list =~ s!((?:^\*{$nextlevel}.+(?:\n|\z))+)!$self->unordered_list($1, $nextlevel)!gem;

	while ($list =~ m!((?:^\*{$nextlevel}.+(?:\n|\z))+)!) {
		my $sublist = $1;
		my $newsublist = $self->unordered_list($sublist, $nextlevel);
		$list =~ s!\Q$sublist\E!$newsublist!;
	}
	
	# XXX END BULLSHIT HACK

	return "<ul>$list</ul>";
}


sub ordered_list {
	my $self	= shift;
	my $list	= shift;
	my $level	= shift || 1;

	$list =~ s!^(?:#{$level})([^#].*)$!<li>$1</li>!gm;

	my $nextlevel = $level + 1;

	# versions of perl 5.8.x have problems with recursive regular expressions, so this 
	# nice tidy easy line doesn't work. So instead we do it the hard way and skip the
	# recursion on $1. Stupid bug.

	# $list =~ s!((?:^\*{$nextlevel}.+(?:\n|\z))+)!$self->unordered_list($1, $nextlevel)!gem;

	while ($list =~ m!((?:^#{$nextlevel}.+\n)+)!) {
		my $sublist = $1;
		my $newsublist = $self->unordered_list($sublist, $nextlevel);
		$list =~ s!\Q$sublist\E!$newsublist!;
	}
	
	# XXX END BULLSHIT HACK

	return "<ul>$list</ul>";
}

sub color_for_month {

	my $self = shift;
	my $month = @_ ? shift : (localtime)[4] + 1;
	my $alt = shift || 0;

	return '#' . ($alt ? $alt_month_to_color[$month] : $month_to_color[$month]);
}

sub is_selected {
	my $self = shift;
	my $one = shift or return '';
	my $two = shift or return '';
	my $str = shift || 0;
	
	return $str
		? $one eq $two ? 'selected = "selected"' : ''
		: $one == $two ? 'selected = "selected"' : '';
}

sub is_checked {
	my $self = shift;
	my $one = shift or return '';
	my $two = shift or return '';
	my $str = shift || 0;
	
	return $str 
		? $one eq $two ? 'checked = "checked"' : ''
		: $one == $two ? 'checked = "checked"' : '';
}

sub truncate {
	my $self = shift;
	my $text = shift;
	my $length = shift || length $text;

	$text =~ /^(.{0,$length}\w)\b/s;

	return $1 || $text;
	
}

sub iterator {
	my $self = shift;

	my @colors = @_ ? @_ : ($self->default_bg_color, $self->alternate_bg_color);
	@colors = ($self->default_sub_bg_color, $self->alternate_sub_bg_color) if @_ == 1 && $_[0] eq 'sub';
	my $idx = 0;

	return sub {
		my $color = $colors[$idx++];
		$idx = 0 if $idx > $#colors;
		return $color;
	}	
}

1;
