# -*- Mode: perl -*-

package Gramene::Search::SearchSubs;

#mostly `borrowed' from Ace-perl

use strict;
use lib '..';
use CGI qw(:standard *table *Tr *td);
use Gramene::Page;
use Gramene::Config;
use vars qw/@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS/;

require Exporter;
@ISA = 'Exporter';

@EXPORT = qw(
	     PrintTop PrintBottom PrintWarning PrintPrompt PrintObj
	     PrintOne PrintMultiple DataRow
	    );
@EXPORT_OK = qw(Search_Swish Display_Swish_Hits GrameneSearchTable GrameneError );

%EXPORT_TAGS = (swish => [qw(Search_Swish Display_Swish_Hits)]
	       );

my $page;

# boilerplate for the top of the page
sub PrintTop {
  my ($object,$class,$title,@additional_header_stuff) = @_;
  $class ||= $object->class if defined $object && ref($object);
  print header();
  $page = Gramene::Page->new(Apache->request) || GrameneError("Can't open Gramene page configurator");
  $title ||= defined($object) ? "$class Report for: $object" : $class ? "$class Report" : '';
  print start_html (
		    '-Title'   => $title,
		    '-Style'   => {-src => $page->stylesheet},
		    @additional_header_stuff,
		    );
  print $page->start_body;
  print TypeSelector($object,$class,1) if defined $object;
  print hr, br, h2({-class=>'heading'},$title) if $title;
}

# boilerplate for the bottom of the page
sub PrintBottom {
  print $page->end_body;
}

sub PrintWarning {
  my ($name,$class) = @_;
  print p(font({-color => 'red'},
	       "The $class named \"$name\" is not found in the database."));
}

sub PrintPrompt {

  my ($class, $example) = @_;
  print
    start_form(-method=>'GET'),
    p({-class=>'caption'},"Type in a ".$class." symbol, such as ",
      cite($example),':'),
    p("Symbol: ",
      textfield(-name=>'name')),
    end_form;
}

sub PrintObj {

  my $obj = shift;

  print TR(
	   th({-class=>'datatitle'},'Object Class'),
	   td({-class=>'databody'},$obj->class)
	   );
  print TR(
	   th({-class=>'datatitle'},'Object Name'),
	   td({-class=>'databody'},$obj->name)
	   );
}


sub PrintOne {
  my $label = shift;
  my $obj   = shift;
  return unless $obj;
  print TR(
	   th({-class=>'datatitle'},$label),
	   td({-class=>'databody'},$obj->isClass && $obj->class !~ /Text/ ? ObjectLink($obj) : $obj)
	  );
}
sub PrintMultiple {
  my $label = shift;
  my @a = @_;
  return unless @a;
  my $first = shift @a;
  print TR(
	   th({-class=>'datatitle'},$label),
	   td({-class=>'databody'},$first->isClass && $first->class !~ /Text/ ? ObjectLink($first) : $first)
	  );
  for my $obj (@a) {
    print TR(
	     th({-class=>'datatitle'},'&nbsp;'),
	     td({-class=>'databody'},$obj->isClass && $obj->class !~ /Text/ ? ObjectLink($obj) : $obj)
	    );
  }
}

# a line of the "summary table"
sub DataRow {
  my $title = shift;
  my @r = @_;
  if (@r) {
    my $first = shift @r;
    print TR(
	   th({-class=>'datatitle'},$title),
	   td({-class=>'databody'},$first->isObject ? ObjectLink($first) : $first)
	   );
    foreach (@r) {
      print TR(
	       th({-class=>'datatitle'},'&nbsp;'),
	       td({-class=>'databody'},$_->isObject ? ObjectLink($_) : $_)
	      );
    }
  } else {
      print TR(
	   th({-class=>'datatitle'},$title),
	   td({-class=>'databody'},'Not Available')
	   );
  }
}

sub Search_Swish {
  my $pattern = quotemeta shift;
  #warn("Search_Swish($pattern)\n");

  my $swconfig = Gramene::Config->new->get('swishe') 
      or warn("No swishe config") and return ;

  my $swish = $swconfig->{program};
  my $index = $swconfig->{index};
  my $strip = $swconfig->{strip};

  #warn "$swish,$index,$strip\n";

  my %hits;
  my $swish_cmd="$swish -v0 -w $pattern -f $index"; 
  #warn $swish_cmd;
  open (SWISH,"-|",,$swish_cmd)
      or warn("$swish_cmd:$!" ) and return;
  while (<SWISH>) {
    warn("swish-e:$_") if /^err:/;
    chomp;
    my ($relevance,$path,$url,$title,$size) = 
                      m!^(\d+) ($strip/?(/.+)) "([^\"]+)" (\d+)!o 
                  or  #warn "swish:?: $_\n" and  Every search produces some
                       # info lines starting with # and a . at the end
                   next;
    $hits{$path} = {relevance=>$relevance,url=>$url,title=>$title,size=>$size};
  }
  close SWISH or warn ("closing $swish_cmd:$!");
  #warn scalar(%hits)." swish hits";
  return unless %hits;  # return undef if no hits
  return \%hits;        # return hits, indexed by relevance
}

sub Display_Swish_Hits {
  my $hits = shift;
  my $highlight = shift;
  my $count = $hits  ? keys %$hits : 0;
  my $title = $count ? p(strong($count)," matches in Rice Genetic Newsletter &amp; Documentation")
    : p({-class=>'error'},'No matches in Rice Genetics Newsletter or Docs');

    print
      a({-name=>'static_results'},''),
	start_table({-border=>0,-cellspacing=>2,-cellpadding=>2,
		     -width=>'100%',-align=>'CENTER',-class=>'resultsbody'}),
		       TR(th({-class=>'resultstitle',-colspan=>2},$title));
  unless ($count) {
    print end_table,p();
    return;
  }

  print TR(th('Score'),th('Document'));
  for my $path (sort {$hits->{$b}{relevance} <=> $hits->{$a}{relevance}} keys %$hits) {
    my $abstract = get_swish_abstract($path,$highlight);
    #(my $url=$hits->{$path}{url}) =~ s,/newsletters/ricegenomenewslet/,http://rgp.dna.affrc.go.jp/rgp/ricegenomenewslet/, ;
    print TR({-valign=>'TOP'},
	     td($hits->{$path}{relevance}),
	     td(
		p(a({-href=>$hits->{$path}{url}},$hits->{$path}{title})),
		p($abstract)
	       ));
  }
  print end_table;

}

sub get_swish_abstract {
  my $path  = shift;
  my $terms = shift;


  # turn hilight into regex
  # extract phrases first
  my @terms = $terms =~ /"([^\"]+)"/g; #capture 'em
  $terms =~ s/"([^\"]+)"//;            #get rid of 'em
  push @terms,split /\s+/,$terms;      #rest split by whitespace
  @terms = map {quotemeta $_} @terms;  #get rid of metachars
  my $regex = join '|',@terms;         #whole thing becomes a regex

  my $abstract;
  open (F,$path) or return;
  local $/ = ""; # paragraph mode
  while (<F>) {
    chomp;
    s/<[^>]+>//g;  #fast but flawed way of eliminating HTML
    next unless /\b(.{0,50})($regex)(.{0,50})\b/;
    $abstract .= "$1<em>$2</em>$3...";
  }
  close F;
  $abstract;
}


=item GrameneSearchTable([{hash}],$title,@contents)

Given a title and the HTML contents, this formats the search into a
table and gives it the background and foreground colors used elsewhere
for searches.  The formatted search is then printed.

The HTML contents are usually a fill-out form.  For convenience, you
can provide the contents in multiple parts (lines or elements) and
they will be concatenated together.

If the first argument is a hashref, then its contents will be passed
to start_form() to override the form arguments.

=cut

sub GrameneSearchTable {
  my %attributes = %{shift()} if ref($_[0]) eq 'HASH';
  my ($title,@body) = @_;
  print
    start_form(-action=>url(-absolute=>1,-path_info=>1).'#results',%attributes),
    a({-name=>'search'},''),
    table({-border=>0,-width=>'100%'},
	  TR({-valign=>'MIDDLE'},
	     td({-class=>'searchbody'},@body))),
    end_form;
}


=item GrameneError($message)

This subroutine will print out an error message and exit the script.
The text of the message is taken from $message.

=cut

sub GrameneError {
    my $msg = shift;
    PrintTop(undef,undef,'Error');
    print CGI::font({-color=>'red'},$msg);
    PrintBottom();
    Apache->exit(0) if defined &Apache::exit;
    exit(0);
}




1;
