package Gramene::Protein::GetProteinData;

#A perl module for the protein page.                  -----Wei Zhao(10/17/01)

use strict;
use DBI;
use Gramene::DB;

sub new {
    my $invocant = shift;
    my $class    = ref($invocant) || $invocant;

    my $self = {};
    bless( $self, $class );
    return $self;

}

sub terminate_database {
    my $self = shift;
}

sub connect_to_ora {
    my $self = shift;
    eval {
        $self->{'db'}    = Gramene::DB->new('protein');
        $self->{'onto_db'}    = Gramene::DB->new('ontology');
        $self->{'liter_db'}    = Gramene::DB->new('literature');
        $self->{'gene_db'} = Gramene::DB->new('genes');
    };
    if ($@) {
        die "DB connection failed: $@\n";
    }

}

####################################

sub get_detail {
    my $self  = $_[0];
    my $id    = $_[1];
    my $sth11 = $self->{'db'}->prepare(
	"SELECT gene_product_symbol, 
		gene_product_full_name, 
		gene_product_description 
	FROM gene_product
	WHERE gene_product_id = ?"
    );
    $sth11->bind_param( 1, $id );
    $sth11->execute();
    my ( $symbol, $name, $des ) = $sth11->fetchrow_array;
    $sth11->finish;
    return ( $symbol, $name, $des );

}

sub get_associations {
    my $self  = $_[0];
    my $id    = $_[1];
    my @ordered_term_types=(
	'Molecular Function',
	'Biological Process',
	'Cellular Component',
	'Plant Structure',
	'Plant Growth and Development Stage',
	'Cereal Plant Growth Stage',
	'Trait',
	'Enviroment'
    );
    my %all_term_types = map { $_ => [] } @ordered_term_types;

    my $sth13 = $self->{'db'}->prepare(
        "SELECT association_id, term_accession, term_type  
	 FROM association
	 WHERE gene_product_id = ?
	 "
    );
    $sth13->bind_param( 1, $id );
    $sth13->execute();
    my ( $asso,  $term,  $term_type,  $term_name );
    while ( ( $asso, $term,$term_type ) = $sth13->fetchrow_array ) {
	my $ref = $all_term_types{$term_type};
	push @{$ref->[0]},$asso;
	push @{$ref->[1]},$term;
	push @{$ref->[2]},$term_type;
    }
    my (@assos, @terms, @term_types, @term_names);

    # sort the result by perfered term types
    foreach my $term_type (@ordered_term_types){
	my $ref = $all_term_types{$term_type};
	if($ref && scalar(@$ref)>0){
	    push @assos, @{$ref->[0]};
	    push @terms, @{$ref->[1]};
	    push @term_types, @{$ref->[2]};
	}
    }


    foreach my $t (@terms) {
        ################
        my $sth41 = $self->{'onto_db'}->prepare(
            "SELECT term_name  FROM term
	     WHERE term_accession = ?"
        );
        $sth41->bind_param( 1, $t );
        $sth41->execute();
        ( $term_name ) = $sth41->fetchrow_array;

        @term_names = ( @term_names, $term_name );
        $sth41->finish;
    }
    $sth13->finish;
    return ( \@assos, \@term_names, \@term_types, \@terms );

}

##################

sub get_evidences {
    my $self    = $_[0];
    my $asso_id = $_[1];

    my $sth45 = $self->{'db'}->prepare(
        "SELECT dbxref_id, evidence_code        
                                FROM evidence
                                WHERE association_id = ?"
    );

    $sth45->bind_param( 1, $asso_id );
    $sth45->execute();
    my ( $x_id, @x_ids, $code, @codes, $key, @keys, $db_name, @db_names );
    my $sth46 = $self->{'db'}->prepare(
        "SELECT xref_key, xref_dbname        
                                FROM dbxref
                                WHERE dbxref_id = ?"
    );
    while ( ( $x_id, $code ) = $sth45->fetchrow_array ) {
        $sth46->bind_param( 1, $x_id );
        $sth46->execute();
        ( $key, $db_name ) = $sth46->fetchrow_array;
        @keys     = ( @keys,     $key );
        @db_names = ( @db_names, $db_name );
        @codes    = ( @codes,    $code );

    }
    $sth45->finish;
    $sth46->finish;
    return ( \@keys, \@db_names, \@codes );

}
###################

###################

sub get_ref {
    my $self   = $_[0];
    my $ref_id = $_[1];

    my (
        $x_key,  $dbname,     $title,    $s_id, $year,
        $volume, $start_page, $end_page, $source
    );

    my $sth16 = $self->{'liter_db'}->prepare(
"SELECT reference_id, title, source_id, year, volume, start_page, end_page
                                FROM reference
                                WHERE reference_id = ?"
    );

    $sth16->bind_param( 1, $ref_id );
    $sth16->execute();
    ( $x_key, $title, $s_id, $year, $volume, $start_page, $end_page ) =
      $sth16->fetchrow_array();
    my $sth42 = $self->{'liter_db'}->prepare(
        "SELECT source_name
                                FROM source
                                WHERE source_id = ?"
    );
    $sth42->bind_param( 1, $s_id );
    $sth42->execute();
    $source = $sth42->fetchrow_array;
    $sth16->finish;
    $sth42->finish;
    return ( $x_key, $title, $source, $year, $volume, $start_page, $end_page );

}

sub get_origin {
    my $self  = $_[0];
    my $p_id  = $_[1];
    my $sth17 = $self->{'db'}->prepare(
        "SELECT cultivar_id
                                FROM gene_product_to_cultivar
                                WHERE gene_product_id = ?"
    );
    $sth17->bind_param( 1, $p_id );
    $sth17->execute();
    my $cul_id = $sth17->fetchrow_array();
    my $sth18  = $self->{'db'}->prepare(
        "SELECT subspecies_id, species_id, cultivar_name
                                    FROM cultivar
                                    WHERE cultivar_id = ?"
    );
    my ( $sub_id, $spe_id, $cul_name, $sub_name, $spe_name );
    if ($cul_id) {

        $sth18->bind_param( 1, $cul_id );
        $sth18->execute();
        ( $sub_id, $spe_id, $cul_name ) = $sth18->fetchrow_array();

        my $sth19 = $self->{'db'}->prepare(
            "SELECT subspecies_name
                                    FROM subspecies
                                    WHERE subspecies_id = ?"
        );
        $sth19->bind_param( 1, $sub_id );
        $sth19->execute();
        $sub_name = $sth19->fetchrow_array();

        my $sth20 = $self->{'db'}->prepare(
            "SELECT species_name
                                    FROM species
                                    WHERE species_id = ?"
        );
        $sth20->bind_param( 1, $spe_id );
        $sth20->execute();
        $spe_name = $sth20->fetchrow_array();
        $sth19->finish;
        $sth20->finish;
    }
    else {

        my $sth21 = $self->{'db'}->prepare(
            "SELECT subspecies_id
                                    FROM gene_product_to_subspecies
                                    WHERE gene_product_id = ?"
        );
        $sth21->bind_param( 1, $p_id );
        $sth21->execute();
        $sub_id = $sth21->fetchrow_array();
        $sth21->finish;

        if ($sub_id) {

            my $sth19 = $self->{'db'}->prepare(
                "SELECT subspecies_name, species_id 
                                    FROM subspecies
                                    WHERE subspecies_id = ?"
            );
            $sth19->bind_param( 1, $sub_id );
            $sth19->execute();
            ( $sub_name, $spe_id ) = $sth19->fetchrow_array();

            my $sth20 = $self->{'db'}->prepare(
                "SELECT species_name
                                    FROM species
                                    WHERE species_id = ?"
            );
            $sth20->bind_param( 1, $spe_id );
            $sth20->execute();
            $spe_name = $sth20->fetchrow_array();
            $sth19->finish;
            $sth20->finish;

        }
        else {

            my $sth22 = $self->{'db'}->prepare(
                "SELECT species_id
                                        FROM gene_product_to_species
                                        WHERE gene_product_id = ?"
            );
            $sth22->bind_param( 1, $p_id );
            $sth22->execute();
            $spe_id = $sth22->fetchrow_array();
            $sth22->finish;

            if ($spe_id) {

                my $sth20 = $self->{'db'}->prepare(
                    "SELECT species_name
                                    FROM species
                                    WHERE species_id = ?"
                );
                $sth20->bind_param( 1, $spe_id );
                $sth20->execute();
                $spe_name = $sth20->fetchrow_array();
                $sth20->finish;

            }

        }    #End else
    }    #End else
    $sth17->finish;
    $sth18->finish;
    return ( $spe_name, $sub_name, $cul_name );

}

sub get_expression {
    my $self  = $_[0];
    my $p_id  = $_[1];
    my $sth24 = $self->{'db'}->prepare(
        "SELECT expression_annotation
                                FROM expression
                                WHERE gene_product_id = ?"
    );
    $sth24->bind_param( 1, $p_id );
    $sth24->execute();
    my $exp = $sth24->fetchrow_array();
    $sth24->finish;
    return $exp;

}

sub get_synonyms {
    my $self = $_[0];
    my $p_id = $_[1];

    my $sth2 = $self->{'db'}->prepare(
        "SELECT gene_product_synonym_symbol
                               FROM gene_product_synonym
                               WHERE gene_product_id = ?"
    );
    $sth2->bind_param( 1, $p_id );
    $sth2->execute();
    my ( $syn, $syns );
    while ( $syn = $sth2->fetchrow_array() ) {

        if ( ( $syn =~ /\)/ ) && ( !( $syn =~ /\(/ ) ) ) {
            $syn =~ s/\)//;
        }
        unless ( $syn eq "FRAGMENT" ) {
            if ($syns) {
                $syns = $syns . ", " . $syn;
            }
            else {
                $syns = $syn;
            }
        }
    }

    $syns = 'Not available' unless $syns;

    $sth2->finish;

    return $syns;

}

sub get_xref {
    my $self  = $_[0];
    my $p_id  = $_[1];
    my $sth26 = $self->{'db'}->prepare(
        "SELECT xref_dbname, xref_key
                                FROM dbxref
                                WHERE dbxref_id =
                                      (SELECT organism_dbxref_id
                                       FROM gene_product
                                       WHERE gene_product_id = ?)"
    );
    $sth26->bind_param( 1, $p_id );
    $sth26->execute();
    my ( $dbname, $key, @dbnames, @keys );
    while ( ( $dbname, $key ) = $sth26->fetchrow_array() ) {
        @dbnames = ( @dbnames, $dbname );
        ############
        $key =~ s/ORYZA/ORYSA/;
        ############
        @keys = ( @keys, $key );

    }
    $sth26->finish;
    return ( \@dbnames, \@keys );

}

##############
sub get_acc {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "select swissprot_acc from gene_product_helper
                               where gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $acc = $sth1->fetchrow_array();
    $sth1->finish;
    return $acc;

}

sub get_symbol {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT gene_product_symbol
                               FROM gene_product
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $symbol = $sth1->fetchrow_array();
    if ( $symbol eq "not available" ) {
        $symbol = "Not available";
    }
    $sth1->finish;
    return $symbol;

}

sub get_name {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT gene_product_full_name
                               FROM gene_product
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $name = $sth1->fetchrow_array();

    # comment out the synonyms for listing synonyms separtely
    # my $sth2 = $self->{'db'}->prepare( "SELECT gene_product_synonym_symbol
    #                            FROM gene_product_synonym
    #                            WHERE gene_product_id = ?" );
    # $sth2->bind_param( 1, $p_id );
    # $sth2->execute();
    # my $syn;
    # while( $syn = $sth2->fetchrow_array() ) {

    #   if( ( $syn =~ /\)/ ) && ( ! ( $syn =~ /\(/ ) ) ) {
    #	  $syn =~ s/\)//;
    #   }
    #   unless( $syn eq "FRAGMENT" ) {
    #     if( $name ) {
    #         $name = $name.", ".$syn;
    #	} else {
    #	    $name = $syn;
    #	}
    #   }
    # }

    $sth1->finish;

    # $sth2->finish;

    return $name;

}

sub get_ecs {
    my $self = $_[0];
    my $p_id = $_[1];
    
    my $xref_dbname = 'ENZYME';
    my $xref_keytype = 'EC';
    my @ecs = get_xrefs($self,$p_id, $xref_dbname, $xref_keytype);
    my $ecs = 'Not available';
    if(@ecs){
	$ecs = join(", ", @ecs);
    }
    return $ecs;

}

sub get_gns {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT gene_name
                               FROM gene_product_gene_name
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( $gns, $gn );
    while ( $gn = $sth1->fetchrow_array() ) {
        if ($gns) {
            $gns = $gns . ", " . $gn;
        }
        else {
            $gns = $gn;
        }
    }
    $sth1->finish;
    unless ($gns) {
        $gns = "Not available";
    }
    return $gns;

}

sub get_phenotypes {
    my $self = $_[0];
    my $p_id = $_[1];

    my $xref_dbname = 'gramene.gene';
    my $xref_keytype = 'acc';

    my @gp_mus = get_xrefs($self,$p_id,$xref_dbname, $xref_keytype);
    my @mus;

    my $sth_mu = $self->{'gene_db'}->prepare(
        " SELECT symbol,name 
	 FROM  gene_gene WHERE accession = ? "
    );

    foreach  my $mu_acc (@gp_mus) {
        my $mu_id = $mu_acc;
        $sth_mu->execute( ($mu_id) );
        my ( $symbol, $name ) = $sth_mu->fetchrow_array;

        push( @mus, [ $mu_acc, $symbol, $name ] );

    }

    $sth_mu->finish;
    return @mus;
}

sub get_organisms {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT cultivar_id
                               FROM gene_product_to_cultivar
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ($cul_id) = $sth1->fetchrow_array;
    my $sth2 = $self->{'db'}->prepare(
        "SELECT genus, species, ncbi_taxa_id, cultivar_name  
                               FROM species, cultivar
                               WHERE cultivar_id = ?                              
                               AND species.species_id = cultivar.species_id"
    );
    $sth2->bind_param( 1, $cul_id );
    $sth2->execute();
    my ( $genus, $spe, $taxa_id, $cul ) = $sth2->fetchrow_array;

    $sth1->finish;
    $sth2->finish;

    return ( $genus, $spe, $taxa_id, $cul );

}

sub get_exp {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT expression_annotation
                               FROM expression
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $exp = $sth1->fetchrow_array();
    unless ($exp) {
        $exp = "Not available";
    }
    $sth1->finish;
    return $exp;

}

sub get_tissue {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT tissue
                               FROM gene_product_tissue
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $tissue = $sth1->fetchrow_array();
    unless ($tissue) {
        $tissue = "Not available";
    }
    $sth1->finish;
    return $tissue;

}

sub get_organelle {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT organelle
                               FROM gene_product_organelle
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $tissue = $sth1->fetchrow_array();
    unless ($tissue) {
        $tissue = "Not available";
    }
    $sth1->finish;
    return $tissue;

}

sub get_keywords {
    my $self = $_[0];
    my $p_id = $_[1];

    my $sth1 = $self->{'db'}->prepare(
        "SELECT KW.keyword
                               FROM   keyword KW, gene_product_to_keyword GPKW
                               WHERE  KW.keyword_id =GPKW.keyword_id
                                AND   gene_product_id = ?
                              "
    );

    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( $gns, $gn );
    while ( $gn = $sth1->fetchrow_array() ) {

        #$gns = $gns.", ".$gn;
        if ($gns) {
            $gns = $gns . ", " . $gn;
        }
        else {
            $gns = $gn;
        }
    }
    $sth1->finish;
    unless ($gns) {
        $gns = "Not available";
    }
    return $gns;

}

#liya:  only show public comment, hide curator comment
sub get_comment {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT public_comment
                               FROM gene_product_comment
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $comment = $sth1->fetchrow_array();
    $sth1->finish;
    return $comment;

}

sub get_swall {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "select swissprot_id from gene_product_helper
                               where gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my $acc = $sth1->fetchrow_array();
    $sth1->finish;
    return $acc;

}

sub get_protein {
    my $self            = $_[0];
    my $word            = $_[1];
    my $wild_card       = $_[2];
    my $complete_result = $_[3];


    my %uniq_ids;

    my $new_word = "%" . $word . "%";
    if ( $wild_card && $wild_card eq "ON" ) {
        $word     = "%" . $word . "%";
    }

    my $sth1     = $self->{'db'}->prepare(
    "select GH.gene_product_id, swissprot_acc, swissprot_id, gene_product_name, organism, evidence_codes 
		from gene_product_helper GH
		left join gene_product_to_gi_number GI
		on   GH.gene_product_id = GI.gene_product_id
		left join gene_product_to_pid GP
		on   GH.gene_product_id = GP.gene_product_id
		where UPPER(gene_product_name) like ?
			or UPPER(gene_product_gene_name) like ?
			or UPPER(swissprot_acc) like ?
			or UPPER(swissprot_id) like ?
			or UPPER(organism) like ?
			or UPPER(gi_number) like ?
			or UPPER(pid) like ?
		order by organism,gene_product_name,swissprot_acc,iea_codes"
        );

    $sth1->bind_param( 1, $new_word );
    $sth1->bind_param( 2, $new_word );
    $sth1->bind_param( 3, $word );
    $sth1->bind_param( 4, $word );
    $sth1->bind_param( 5, $new_word );
    $sth1->bind_param( 6, $word );
    $sth1->bind_param( 7, $word );

    $sth1->execute();

    my ( @ids, @names, @accs, @sids, @orgas, @codes );
    my ( $id,  $acc,   $sid,  $name, $orga,  $code );
    my $nothing     = "";
    my $part_result = 0;


    while ( ( $id, $acc, $sid, $name, $orga, $code ) =
    $sth1->fetchrow_array())  {
	unless(exists $uniq_ids{$id}){
	    if ( $complete_result eq "1"  || scalar(@ids) < 500) {
		@ids = ( @ids, $id );

		substr( $name, -1, 2 ) = $nothing;
		@names = ( @names, $name );
		@accs  = ( @accs,  $acc );
		@sids  = ( @sids,  $sid );

		substr( $orga, -1, 2 ) = $nothing;
		@orgas = ( @orgas, $orga );
		@codes = ( @codes, $code );

		$uniq_ids{$id} = 1;
	    }else{
		$part_result = 1;
	    }
        }

    }
    $sth1->finish;

    return ( \@ids, \@accs, \@sids, \@names, \@orgas, \@codes, $part_result );

}

###############################

sub get_protein_old {
    my $self = $_[0];
    my $word = $_[1];

    my $sth1 = $self->{'db'}->prepare(
        "select * from gene_product_extra
                               where UPPER(gene_product_name) like ?
                               or UPPER(swissprot_acc) like ?
                               or UPPER(swissprot_id) like ?"
    );

    $sth1->bind_param( 1, $word );
    $sth1->bind_param( 2, $word );
    $sth1->bind_param( 3, $word );

    $sth1->execute();
    my ( @ids, @names, @accs, @sids );
    my ( $id,  $name,  $acc,  $sid );
    while ( ( $id, $name, $acc, $sid ) = $sth1->fetchrow_array() ) {

        my $unique = 1;
        my $i      = 0;
        while ( ($unique) && ( $i <= $#ids ) ) {
            if ( $id == $ids[$i] ) {
                $unique = 0;
            }
            $i++;
        }
        if ($unique) {
            if ( ( $name =~ /\)/ ) && ( !( $name =~ /\(/ ) ) ) {
                $name =~ s/\)//;
            }
            @ids   = ( @ids,   $id );
            @names = ( @names, $name );

            @accs = ( @accs, $acc );

            @sids = ( @sids, $sid );

        }

    }
    $sth1->finish;

    return ( \@ids, \@names, \@accs, \@sids );

}

###############

sub get_embl_accessions {
    my $self = $_[0];
    my $p_id = $_[1];
    return ();
    my $sth1 = $self->{'db'}->prepare(
        "SELECT embl_accession
                               FROM gene_product_to_embl_accession
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( @embl_accessions, $embl_accession );
    while ( $embl_accession = $sth1->fetchrow_array ) {
        @embl_accessions = ( @embl_accessions, $embl_accession );
    }
    $sth1->finish;
    return @embl_accessions;

}

sub get_gis {
    my $self = $_[0];
    my $p_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT gi_number
                               FROM gene_product_to_gi_number
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( @gis, $gi );
    while ( $gi = $sth1->fetchrow_array ) {
        @gis = ( @gis, $gi );
    }
    $sth1->finish;
    return @gis;

}

sub get_pids {
    my $self = $_[0];
    my $id   = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT pid
                               FROM gene_product_to_pid
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $id );
    $sth1->execute();
    my ( @pids, $pid );
    while ( $pid = $sth1->fetchrow_array ) {
        @pids = ( @pids, $pid );
    }
    $sth1->finish;
    return @pids;

}

sub get_sequence {
    my ( $self, $gp_id ) = @_;
    my $sth = $self->{'db'}->prepare(
        q[
		SELECT seq
		FROM   gene_product_seq GPS, seq
		WHERE  GPS.seq_id = seq.id
		AND    gene_product_id = ?
	    ]
    );
    $sth->execute( ($gp_id) );
    my ($seq) = $sth->fetchrow_array();
    $seq =~ s/^\s+|\s+$//g if $seq;

    $sth->finish;
    return $seq;
}

sub get_pfam {
    my $self = $_[0];
    my $p_id = $_[1];

    my $sth1 = $self->{'db'}->prepare(
        "SELECT xref_key, xref_desc
                               FROM   dbxref DBX,objectxref OBX
                               WHERE  DBX.dbxref_id = OBX.dbxref_id 
                                 AND  xref_keytype = 'ACC'
                                 AND  xref_dbname = 'Pfam'
                                 AND  row_id = ?
                                 AND  table_name = 'gramene.protein'
                              "
    );

    $sth1->bind_param( 1, $p_id );
    $sth1->execute();
    my ( @pfams, @extras );
    while ( my ( $pfam, $extra ) = $sth1->fetchrow_array() ) {
        @pfams  = ( @pfams,  $pfam );
        @extras = ( @extras, $extra );
    }

    $sth1->finish;
    return ( \@pfams, \@extras );

}

sub get_prosite {
    my $self = $_[0];
    my $p_id = $_[1];

# You don't want to display those entries with something like "(355 residues" in the PROSITE_SEQUENCE field.
    my $sth1 = $self->{'db'}->prepare(
        "SELECT prosite_id, prosite_desc, prosite_sequence
                               FROM gene_product_prosite
                               WHERE ( gene_product_id = ? and prosite_sequence not like '%residues%' )
                               OR ( gene_product_id = ? and prosite_sequence is NULL )
                               order by prosite_id"
    );
    $sth1->bind_param( 1, $p_id );
    $sth1->bind_param( 2, $p_id );
    $sth1->execute();
    my ( @keys, @descs, @sequences );
    while ( my ( $key, $desc, $sequence ) = $sth1->fetchrow_array ) {
        @keys      = ( @keys,      $key );
        @descs     = ( @descs,     $desc );
        @sequences = ( @sequences, $sequence );
    }

    $sth1->finish;
    return ( \@keys, \@descs, \@sequences );

}

sub get_term_type {
    my $self = $_[0];
    my $t_id = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "SELECT term_type
                               FROM term
                               WHERE term_id = ?"
    );
    $sth1->bind_param( 1, $t_id );
    $sth1->execute();
    my $type = $sth1->fetchrow_array();

    $sth1->finish;
    return $type;

}

sub get_id_by_swall {
    my $self     = $_[0];
    my $swall_id = $_[1];

    my $sth1 = $self->{'db'}->prepare(
        "select gene_product_id from gene_product_helper
                               where UPPER(swissprot_id) = ?"
    );

    $sth1->bind_param( 1, $swall_id );
    $sth1->execute();
    my $id = $sth1->fetchrow_array();
    $sth1->finish;
    return $id;

}

sub get_trembl_new {
    my $self  = $_[0];
    my $gp_id = $_[1];
    my $sth1  = $self->{'db'}->prepare(
        "SELECT gene_product_id
                               FROM gene_product_trembl_new
                               WHERE gene_product_id = ?"
    );
    $sth1->bind_param( 1, $gp_id );
    $sth1->execute();
    my $trembl_new;
    if ( $sth1->fetchrow_array() ) {
        $trembl_new = 1;
    }
    else {
        $trembl_new = 0;
    }

    $sth1->finish;
    return $trembl_new;

}

sub db {
    my $self = $_[0];
    return $self->{'db'};
}

###################

sub get_id_by_acc {
    my $self = $_[0];
    my $acc  = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "select gene_product_id from gene_product_helper
                               where UPPER(swissprot_acc) = ?"
    );

    $sth1->bind_param( 1, $acc );
    $sth1->execute();
    my $p_id = $sth1->fetchrow_array();
    $sth1->finish;
    return $p_id;

}

sub validate_id {
    my $self = $_[0];
    my $id   = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "select gene_product_id from gene_product_helper
                               where gene_product_id = ?"
    );

    $sth1->bind_param( 1, $id );
    $sth1->execute();
    my $p_id = $sth1->fetchrow_array();
    $sth1->finish;
    return $p_id;

}

##############################

sub get_ref_ids {
    my $self = $_[0];
    my $id   = $_[1];

    my $xref_dbname = 'gramene.literature';
    my $xref_keytype = 'id';

    return get_xrefs($self, $id, $xref_dbname, $xref_keytype);

}

sub get_ref_detail {
    my $self   = $_[0];
    my $ref_id = $_[1];

    my ( $title, $s_id, $year, $volume, $start_page, $end_page );

    my $sth16 = $self->{'liter_db'}->prepare(
        "SELECT title, source_id, year, volume, start_page, end_page
                                FROM reference
                                WHERE reference_id = ?"
    );

    $sth16->bind_param( 1, $ref_id );
    $sth16->execute();
    ( $title, $s_id, $year, $volume, $start_page, $end_page ) =
      $sth16->fetchrow_array();
    $sth16->finish;

    my $sth42 = $self->{'liter_db'}->prepare(
        "SELECT source_name
                                FROM source
                                WHERE source_id = ?"
    );
    $sth42->bind_param( 1, $s_id );
    $sth42->execute();
    my $source = $sth42->fetchrow_array;
    $sth42->finish;

    my $sth1 = $self->{'liter_db'}->prepare(
        "SELECT author
                               FROM reference_extra
                               WHERE reference_id = ?"
    );
    $sth1->bind_param( 1, $ref_id );
    $sth1->execute();
    my $author = $sth1->fetchrow_array;
    $sth1->finish;

    return ( $title, $source, $year, $volume, $start_page, $end_page, $author );

}

#################################################

sub get_protein_complete {
    my $self      = $_[0];
    my $word      = $_[1];
    my $wild_card = $_[2];

    my $new_word;
    my $sth1;

    if ( $wild_card eq "ON" ) {
        $new_word = "%" . $word . "%";
        $word     = "%" . $word . "%";
        $sth1     = $self->{'db'}->prepare(
            "select gene_product_id, swissprot_acc
                                from gene_product_helper
                                where UPPER(gene_product_name) like ?
                                or UPPER(gene_product_gene_name) like ?
                                or UPPER(swissprot_acc) like ?
                                or UPPER(swissprot_id) like ?
                                or UPPER(organism) like ?
                                order by non_iea_codes DESC, iea_codes DESC, organism_rank"
        );
    }
    else {
        $new_word = "% " . $word . " %";
        $sth1     = $self->{'db'}->prepare(
            "select gene_product_id, swissprot_acc 
                                from gene_product_helper
                                where UPPER(gene_product_name) like ?
                                or UPPER(gene_product_gene_name) like ?
                                or UPPER(swissprot_acc) = ?
                                or UPPER(swissprot_id) = ?
                                or UPPER(organism) like ?
                                order by non_iea_codes DESC, iea_codes DESC, organism_rank"
        );
    }

    $sth1->bind_param( 1, $new_word );
    $sth1->bind_param( 2, $new_word );
    $sth1->bind_param( 3, $word );
    $sth1->bind_param( 4, $word );
    $sth1->bind_param( 5, $new_word );

    $sth1->execute();

    my ( @ids, @accs );
    my ( $id,  $acc );
    my %uniq_ids;

    while ( ( $id, $acc ) = $sth1->fetchrow_array() ) {

        @ids  = ( @ids,  $id );
        @accs = ( @accs, $acc );
        $uniq_ids{$id} = 1;
    }

    $sth1->finish;

    my $new_word2 = $word;    #$word modified based on wild card on

    my $sth2 = $self->{'db'}->prepare(
        "select GENE_PRODUCT_ID from gene_product_to_gi_number 
                            where gi_number like ?"
    );

    my $sth3 = $self->{'db'}->prepare(
        "select GENE_PRODUCT_ID from gene_product_to_pid 
                            where pid like ?"
    );

    $sth2->bind_param( 1, $new_word2 );
    $sth2->execute;

    $sth3->bind_param( 1, $new_word2 );
    $sth3->execute;

    my %new_ids;
    while ( my ($id) = $sth2->fetchrow_array ) {
        $new_ids{$id} = 1 unless $uniq_ids{$id};

    }

    while ( my ($id) = $sth3->fetchrow_array ) {
        $new_ids{$id} = 1 unless $uniq_ids{$id};
    }

    my $sth4 = $self->{'db'}->prepare(
        "select gene_product_id, swissprot_acc
                            from gene_product_helper where gene_product_id=?
                            order by non_iea_codes DESC, iea_codes DESC, organism_rank"
    );

    foreach my $id ( keys %new_ids ) {
        $sth4->bind_param( 1, $id );
        $sth4->execute;
        ( $id, $acc ) = $sth4->fetchrow_array();
        @ids = ( @ids, $id );

        @accs = ( @accs, $acc );

    }

    $sth2->finish;
    $sth3->finish;
    $sth4->finish;

    return ( \@ids, \@accs );

}

###################

sub get_all_refs {
    my $self  = $_[0];
    my $gp_id = $_[1];
    my $sth1  = $self->{'db'}->prepare(
        "select gene_product_name
                               from gene_product_helper
                               where gene_product_id = ?"
    );
    $sth1->bind_param( 1, $gp_id );
    $sth1->execute();
    my $gp_name = $sth1->fetchrow_array();
    substr( $gp_name, 0,  1 ) = "";
    substr( $gp_name, -1, 2 ) = "";
    my @names = split( /   /, $gp_name );

    my $query = "select reference_id 
                 from reference_extra
                 where UPPER(title) like ?
                 or UPPER(abstract_part_a) like ?
                 or UPPER(abstract_part_b) like ?";
    my $i = 2;
    while ( $i <= scalar(@names) ) {
        $query = $query . " or UPPER(title) like ?
                          or UPPER(abstract_part_a) like ?
                          or UPPER(abstract_part_b) like ?";
        $i++;
    }
    my $sth2 = $self->{'liter_db'}->prepare($query);
    my $j    = 1;
    while ( $j <= scalar(@names) ) {
        my $l = $j * 3 - 2;
        my $m = $j * 3 - 1;
        my $n = $j * 3;
        $names[ $j - 1 ] =~ tr/a-z/A-Z/;
        $names[ $j - 1 ] = "% " . $names[ $j - 1 ] . " %";
        $sth2->bind_param( $l, $names[ $j - 1 ] );
        $sth2->bind_param( $m, $names[ $j - 1 ] );
        $sth2->bind_param( $n, $names[ $j - 1 ] );
        $j++;
    }
    $sth2->execute();
    my ( $ref_id, @ref_ids );
    while ( $ref_id = $sth2->fetchrow_array ) {
        @ref_ids = ( @ref_ids, $ref_id );
    }
    $sth1->finish;
    $sth2->finish;
    return @ref_ids;

}

#################
sub get_features {
    my $self = $_[0];
    my $pid  = $_[1];
    my $sth1 = $self->{'db'}->prepare( "
                               SELECT feature_type, from_position,to_position,xref_dbname,xref_key 
                               FROM (gene_product_feature GF 
                                    LEFT OUTER JOIN dbxref   
                                    ON GF.dbxref_id = dbxref.dbxref_id 
                                    ) 
                               INNER JOIN gene_product_feature_type GFT 
                               ON GF.feature_type_id = GFT.feature_type_id
                               WHERE gene_product_id = ?
                               ORDER BY feature_type,from_position,to_position,xref_dbname
                            " );

    $sth1->bind_param( 1, $pid );
    $sth1->execute();
    my (
        $feature,       $from,     $to,    $feature_dbname,
        $feature_dbkey, @features, @froms, @tos,
        @feature_dbs,   @feature_dbkeys
    );
    while ( ( $feature, $from, $to, $feature_dbname, $feature_dbkey ) =
        $sth1->fetchrow_array )
    {
        @features       = ( @features,       $feature );
        @froms          = ( @froms,          $from );
        @tos            = ( @tos,            $to );
        @feature_dbs    = ( @feature_dbs,    $feature_dbname );
        @feature_dbkeys = ( @feature_dbkeys, $feature_dbkey );
    }
    $sth1->finish;
    return ( \@features, \@froms, \@tos, \@feature_dbs, \@feature_dbkeys );

}

sub search_pfam {
    my $self = $_[0];
    my $word = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "select xref_key, xref_desc
                               from dbxref
                               where xref_dbname = 'Pfam'
                               and ( UPPER(xref_key) = ? or UPPER(xref_desc) = ? )"
    );

    $sth1->bind_param( 1, $word );
    $sth1->bind_param( 2, $word );
    $sth1->execute();
    my ( $key, $desc ) = $sth1->fetchrow_array();
    my $dbname;
    if ($key) {
        $dbname = "Pfam";
    }
    else {
        my $sth2 = $self->{'db'}->prepare(
            "select prosite_id, prosite_desc
                                   from gene_product_prosite
                                   where UPPER(prosite_id) = ? or UPPER(prosite_desc) = ?"
        );
        $sth2->bind_param( 1, $word );
        $sth2->bind_param( 2, $word );
        $sth2->execute();
        ( $key, $desc ) = $sth2->fetchrow_array();
        if ($key) {
            $dbname = "PROSITE";
        }
        $sth2->finish;
    }
    $sth1->finish;
    return ( $key, $desc, $dbname );

}

###################################

sub search_pfam_all {
    my $self = $_[0];
    my $word = $_[1];
    $word = "%" . $word . "%";
    my ( @keys, @descs, @dbnames );
    my $sth1 = $self->{'db'}->prepare(
        "select xref_key, xref_desc
                               from dbxref
                               where xref_dbname = 'Pfam'
                               and ( UPPER(xref_key) like ? or UPPER(xref_desc) like ? )"
    );

    $sth1->bind_param( 1, $word );
    $sth1->bind_param( 2, $word );
    $sth1->execute();
    while ( my ( $key, $desc ) = $sth1->fetchrow_array() ) {
        @keys    = ( @keys,    $key );
        @descs   = ( @descs,   $desc );
        @dbnames = ( @dbnames, "Pfam" );
    }
    $sth1->finish;

    my $sth2 = $self->{'db'}->prepare(
        "select distinct prosite_id, prosite_desc
                               from gene_product_prosite
                               where UPPER(prosite_id) like ? or UPPER(prosite_desc) like ?"
    );

    $sth2->bind_param( 1, $word );
    $sth2->bind_param( 2, $word );
    $sth2->execute();
    while ( my ( $key, $desc ) = $sth2->fetchrow_array() ) {
        @keys    = ( @keys,    $key );
        @descs   = ( @descs,   $desc );
        @dbnames = ( @dbnames, "PROSITE" );
    }
    $sth2->finish;

    return ( \@keys, \@descs, \@dbnames );

}

#####################################

sub pfam_to_desc {
    my $self = $_[0];
    my $word = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "select xref_key, xref_desc
                               from dbxref
                               where xref_dbname = 'Pfam'
                               and UPPER(xref_key) = ?"
    );

    $sth1->bind_param( 1, $word );
    $sth1->execute();
    my ( $key, $desc ) = $sth1->fetchrow_array();
    $sth1->finish;
    return ( $key, $desc );

}

sub prosite_to_desc {
    my $self = $_[0];
    my $word = $_[1];
    my $sth1 = $self->{'db'}->prepare(
        "select PROSITE_ID, PROSITE_DESC
                               from gene_product_prosite
                               where UPPER(PROSITE_ID) = ?"
    );

    $sth1->bind_param( 1, $word );
    $sth1->execute();
    my ( $key, $desc ) = $sth1->fetchrow_array();
    $sth1->finish;
    return ( $key, $desc );

}

sub get_id_by_gi {
    my $self = $_[0];
    my $gi   = $_[1];
    my $sth  =
      $self->{'db'}->prepare(
"select GENE_PRODUCT_ID from gene_product_to_gi_number where gi_number=?"
      );
    $sth->bind_param( 1, $gi );
    $sth->execute;
    my ($gp_id) = $sth->fetchrow_array();
    $sth->finish;
    return $gp_id;

}

sub get_id_by_pid {
    my $self = $_[0];
    my $pid  = $_[1];
    my $sth  =
      $self->{'db'}
      ->prepare("select GENE_PRODUCT_ID from gene_product_to_pid where pid=?");
    $sth->bind_param( 1, $pid );
    $sth->execute;
    my ($gp_id) = $sth->fetchrow_array();
    $sth->finish;
    return $gp_id;

}

sub get_protein_xref_db {
    my $self = $_[0];
    my $gpid = $_[1];
    my $sth  = $self->{'db'}->prepare(
        q[
                         SELECT xref_dbname
                         FROM   gene_product,dbxref
                         WHERE  organism_dbxref_id = dbxref_id 
                         AND    gene_product_id = ?
                       ]
    );
    $sth->execute( ($gpid) );
    my ($xref_dbname) = $sth->fetchrow_array();
    $sth->finish;
    return $xref_dbname;

}

################
sub get_all_xref_db_urls{
    my ($self ) = @_;
    my ($url_templates) = $self->{'db'}->selectall_hashref(
	q[
	    SELECT upper(name) as db_name, url_syntax FROM data_base
	],('db_name') );

    return $url_templates;

}

sub get_xrefs{
    my ($self, $obj_id, $xref_dbname, $xref_keytype) = @_;


    my $table_name = 'gramene.protein';
    my $sql = (
        " SELECT distinct xref_key
	  FROM  objectxref OX, dbxref DX
	  WHERE OX.dbxref_id = DX.dbxref_id
	  AND   row_id = ? 
	  AND   table_name = ?
	  AND   xref_dbname = ?
	"
    );


    if($xref_keytype){
	$sql.= ' AND xref_keytype = ? ';
    }

    my $sth = $self->{'db'}->prepare($sql);
    my @params = ($obj_id, $table_name,$xref_dbname);
    push(@params, $xref_keytype) if $xref_keytype;

    $sth->execute( @params );
    my @xref_keys;
    while (my ($xref_key) = $sth->fetchrow_array){
	push @xref_keys,$xref_key;
    }

    return @xref_keys;

}
1;

