package Gramene::Mutant::MutantCurationDB; 

=head1 NAME

Mutant::MutantCurationDB

=head1 SYNOPSIS
  

=head1 DESCRIPTION

A module for querying mutant database  

=cut

# ----------------------------------------------------------------

use strict;
use DBI;

use Gramene::DB;


my $db;
my $ot_db;



sub new {

    my $class = shift;
    my $self = { };
    bless($self, $class);
    return $self;

}


# destructor
sub DESTROY {
  my $self = shift;
  #$self->terminate_database;
}


sub terminate_database{
  my $self = shift;
  $db->disconnect() if $db;
  $ot_db ->disconnect() if $ot_db;

}



sub connect_to_db {

   #  my %attr = (
   #         AutoCommit       => 0,
   #         FetchHashKeyName => 'NAME_lc',
   #         LongReadLen      => 3000,
   #         LongTruncOk      => 1,
   #         RaiseError       => 1,
   #      );

	
  
   # my $config     = Gramene::Config->new;
  
   # $config->filename('/usr/local/gramene/lib/perl/Mutant/mutant.conf') or die $config->error; # read a local config

   # my  $mutant_config = $config->get('mutant');

   # $db= DBI->connect( 
   #     $mutant_config->{'db_dsn'},
   #     $mutant_config->{'db_user'},
   #     $mutant_config->{'db_pass'},
   #     \%attr
   # ) || die "Can't connect to database: $DBI::errstr\n";

   
     eval{
         $db = Gramene::DB->new('mutant_phase1');
         $db->{AutoCommit}=0;  # set transaction control
       
         $ot_db = Gramene::DB->new('ontology');
     };
     if($@){
         die "DB connection failed: $@\n";
     }


}


sub get_all_species{

    my @species;
    my $sth = $db->prepare("SELECT species_id,common_name FROM mutant_species");
    $sth->execute or die $db->errstr;
    my($species_id,$common_name);
    $sth->bind_columns(\$species_id,\$common_name);

    while($sth->fetch){
      push @species,{'species_id'=>$species_id,'species_name'=>$common_name};
    }
   
    return \@species;
}



sub get_all_dbxrefs{

    my @dbxrefs;
    my $sth = $db->prepare("SELECT dbxref_id,dbxref_name FROM mutant_dbxref");

    $sth->execute or die $db->errstr;

    my ($dbxref_id,$dbxref_name);
    $sth->bind_columns(\$dbxref_id,\$dbxref_name);

    while($sth->fetch){
	push @dbxrefs, {'dbxref_id'=>$dbxref_id,'dbxref_name'=>$dbxref_name};
    }


    return \@dbxrefs;
}

sub get_gene_id{
    my $acc = $_[1];


 
    my ($gene_id) = $db->selectrow_array(
                              q[ 
                                SELECT gene_id FROM mutant_gene
                                WHERE  accession = ?
				 ], {}, ($acc)
					 );
    return $gene_id;

}



# get a gene object hashref with 
# gene_id, accession, symbol,symbol_id,name, name_id,
# species_id, chromosome, description, curator_comment, is_obsolete
# string as key and their vales
sub get_gene_general_info{
    my $gene_id= $_[1];


    my $sth = $db->prepare(
                            q[
                              SELECT gene_id,
                                     accession,
                                     SY.synonym_name as symbol,
                                     symbol_id,
                                     SN.synonym_name as name,
                                     name_id,
                                     mutant_gene.species_id,
                                     chromosome,
                                     description,
                                     curator_comment,
                                     is_obsolete
                              FROM   mutant_gene
			      INNER  JOIN mutant_synonym SY
			      ON     mutant_gene.symbol_id = SY.synonym_id
			      INNER  JOIN mutant_synonym SN
			      ON     mutant_gene.name_id = SN.synonym_id
			      LEFT   JOIN mutant_chromosome
			      ON     mutant_gene.chromosome_id = mutant_chromosome.chromosome_id
                              WHERE  gene_id =?

                               ]
			    );





    $sth->execute(($gene_id)) or die $db->errstr;


    my $gene_obj = $sth->fetchrow_hashref();

    $sth->finish;
    return $gene_obj;
}



# get a synonym obj with synonym_id as key,synonym_name as value
sub get_gene_synonyms{
    my $gene_id = $_[1];

    my $sth = $db->prepare(
                             q[
                                SELECT synonym_name,S.synonym_id
                                FROM mutant_gene_synonym MS,mutant_synonym S
                                WHERE MS.synonym_id = S.synonym_id
                                AND gene_id =?
                              ]
                            );

    $sth->execute(($gene_id)) or die $db->errstr;

    my %synonyms;

    while(my ($syn,$syn_id) = $sth->fetchrow_array){
	$synonyms{$syn_id} = $syn;
    }

  
    $sth->finish;

    return \%synonyms;
}

sub add_gene_synonym{

    my ($self,$gene_id,$syn_val,$edit_result)=@_;

    eval{
  
        my @synonyms = _process_delimited_values(',',$syn_val);
        foreach my $syn (@synonyms){
	   my $syn_id = _find_or_create_synonym($syn);
	   _load_gene_synonym($gene_id,$syn_id);
        }
	$db->commit();
    };
    if($@){
	push(@{$edit_result->{'error'}}, "Unable to add gene synonym: $@");
	$db->rollback();
	return;
    }

}


# update the symbol  or name of mutant_gene table, 
# the old name or symbol will become synonym in mutant gene synonym table

sub update_gene_synonym{
    my ($self,$field,$gene_id,$old_symbol_id,$new_symbol_id,$edit_result)=@_;
 
     eval{
       # update the mutant_gene table
       $db->do(
              qq[
                 UPDATE mutant_gene SET $field=? WHERE gene_id = ?
		],{},($new_symbol_id,$gene_id)
	       );
 

        # check whether the new symbol(name) from the synonym table
        my($gene_synonym_id) = $db->selectrow_array(
                   q[
                     SELECT gene_synonym_id
                       FROM mutant_gene_synonym
                      WHERE gene_id=? and synonym_id =? 
		     ],{},($gene_id,$new_symbol_id)
						   );
    
        #  check whether the old symbol(name) still in gene table after update
        #  
        my ($gene_id_check) = $db->selectrow_array(
                   q[
                      SELECT gene_id
                        FROM mutant_gene
                       WHERE 
                         (symbol_id = ? 
                          OR name_id = ?
                         )
                         AND gene_id = ?
                     ]
                     ,{},($old_symbol_id,$old_symbol_id,$gene_id) 
                  );


       if($gene_synonym_id){# the new synonym comes from gene_synonym table
	   if($gene_id_check){ #the old symbol is same as the name
               # delete the new synonym from the synonym table since we use it as symbol now
               $db->do(
                    q[
                      DELETE FROM mutant_gene_synonym
                       WHERE gene_synonym_id=?
		      ],{},($gene_synonym_id)
		       );
           }else{ 
               # update the synonym table, the old symbol becomes a synonym 
               $db->do(
                    q[
                       UPDATE mutant_gene_synonym
                          SET synonym_id = ?
                        WHERE gene_synonym_id =?
                     ],{},($old_symbol_id,$gene_synonym_id)
              );  
	   }
       }else{# the new synonym from symbol or name field
           ($gene_synonym_id)=$db->selectrow_array(
                   q[
                      SELECT gene_synonym_id
                        FROM mutant_gene_synonym
                       WHERE gene_id=? and synonym_id =?
		    ],{},($gene_id,$old_symbol_id)
						   );
           unless($gene_synonym_id){
	     # the old symbol will become a synonym
             $gene_synonym_id = _next_id('mutant_gene_synonym','gene_synonym_id');
             $db->do(
               q[
                  INSERT INTO mutant_gene_synonym values (?,?,?)
                  ],{},($gene_synonym_id,$gene_id,$old_symbol_id)
                );
            }                       
       }   
       $db->commit();
    };
    if($@){
        push(@{$edit_result->{'error'}}, "Unable to update gene synonym: $@");
        $db->rollback();
    }

}

sub delete_gene_synonym{
    my ($self,$gene_id,$syn_id,$edit_result)=@_;
    eval{
         $db->do(
                 q[
                    DELETE FROM mutant_gene_synonym
                    WHERE gene_id =? 
                      AND synonym_id = ?
		   ],{},($gene_id,$syn_id)
		 );

         $db->commit();
    };
    if($@){
        push(@{$edit_result->{'error'}}, "Unable to delete gene synonym: $@");
        $db->rollback();
    }
 
}

sub get_synonym_name{
    my $syn_id = $_[1];
    my ($syn) = $db->selectrow_array(
                   q[
                     SELECT synonym_name FROM mutant_synonym
                      WHERE synonym_id = ?
		     ],{},($syn_id)
				     );

    return $syn;
}




sub get_gene_simple_field{
    my ($self,$field,$gene_id)=@_;
    my ($val) = $db->selectrow_array(
                        qq[
                          SELECT $field FROM mutant_gene
                          WHERE gene_id = ?
			  ],{},($gene_id)
				     );
    return $val;

}

# update field in mutant_gene table
sub update_gene_simple_field{
  my ($self,$field_name,$gene_id,$field_value,$edit_result)=@_;

  eval{
        $db->do(
               qq[
                 UPDATE mutant_gene
                    SET $field_name = ?
                  WHERE gene_id = ?
                 ],{},($field_value,$gene_id)
                );

        $db->commit;
    };
  if($@){
      $field_name =~s/_id$//;  #remove _id (name,symbol) for web display
      push(@{$edit_result->{'error'}}, "Unable to update gene $field_name: $@");
      $db->rollback();
  }


}



# field means dbxref_id or dbxref_name
sub get_gene_dbxrefs_by_field{
    my ($self,$field_name,$field_id,$gene_id)=@_;

    my $sql= qq[
                     SELECT mutant_dbxref_to_object_id,dbxref_value,dbxref_name
                     FROM mutant_dbxref_to_object DTO,mutant_dbxref DBX
                     WHERE DTO.mutant_dbxref_id = DBX.dbxref_id
                     AND   table_name= ?
                     AND   record_id = ?
                     AND   $field_name = ?
              ];


    my $sth = $db->prepare($sql);

    $sth->execute(('mutant.gene',$gene_id,$field_id));
    my $dbxrefs;
    while(my ($id,$val,$db_name) = $sth->fetchrow_array){
        $dbxrefs->{$db_name}->{$id}=$val;
    }

    $sth->finish;
    return $dbxrefs;
}


# get dbxref with 
# $dbxrefs->{$db_name}->{$mutant_dbxref_to_object_id}=$dbxref_value;
sub get_gene_dbxrefs{
    my ($self,$gene_id) = @_;
    my $sql= q[
                     SELECT mutant_dbxref_to_object_id,dbxref_value,dbxref_name
                     FROM mutant_dbxref_to_object DTO,mutant_dbxref DBX
                     WHERE DTO.mutant_dbxref_id = DBX.dbxref_id
                     AND   table_name= ?
                     AND   record_id = ?
	      ];


    my $sth = $db->prepare($sql);
     
    $sth->execute(('mutant.gene',$gene_id));

    my $dbxrefs;
    while(my ($id,$val,$db_name) = $sth->fetchrow_array){
	$dbxrefs->{$db_name}->{$id}=$val;
    }
    
    $sth->finish;
    return $dbxrefs;
}

sub delete_gene_dbxref{
    my ($self,$dbx_valsRef,$edit_result)=@_;
    eval{
        foreach my $val (@$dbx_valsRef){
          $db->do(
                  q[
                    DELETE FROM mutant_dbxref_to_object
                     WHERE mutant_dbxref_to_object_id = ?
		    ],{},($val)
		  );
           }
        $db->commit;
    };
    if($@){
        push(@{$edit_result->{'error'}}, "Unable to add gene dbxref: $@");
        $db->rollback();
    }
    
}

sub add_new_gene_dbxref{
    my ($self,$gene_id,$dbx_id,$dbx_val,$edit_result)=@_;

    eval{

          _load_mutant_dbxref($gene_id,$dbx_id,$dbx_val);

          $db->commit;
    };
    if($@){
	push(@{$edit_result->{'error'}}, "Unable to add gene dbxref: $@");
	$db->rollback();
    }
}


# get gene ontology association obj, 
# term_type_id as key and an arrayref of terms as value
sub get_gene_ontology_association{
    my $gene_id = $_[1];

    my $sth = $db->prepare(
                            q[
                               SELECT term_type,term_accession
                               FROM   mutant_gene_term_association
                               WHERE  gene_id =?
                               GROUP BY term_type, term_accession
                             ]
                            );

    $sth->execute(($gene_id)) or die $db->errstr;


    my $terms;

    while(my ($type,$acc) = $sth->fetchrow_array){
      
        push(@{$terms->{$type}},$acc);
    }

    $sth->finish;
    return $terms;
}

sub get_gene_ontology_association_by_type{
    my ($self,$gene_id,$type) = @_;

    my $sth = $db->prepare(
                            q[
                               SELECT term_accession
                               FROM   mutant_gene_term_association
                               WHERE  gene_id =?
                                 AND  term_type = ?
                             ]
			   );

    $sth->execute(($gene_id,$type)) or die $db->errstr;


    my @terms;

    while(my ($acc) = $sth->fetchrow_array){

        push(@terms,$acc);
    }

    $sth->finish;
    return \@terms;
}


sub add_gene_ontology_terms{
     my ($self,$gene_id,$term_type,$term_acc,$edit_result)=@_;

     my @term_accs = _process_delimited_values(',',$term_acc);
    
     my @checked_terms;
     foreach my $term_acc (@term_accs){
        my $checked_term = _check_term($term_acc,$term_type,$edit_result);
        if($checked_term){   # $checked term is a hashref of term obj         
                push(@checked_terms,$checked_term)  ;
        }   
     }         
     
     return  if ($edit_result->{'error'}) ; 
     
     eval{ 

        _load_term_assocs($gene_id,$term_type,\@checked_terms,$edit_result);

        $db->commit;
     };
     if($@){
         push(@{$edit_result->{'error'}}, "Unable to add ontology associaiton: $@");
         $db->rollback();
    }

}

sub delete_gene_ontology_terms{
    my ($self,$gene_id,$terms,$edit_result)=@_;
    eval{
	foreach my $term_acc (@$terms){
          $db->do(
                 q[
                    DELETE FROM mutant_quick_term_association
                    WHERE  object_table=?
                    AND    object_id =?
                    AND    term_acc = ?  
                  ],
                  {},('mutant.gene',$gene_id,$term_acc)
                  );

          $db->do(
                q[
                   DELETE FROM mutant_gene_term_association
                    WHERE gene_id = ?
                    AND   term_accession = ?
                 ],
		 {},($gene_id,$term_acc)
		  );

        }
     
         $db->commit;
     };
     if($@){
         push(@{$edit_result->{'error'}}, "Unable to delete ontology associaiton: $@");
         $db->rollback();
    }   

}


sub get_gene_curation_note{
    my $gene_id = $_[1];
    
     my ($note) = $db->selectrow_array(
                     q[
                       SELECT note FROM mutant_gene_curation_note
                        WHERE gene_id = ?
                      ],
		      {}, ($gene_id)
			  );
    
    return $note;                    


}

sub update_gene_curation_note{
    my ($self,$gene_id,$note,$edit_result)=@_;
    eval{
         $db->do(
                q[
                  UPDATE mutant_gene_curation_note
                    SET  note = ?
                   WHERE gene_id = ?
                 ],
		 {},($note,$gene_id)
		 );

         $db->commit;
     };
     if($@){
         push(@{$edit_result->{'error'}}, "Unable to update gene curation note: $@");
         $db->rollback();
    }
}

sub add_gene_curation_note{
    my ($self,$gene_id,$note,$edit_result)=@_;
    eval{
        _load_curation_note($gene_id,$note);
	$db->commit;
    };
    if($@){
	push(@{$edit_result->{'error'}}, "Unable to update gene curation note: $@");
	$db->rollback();
    }
}

sub delete_gene_curation_note{
    my ($self,$gene_id,$edit_result)=@_;
    eval{
         $db->do(
                 q[
                   DELETE FROM mutant_gene_curation_note
                    WHERE gene_id = ?
                  ],
                  {},($gene_id)
                );         

         $db->commit;
    };
    if($@){
        push(@{$edit_result->{'error'}}, "Unable to update gene curation note: $@");
        $db->rollback();
    }
}



sub _process_delimited_values{
    my ($delimiter,$val) = @_;
    my @vals_raw = split(/$delimiter/,$val);
    my %seen;
    my @vals;
    foreach my $val (@vals_raw){
	$val =~s/^\s+|\s+$//g;
        unless($seen{$val}++){
	    push @vals, $val;
        }
    }
  
    return @vals;
}


#########################################################
#########################################################
#   mutant curation
#
sub load_mutant{

    my $params = $_[1];
   
    # a hashref to hold the errors if error and mutant accession if success
    my $result={}; 
   
    #check required fields 
    my @required_general_fields=qw[gene_symbol gene_name species description]; 

    foreach my $req_field (@required_general_fields){
        unless($params->{$req_field}){
	    push(@{$result->{'error'}},"$req_field can't be empty.");
        }

    }


    #check ontology association, at least one association
    #validate the term accessions 
    my %ontology_fields = (
                         'to'=>5,
                         'po_anatomy'=>6,
                         'po_growth_stage'=>7,                       
                         'go_mf'=>4,
                         'go_bp'=>2,
                         'go_cc'=>3,
			 'eo'=>9
				);



    my $check_onto=0;     
    my %checked_ontos;

    foreach my $onto (keys %ontology_fields){
       if($params->{$onto}){
	   $check_onto=1;   
          
           my @term_accs=  _process_delimited_values(',',$params->{$onto});
           
           my $term_type_id = $ontology_fields{$onto}; 
      
          foreach my $term_acc (@term_accs){
             my $checked_term = _check_term($term_acc,$term_type_id,$result);
             if($checked_term){   # $checked term is a hashref of term obj         
                push(@{$checked_ontos{$onto}},$checked_term)  ;
            }   
        }         
     } 
   }  
   

    push(@{$result->{'error'}},"Mutant gene must have at least one ontology association.") unless $check_onto;

    # errors before loading
    return $result if ($result->{'error'}) ; 

    foreach my $key (keys %$params){
        my $val = $params->{$key};
        $val =~s/^\s+|\s+$//g;
        $val =~s/\s+/ /g;
        $params->{$key} = $val;
    }

    my $accession =  $params->{'acc'};  

        
    eval{
	my $gene_id = _next_id('mutant_gene', 'gene_id' ); 

        _load_mutant_general_information($gene_id,$params,$result);  

        foreach my $onto (keys %checked_ontos){
	    my $term_type_id = $ontology_fields{$onto};
            my $checked_terms = $checked_ontos{$onto};
            _load_term_assocs($gene_id,$term_type_id,$checked_terms,$result);
        }



        if($params->{'synonyms'}){
	   
            my @synonyms = _process_delimited_values(',',$params->{'synonyms'});
	    foreach my $syn (@synonyms){
                my $syn_id = _find_or_create_synonym($syn);
		_load_gene_synonym($gene_id,$syn_id);
	    }
        }


        if($params->{'seq_gene'}){
            my $dbxref_id = _get_dbxref_id('GenBank.Nucleotide');
	    _load_mutant_dbxref($gene_id,$dbxref_id,$params->{'seq_gene'});
        }

        if($params->{'seq_protein'}){
            my $dbxref_id = _get_dbxref_id('Gramene.Protein');
	    _load_mutant_dbxref($gene_id,$dbxref_id,$params->{'seq_protein'});
        } 

        my $i=0;
        while($i<3){ # 3 dbxrefs now
	    if($params->{"dbxref_db_name_$i"} && $params->{"dbxref_db_val_$i"}){
		_load_mutant_dbxref($gene_id,$params->{"dbxref_db_name_$i"},$params->{"dbxref_db_val_$i"}); 
            }
            $i++;
        }


	if($params->{'curator_note'}){
	    _load_curation_note($gene_id,$params->{'curator_note'});
	}

        
  
        $db->commit;

    };
    if($@){
       push(@{$result->{'error'}}, "Unable to save to database: $@");
       $db->rollback();
   }else{
       $result->{'ok'}=$accession;  # loading succefully

   }

    return $result; 


}

sub _load_mutant_general_information{
    my ($gene_id,$params,$result)=@_;

    # find or create the 'synonym'
    my $symbol_id = _find_or_create_synonym($params->{'gene_symbol'});
    my $name_id = _find_or_create_synonym($params->{'gene_name'});
    my $chromosome_id ='';
    if($params->{'chromosome'}){
	($chromosome_id) = $db->selectrow_array(
			    q[
				SELECT chromosome_id 
				FROM   mutant_chromosome
				where  chromosome= ?
				AND    species_id = ?
			    ],
			    {},($params->{'chromosome'},$params->{'species'}));
    }


    my $is_obsolete = 0;    

    my @data =map {defined $_ ? $_: ''}
                                     ( 
                                       $gene_id,
                                       $params->{'acc'},
                                       $symbol_id,
                                       $name_id,
                                       $params->{'species'},
                                       $chromosome_id,   
                                       $params->{'description'},
                                       $params->{'curator_comment'},  
                                       $is_obsolete
				       );

    $db->do(
             q[
                INSERT INTO mutant_gene
               (gene_id,accession,symbol_id,name_id,species_id,chromosome_id,
                description, curator_comment, is_obsolete)
                VALUES (?,?,?,?,?,?,?,?,?)
              ],                          
	      {},@data              
            );
                


}

sub  _load_gene_synonym{
    my ($gene_id,$syn_id) = @_;
 
    my  $gene_synonym_id = _next_id('mutant_gene_synonym','gene_synonym_id');
   $db->do(
           q[ 
              INSERT INTO mutant_gene_synonym (gene_synonym_id, gene_id, synonym_id)
              VALUES   (?, ?, ?) 
            ],
            {},
           ($gene_synonym_id,$gene_id,$syn_id) 
      	);    
   
}


sub _load_curation_note{
    my ($gene_id,$note) =@_;
    $db->do(
           q[
             INSERT INTO mutant_gene_curation_note (gene_id,note)
             VALUES (?, ?)
            ],
            {},
            ($gene_id,$note)           
	  ); 

}

sub _next_id {
    my ($table_name, $field_name ) = @_;
    my $id = $db->selectrow_array("select max($field_name) from $table_name");
    return $id + 1;
}


sub _find_or_create_synonym{

    my ($synonym)=@_;

   my ($synonym_id) = $db->selectrow_array( 
                         q[ 
                            SELECT synonym_id 
                            FROM   mutant_synonym 
                            WHERE  synonym_name =?
                          ], 
					    {}, 
                          ($synonym)   
					    ); 
    my @data; 
 
    unless($synonym_id){ 
 
	$synonym_id = _next_id('mutant_synonym','synonym_id'); 
	@data =($synonym_id,$synonym); 
         
           $db->do( 
                    q[ 
                        INSERT INTO mutant_synonym (synonym_id,synonym_name) 
                             VALUES (?,?)  
                      ],  
		    {}, @data 
		    ); 
 
    }

    return $synonym_id;   

}

sub _get_ancestors{ 
    my ($term_id, $ancestors)= @_; 
 
 
    my $sth = $ot_db->prepare( 
                          q[ SELECT term1_id FROM term_to_term  
                             WHERE term2_id = ? 
                           ] 
			      ); 
 
    $sth->execute(($term_id)) or die $ot_db->errstr; 
 
    my @parents; 
    while(my ($parent) = $sth->fetchrow_array){ 
	push @parents, $parent; 
    }   
   
    for my $parent (@parents) { 
	unless($ancestors->{$parent}++){ 
	    _get_ancestors($parent, $ancestors); 
	}  
    } 
   
    $sth->finish;
} 



sub _load_term_assocs{
    my ($gene_id,$term_type,$termsRef,$result) = @_;
    my @checked_terms = @$termsRef;

    foreach my $term (@checked_terms){
     
       _build_quick_term_assoc($term,$gene_id,'mutant.gene',$result);
        
       my $gene_term_assoc_id = _next_id('mutant_gene_term_association','gene_term_association_id' ); 

        $db->do(
               q[
                 INSERT INTO  mutant_gene_term_association
                 VALUES (?,?,?,?)
                ],
               {},
               ($gene_term_assoc_id,$gene_id,$term->{'term_acc'},$term_type )

	   );

   }

}



sub _build_quick_term_assoc{ 
 
    my ($term,$obj_id,$table_name,$result) = @_; 

    return if($term->{'term_id'}==-1); # for term not exist in ontology


  # check if the term hirachy structure exist 
    my @terms;   
    my $sth = $db->prepare( qq[ 
                               SELECT  root_term_acc,root_term_name 
                                FROM   mutant_quick_term_association  
                                       WHERE  term_acc =?  
                                       AND    object_table = ?  
                               ] 
			   ); 
    $sth->execute(($term->{'term_acc'},$table_name)) or die $db->errstr; 
  
    my %uniq_term_accs; # two term may have same ancestor terms 
  
    my ($term_acc1,$term_name1); 
    while(($term_acc1,$term_name1) = $sth->fetchrow_array){ 
	unless($uniq_term_accs{$term_acc1}++){ 
	    push @terms, {'term_acc'=>$term_acc1,'term_name'=>$term_name1};  
	} 
 
    } 
            
    unless(@terms){ # get the hirarch from ontology db 
     
      my $ancestors={}; 
      _get_ancestors($term->{'term_id'},$ancestors); 
      $ancestors->{$term->{'term_id'}}=1; # inlude itself to the ancestors 
      foreach my $term_id (sort {$a<=>$b}  keys (%$ancestors)){ 
        my ($term_name,$term_acc,$term_type) = $ot_db->selectrow_array( 
                               q[ 
                                 SELECT term_name,term_accession,term_type_id 
                                   FROM term   
                                  WHERE term_id = ? 
				  ],{},($term_id) 
									 ); 
        push @terms, {'term_acc'=>$term_acc,'term_name'=>$term_name};   
     
    }  
 
  }

  foreach my $term1 (@terms){ 
          $db->do( 
                   qq[ 
                      INSERT INTO mutant_quick_term_association 
                      VALUES (?,?,?,?,?,?) 
                      ], 
                   {}, 
		   ($term1->{'term_acc'}, 
		    $term1->{'term_name'}, 
                     $term->{'term_acc'}, 
                     $term->{'term_name'}, 
                     $table_name, 
                     $obj_id 
                    ) 
                   );   
 
      }     

  return;  
 
} 



#check whether the term exists in ontology
#return a hash of term obj(term_acc,term_id,term_name)  if exists, else null
#a passed in param result will hold the checking errors 
sub _check_term{
    my ($term_acc,$term_type,$result) = @_;

    my ($term_id,$term_name);
            #
           #validate the term
           #
    if($term_acc =~/^(\w+:)(\d+)$/){
       my ($term_prefix, $term_val) = ($1,$2);   
   
       unless(($term_type<=4 && $term_prefix eq 'GO:') ||
              ($term_type==5 && $term_prefix eq 'TO:') ||
              ($term_type==6 && $term_prefix eq 'PO:') ||
              ($term_type==7 && $term_prefix eq 'GRO:')||
              ($term_type==9 && $term_prefix eq 'EO:')
	      ){
             push(@{$result->{'error'}},"term $term_acc 's  type is not correct.");
             return ;
       }
       

       my $term_length = length($term_val);
       unless ($term_length ==7){       ## ontology term length 7
	 $term_val =~s/^0+//g;            # remove the prefix 0 
	 my $length = 7 - length($term_val);
	 $term_val ="0".$term_val   for (1 .. $length);
	 $term_acc = $term_prefix.''.$term_val;
       }

       my $sql=q[SELECT term_id,term_name FROM term WHERE term_accession=? AND term_type_id=? ];


       my $term_acc2 = $term_acc;


       ($term_id,$term_name)= $ot_db->selectrow_array($sql,{},($term_acc2,$term_type));
  
       
       if($term_id){
    
          return {'term_acc'=>$term_acc,'term_id'=>$term_id,'term_name'=>$term_name};
  
       }else{
         # for turn on checking
         #  push(@{$result->{'error'}},"term $term_acc is not found in ontology DB.");
         #    return;

         #for turn off checking
         return {'term_acc'=>$term_acc,'term_id'=>-1,'term_name'=>'NA'}; 
       }
 
     }else{
         push(@{$result->{'error'}},"term $term_acc 's  type is not defined.");
         return;
     }        

    

} 


sub _get_dbxref_id{
    my $dbxref_name = shift;
    
    my $dbxref_id = $db->selectrow_array(
            q[
              SELECT dbxref_id FROM mutant_dbxref
              WHERE dbxref_name = ?
             ],
	     {},($dbxref_name)
	 );

    return $dbxref_id;
}

sub _load_mutant_dbxref{

    my ($gene_id,$dbxref_id,$dbxref_val) = @_;

 
    my @dbxref_vals = _process_delimited_values(',',$dbxref_val);

 
    my $table_name='mutant.gene';
    foreach my $db_val (@dbxref_vals){
      my $dbxref_to_obj_ref_id_ref = $db->selectcol_arrayref(
	 q[
	     SELECT mutant_dbxref_to_object_id
	     FROM   mutant_dbxref_to_object
	     WHERE  mutant_dbxref_id = ?
	     AND    table_name = ?
	     AND    record_id = ?
	     AND    dbxref_value = ?
	  ],
	  {'MaxRows'=>1},
	  ($dbxref_id, $table_name, $gene_id,$db_val));
      
      next if $dbxref_to_obj_ref_id_ref->[0]; # already in db

	

      my $dbxref_to_obj_id = _next_id('mutant_dbxref_to_object', 'mutant_dbxref_to_object_id' ); 

      $db->do(
            q[
              INSERT INTO mutant_dbxref_to_object 
              VALUES (?,?,?,?,?)
             ],
	     {},
            ($dbxref_to_obj_id,$dbxref_id, $table_name, $gene_id,$db_val)
		       );


    }



}


sub add_dbxref{
  my ($self,$dbx_name,$dbx_url,$result)=@_;
  eval{
      my $dbx_id = _next_id('mutant_dbxref','dbxref_id');
      $db->do(
              q[
                INSERT INTO mutant_dbxref
                VALUES (?,?,?)
		],{},($dbx_id,$dbx_name,$dbx_url)
              );
       
       push(@{$result->{'ok'}}, "DBXRef is loaded successfully.");

       $db->commit();
    };
  if($@){
     push(@{$result->{'error'}}, "Unable to add dbxref: $@");
     $db->rollback();
  }  

}

sub add_species_and_chromosomes{
    my ($self,$common_name,$taxa_id,$genus,$chromosomes_string,$result)=@_;
   
    my $spe_name =''; # ignore the species name
    my $lineage_string='';
    my $spe_id = $db->selectrow_array(
            q[
                SELECT species_id
                FROM  mutant_species
                WHERE  UPPER(common_name) = ?
             ],{},(uc($common_name))
            );  
    if($spe_id){
	push(@{$result->{'error'}}, "Unable to add species: $common_name exists in db already.");
    }else{
       eval{
        my $spe_id = _next_id('mutant_species','species_id'); 
        $db->do(
                q[
                  INSERT INTO mutant_species
                   VALUES (?,?,?,?,?,?)
                 ],
                 {},
                ($spe_id,$taxa_id,$common_name,$lineage_string,$genus,$spe_name)
                 ); 
        my $max_chromo_id = $db->selectrow_array(
		q[
		    SELECT MAX(chromosome_id)
		    FROM   mutant_chromosome
		]) || 0;

	my @chromosomes = split /,/,$chromosomes_string;

	foreach my $chromosome (@chromosomes){
	    $chromosome =~s/^\s+|\s+$//g;

	    $db->do(
                 q[
                   INSERT INTO mutant_chromosome
                    VALUES (?,?,?)
                  ],
                  {},
                  (++$max_chromo_id,$spe_id,$chromosome)
                ) ; 
	}
    
	push(@{$result->{'ok'}}, "Species is loaded successfully.");

	$db->commit();
    };
    if($@){
	push(@{$result->{'error'}}, "Unable to add species: $@");
	$db->rollback();
    }
  }
}

# get the chromosomes by species id
sub get_chromosomes_by_species{
 my ($self, $spe_id) = @_;

 if($spe_id){
   
    my $sth = $db->prepare(qq[
                            select chromosome
                              from mutant_chromosome
                             where species_id = ?
			     order by chromosome
                            ]
                          );   
    $sth->execute(($spe_id));
    my @chrs;
    while( my ($chr) = $sth->fetchrow_array()){
      push @chrs, $chr;
    }
    return \@chrs;   

 }
 

}

sub get_chromosome_id{
    my ($self, $chr, $spe_id) = @_;
    my ($chr_id) = $db->selectrow_array(
	q[
	    SELECT chromosome_id
	    FROM   mutant_chromosome
	    WHERE  chromosome = ?
	    AND    species_id = ?
	],{},($chr, $spe_id));

    return $chr_id;
}




1;



