package Gramene::Marker::Import;

# $Id: Import.pm,v 1.2 2007/05/18 12:59:38 kclark Exp $

=head1 NAME

Gramene::Marker::Import - a Gramene module

=head1 SYNOPSIS

  use Gramene::Marker::Import;

=head1 DESCRIPTION

Description of module goes here.

=head1 SEE ALSO

perl.

=head1 AUTHOR

Ken Youens-Clark E<lt>kclark@cshl.eduE<gt>.

=head1 COPYRIGHT

Copyright (c) 2007 Cold Spring Harbor Laboratory

This library is free software;  you can redistribute it and/or modify 
it under the same terms as Perl itself.

=cut

# ----------------------------------------------------

use strict;
use Carp qw( croak );
use Gramene::Marker::Import::GenBank;
use Gramene::Marker::Import::Tab;
use Readonly;

use base qw( Class::Base );

Readonly my %VALID_FORMAT => (
    genbank => 'GenBank',
    tab     => 'Tab',
);
Readonly my $VERSION => sprintf "%d.%02d", q$Revision: 1.2 $ =~ /(\d+)\.(\d+)/;

sub import_data {
    my ( $self, %args ) = @_;
    my @files  = ref $args{'files'} eq 'ARRAY' 
               ? @{ $args{'files'} } : ( $args{'files'} );

    if ( !@files ) {
        croak('No files');
    }

    my $format = lc $args{'format'} || '';

    if ( !$format ) {
        my $file = $files[0] or croak('No file?!');
        if ( $file =~ /\.(tab|dat)$/ ) {
            $format = 'tab';
        }
        else {
            $format = 'genbank';
        }
    }

    my $subclass = $VALID_FORMAT{ $format } or croak('Invalid format');
    my $class    = join( '::', __PACKAGE__, $subclass );
    my $importer = $class->new;

    $importer->import_data( 
        %args,
        files => \@files,
    );
}

sub import_tab {
    my ( $self, %args ) = @_;

    $args{'format'} = 'tab';

    return $self->import_data( %args );
}

1;
