package Gramene::Literature::RefCuration; 

# A module for the add_ref_tool of Gramene.     --------Wei Zhao (03/08/02)  


use strict;
use DBI;
use CGI;
use Gramene::DB;

my %attr;
my $current_ref_id;

my ( $title, $source, $year, $volume, $start_page, $end_page, $author, $ref_url,$abstract );

sub whatever {

    my $class = shift;
    my $self = { };
    bless($self, $class);
    return $self;

}



sub terminate_database{
  my $self = shift;
  #$self->{'db'}->disconnect() if $self->{'db'};
  #$dbh ->disconnect() if $dbh;
}


sub connect_to_ora {
    my $self = shift;	    
    eval{  
      $self->{'db'} = Gramene::DB->new('literature_curation');  
    };  
  
    if($@){   
        die "DB connection failed:$@\n";   
      }   
    
}

############################### Real RefCuration #######################

sub get_candidates {
    my $self = $_[0];
    my $year = $_[1];
    my $start_page = $_[2];
    my $end_page = $_[3];
    my $author = $_[4];

    #print( "&&&&$year\t$start_page\t$end_page\t$author&&&&&&&&&" );

    my $author_input;
    #my @parts = split( /,\s+/, $author );
    my @parts = split( /,\s*/, $author );   #liya
    foreach my $p ( @parts ) {

        my @small = split( /-/, $p );
	$author_input = $author_input.$small[0]." ";
    }

    my $sth1 = $self->{'db'}->prepare( "SELECT reference_id, title FROM reference
                               WHERE year = ?
                               and start_page = ?
                               and end_page = ?" );

    my $sth2 = $self->{'db'}->prepare( "SELECT contributor_name FROM contributor, author
                                WHERE contributor.contributor_id = author.contributor_id
                                and reference_id = ?
                                order by authorship_position" );

    $sth1->bind_param( 1, $year );
    $sth1->bind_param( 2, $start_page );
    $sth1->bind_param( 3, $end_page );
    $sth1->execute();

    my ( $ref_id, $title, @ref_ids, @titles );
    while( ( $ref_id, $title ) = $sth1->fetchrow_array ) {

        #print( "********$ref_id: $title********" );

        $sth2->bind_param( 1, $ref_id );
	$sth2->execute();
	my $author_string;
	while( my $name = $sth2->fetchrow_array ) {

	    my @fields = split( /-/, $name );
	    $author_string = $author_string.$fields[0]." ";
	}

	#if( $author_string eq $author_input ) {
	if( $author_string =~ /$author_input/i ) {

	    @ref_ids = ( @ref_ids, $ref_id );
	    @titles = ( @titles, $title );
	}
    }

    return ( \@ref_ids, \@titles );
	    

}


sub set_fields {
    
    my $self = $_[0];
    $title = $_[1];
    $source = $_[2];
    $year = $_[3];
    $volume = $_[4];
    $start_page = $_[5];
    $end_page = $_[6];
    $author = $_[7];
    $abstract = $_[8];
    $ref_url = $_[9];   
 
    return;

}




sub load_references {

    my $self = $_[0];
    if( $title ) {

        # Prepare INSERT statements
        my $sth1 = $self->{'db'}->prepare( "INSERT INTO source VALUES ( ?, ?, ? )" );

	my $sth3 = $self->{'db'}->prepare( "INSERT INTO reference (reference_id, source_id, title, volume, year, start_page, end_page) 
                                   VALUES ( ?, ?, ?, ?, ?, ?, ? )" );

	my $sth17 = $self->{'db'}->prepare( "INSERT INTO reference_abstract (reference_id, abstract_part_a)
                                    VALUES ( ?, ? )" );

	my $sth19 = $self->{'db'}->prepare( "INSERT INTO reference_abstract VALUES ( ?, ?, ? )" );
  

	my $sth32 = $self->{'db'}->prepare( "SELECT MAX(source_id) FROM source" );
	my $source_id;

	my $sth35 = $self->{'db'}->prepare( "SELECT MAX(reference_id) FROM reference" );
	my $reference_id;
    
	my $sth103 = $self->{'db'}->prepare( "SELECT source_id FROM source
                                 WHERE UPPER(source_name) = ?
                                 UNION
                                 SELECT source_id FROM source_synonym
                                 WHERE UPPER(source_synonym) = ?" );



        my $word = $source;
	$word =~ tr/a-z/A-Z/;
		   
	$sth103->bind_param( 1, $word );
	$sth103->bind_param( 2, $word );
	$sth103->execute();
				
	my $s_id = $sth103->fetchrow_array();

	unless( $s_id ) {

	    $sth32->execute();
	    $source_id = $sth32->fetchrow_array();

	    $source_id = $source_id + 1;
	    $sth1->bind_param( 1, $source_id );
	    $sth1->bind_param( 2, $source );
	    $sth1->bind_param( 3, "Not available" );
	    #$sth1->execute();
	   
	    my $rv = $sth1->execute() or die $sth1->errstr;
            $s_id = $source_id;
	}

	$sth35->execute();
	$reference_id = $sth35->fetchrow_array();
	
		    
	###insert reference
	$reference_id = $reference_id + 1;
	$current_ref_id = $reference_id;

	$sth3->bind_param( 1, $reference_id );
	$sth3->bind_param( 2, $s_id );
	$sth3->bind_param( 3, $title );

	$sth3->bind_param( 4, $volume );

	$sth3->bind_param( 5, $year );

	$sth3->bind_param( 6, $start_page );

	$sth3->bind_param( 7, $end_page );
	my $ru = $sth3->execute() or die $sth3->errstr;
	
	# Insert records into table REFERENCE_ABSTRACT
	if( $abstract ) {

	    if( length( $abstract ) <= 3950 ) {

		$sth17->bind_param( 1, $reference_id );
		$sth17->bind_param( 2, $abstract );
		$sth17->execute();

	    } else {
					       
		my $aa = substr( $abstract, 0, 3950 );
		my $ab = substr( $abstract, 3950 );

		$sth19->bind_param( 1, $reference_id );
		$sth19->bind_param( 2, $aa );
		$sth19->bind_param( 3, $ab );
		$sth19->execute();
	    }
	}
   	
        if($ref_url){
 
            load_reference_urls($self);
      
        }

	$sth1->finish;

	$sth3->finish;

	$sth17->finish;
	$sth19->finish;
     
	$sth32->finish;
	$sth35->finish;

	$sth103->finish;

	#print( "!!!!load_references!!!!!" );

	
    } 
    return;

}


sub load_reference_urls{

  
    my $self = $_[0];
    
    my @ref_urls;
    $ref_url =~ s/^\s+//;
    $ref_url =~ s/\s+$//; 


    @ref_urls = split(/\s+/,$ref_url);

    my %seen = ();
    my @uniq_urls;
    foreach my $item (@ref_urls) {
	push(@uniq_urls, $item) unless $seen{$item}++;
    }
  

    my $sth20 = $self->{'db'}->prepare( "INSERT INTO reference_url(reference_url_id, reference_id,reference_url) 
                                       VALUES(?,?,?)");

     
    foreach my $url (@uniq_urls){
                      
        $sth20->bind_param(1, &_next_id($self->{'db'},'reference_url','reference_url_id'));
        $sth20->bind_param(2,$current_ref_id);
        $sth20->bind_param(3,$url);
        my $r=$sth20->execute() or die $sth20->errstr ;


    }
  
    $sth20->finish;

}


sub load_authors {

    my $self = $_[0];
    if( $author ) {

        #my @authors = split( /,\s+/, $author );
        my @authors = split( /,\s*/, $author );  # liya

        
	# Prepare INSERT statements

	my $sth7 = $self->{'db'}->prepare( "INSERT INTO contributor (contributor_id, contributor_name, contributor_email, contributor_organization) 
                           VALUES ( ?, ?, ?, ? )" );
	my $sth9 = $self->{'db'}->prepare( "INSERT INTO author VALUES (?, ?, ?, ? )" );


	my $sth21 = $self->{'db'}->prepare( "SELECT contributor_id FROM author
                            WHERE reference_id = ?
                            AND authorship_position = ?" );

	my $sth36 = $self->{'db'}->prepare( "SELECT MAX(contributor_id) FROM contributor" );
	#my $contributor_id;

    

	my $sth101 = $self->{'db'}->prepare( "SELECT contributor_id FROM contributor
                                 WHERE UPPER(contributor_name) = ?" );



	

	my $sth105 = $self->{'db'}->prepare( "SELECT authorship_position FROM author
                                 WHERE reference_id = ?
                                 AND contributor_id = ?" );

        # for unique constraints
        my %author_sets_tbl;
        my @author_sets;
        foreach (@authors){
          unless( $author_sets_tbl{$_}){
           $author_sets_tbl{$_}=1;
           push (@author_sets,$_);
	 }
        } 
        @authors = @author_sets;


	my $position = 0;
	foreach my $a ( @authors ) {

	    my $temp = $a;
	    $temp =~ tr/a-z/A-Z/;
		   
	    $sth101->bind_param( 1, $temp );
	    $sth101->execute();
	    my $c_id = $sth101->fetchrow_array();

	    unless( $c_id ) {

	        $sth36->execute();
		my $contributor_id = $sth36->fetchrow_array();
		$contributor_id = $contributor_id + 1;
		$sth7->bind_param( 1, $contributor_id );
		$sth7->bind_param( 2, $a );
		$sth7->bind_param( 3, "Not available" );
		$sth7->bind_param( 4, "Not available" );
		my $rv = $sth7->execute() or die $sth7->errstr;
		
		$c_id = $contributor_id;
	    }

	    $position++;
	    $sth9->bind_param( 1,
	    &_next_id($self->{'db'},'author','author_id') );
	    $sth9->bind_param( 2, $c_id );
	    $sth9->bind_param( 3, $current_ref_id );
	    $sth9->bind_param( 4, $position );
	    my $ru = $sth9->execute() or die $sth9->errstr;

	} #End foreach
	
   
	$sth7->finish;
	$sth9->finish;

	$sth21->finish;

	$sth36->finish;
	$sth101->finish;

    
	$sth105->finish;
    }


    return;
    
}



sub do_extra_work {

    my $self = $_[0];
    my $sth2 = $self->{'db'}->prepare( "SELECT source_name FROM source
                               where source_id = ?" );

    my $sth3 = $self->{'db'}->prepare( "select contributor_name from contributor, author
                           where contributor.contributor_id = author.contributor_id
                           and author.reference_id = ?
                           order by author.authorship_position" );


    my $sth4 = $self->{'db'}->prepare( "select abstract_part_a, abstract_part_b from reference_abstract
                           where reference_id = ?" );

    my $sth5 = $self->{'db'}->prepare( "insert into reference_extra
                           values( ?, ?, ?, ?, ?, ?, ? )" );


    my $sth1 = $self->{'db'}->prepare( "SELECT reference_id, source_id, title, year FROM reference
                               where reference_id = ?
                               order by reference_id" );

    $sth1->bind_param( 1, $current_ref_id );
    $sth1->execute();

    
    #my ( $id, $sid, $title, $year );
    my ( $id, $sid, $title, $year ) = $sth1->fetchrow_array();

        my $source;
	if( $sid ) {
	    $sth2->bind_param( 1, $sid );
	    $sth2->execute();
	    $source = $sth2->fetchrow_array;
	} else {
	    $source = "";
	}

	my $names;
	$sth3->bind_param( 1, $id );
	$sth3->execute();
	while( my $name = $sth3->fetchrow_array ) {
	    if( $names ) {
	        $names = $names." ".$name;
	    } else {
	        $names = " ".$name;
	    }
	}
	$names = $names." ";

	$sth4->bind_param( 1, $id );
	$sth4->execute();
	my ( $aa, $ab ) = $sth4->fetchrow_array;

	$sth5->bind_param( 1, $id );
	$title =~ s/\W/ /g;
	$title = " ".$title." ";
	$sth5->bind_param( 2, $title );
	$sth5->bind_param( 3, $source );
	$sth5->bind_param( 4, $names );
	$sth5->bind_param( 5, $year );

	$aa =~ s/\W/ /g;
	$aa = " ".$aa;
	$sth5->bind_param( 6, $aa );

	$ab =~ s/\W/ /g;
	$ab = $ab." ";
	$sth5->bind_param( 7, $ab );
	$sth5->execute();
    


    $sth1->finish();
    $sth2->finish();
    $sth3->finish();
    $sth4->finish();
    $sth5->finish();
    

    return;
}

sub _next_id {
    my ( $db, $table_name, $field_name ) = @_;
    my $id = $db->selectrow_array("select max($field_name) from $table_name");
    return ++$id;
}

sub get_new_load {
    
    
    return $current_ref_id;

}


################################# RefCuration End #########################

1;	

