package Gramene::Literature::GetRefD; 

# A module for the publication search page of Gramene.     --------Wei Zhao (10/03/01)  


use strict;
use DBI;
use CGI;
use Gramene::DB;

my %attr;

sub whatever {

    #my $invocant = shift;
    #my $class = ref($invocant) || $invocant;
    my $class = shift;
    my $self = { };
    bless($self, $class);
    return $self;

}



sub terminate_database{
  my $self = shift;

}


sub connect_to_ora {
    my $self = shift;
    eval{  
      $self->{'db'} = Gramene::DB->new('literature') unless $self->{'db'};  
      $self->{'protein_db'} = Gramene::DB->new('protein') unless $self->{'protein_db'};  
      $self->{'gene_db'} = Gramene::DB->new('genes') unless $self->{'gene_db'} ;
      $self->{'qtl_db'} = Gramene::DB->new('qtl') unless $self->{'qtl_db'};       
      $self->{'marker_db'} = Gramene::DB->new('markers') unless $self->{'marker_db'};
      $self->{'diversity_rice_db'} = Gramene::DB->new('diversity_rice') unless $self->{'diversity_rice_db'};
    };  
  
    if($@){   
        die "DB connection failed:$@\n";   
      }   



}


sub name_to_person {
    my $self = shift;
    my $author = $_[1];
     
    my ( @person_ids, @person_names );
    my ( $person_id, $person_name );


    my $sth1 = $self->{'db'}->prepare( "SELECT contributor_id, contributor_name FROM contributor 
			       WHERE UPPER(contributor_name) LIKE ?
                               ORDER BY contributor_name" );
    $sth1->bind_param( 1, $author );
    $sth1->execute();
    while( ( $person_id, $person_name ) = $sth1->fetchrow_array ) {
        
        
        @person_ids = ( @person_ids, $person_id );
	  @person_names = ( @person_names, $person_name );

    }
    $sth1->finish;
    return ( \@person_ids, \@person_names );
}


sub person_to_ref {
    my ($self, $person_id) = @_;
    my ( $ref_id, @ref_ids );

    
#    my $sth2 = $self->{'db'}->prepare( "SELECT reference_id from reference
#                               where reference_id in
#                                     (SELECT reference_id FROM author WHERE contributor_id = ?)
#                               order by year DESC" );

    my $sth2 = $self->{'db'}->prepare( "SELECT AU.reference_id 
                                FROM  author AU, reference REF
                                WHERE AU.reference_id = REF.reference_id
                                  AND contributor_id =?
                                ORDER BY year DESC
                             ");   



    $sth2->bind_param( 1, $person_id );
    $sth2->execute();
    while( $ref_id = $sth2->fetchrow_array ) {
        
        
        @ref_ids = ( @ref_ids, $ref_id );


    }
    $sth2->finish;
    return @ref_ids;
}


sub source_id_to_source_name {
    my ($self, $source_id) = @_;
    my $source_name;

    my $sth3 = $self->{'db'}->prepare( "SELECT source_name FROM source WHERE source_id = ?" );
    $sth3->bind_param( 1, $source_id );

    
    $sth3->execute();
    $source_name = $sth3->fetchrow_array();
    $sth3->finish;
    return $source_name;    
        
    
}


sub source_id_to_source_url {
    my ($self,$source_id) = @_;
    my $source_url;

    my $sth40 = $self->{'db'}->prepare( "SELECT source_url FROM source_url WHERE source_id = ?" );
    $sth40->bind_param( 1, $source_id );

    
    $sth40->execute();
    $source_url = $sth40->fetchrow_array();
    $sth40->finish;
    return $source_url;    
        
    
}


sub ref_id_to_ref {
    my ($self,$ref_id) = @_;
    my ( $title, $source_id, $year, $volume, $start_page, $end_page );
    my $sth4 = $self->{'db'}->prepare( "SELECT reference_id, title, source_id, year, volume, start_page, end_page 
					 FROM reference 
                               WHERE reference_id = ?" );
    $sth4->bind_param( 1, $ref_id );
    $sth4->execute();
	
    ( $ref_id, $title, $source_id, $year, $volume, $start_page, $end_page ) = $sth4->fetchrow_array();
    $sth4->finish;
    return ( $title, $source_id, $year, $volume, $start_page, $end_page );
}



sub ref_id_to_abstract {
    my ($self,$ref_id) = @_;
    my ( $abstract, $aa, $ab );
    my $sth5 = $self->{'db'}->prepare( "SELECT abstract_part_a, abstract_part_b
					 FROM reference_abstract
					 WHERE reference_id = ?" );
    $sth5->bind_param( 1, $ref_id );
    $sth5->execute();
    ( $aa, $ab ) = $sth5->fetchrow_array();
    if( $aa ) {
        if( $ab ) {
	      $abstract = $aa.$ab;
	  } else {
	      $abstract = $aa;
        }
    } else {
	  $abstract = "Not available.";
    }
    $sth5->finish;
    return $abstract;
}



sub title_word_to_ref {
    my ($self,$word) = @_;
    my ( @ref_ids, $ref_id );
    
    my $sth6 = $self->{'db'}->prepare( "SELECT reference_id FROM reference 
                               WHERE UPPER(title) LIKE ?
                               ORDER BY year DESC" ); 
    $sth6->bind_param( 1, $word );
    $sth6->execute();
    
    while( $ref_id = $sth6->fetchrow_array ) {
        @ref_ids = ( @ref_ids, $ref_id );
    }
    $sth6->finish;
    return @ref_ids;
}


sub word_to_ref {

    my ($self,$word) = @_;
    my ( @ref_ids, $ref_id );


#    my $sth6 = $self->{'db'}->prepare( "select reference_id from reference
#                               where UPPER(title) LIKE ?
#                               or reference_id in
#                                  (SELECT reference_id FROM reference_abstract
#                                   WHERE UPPER(abstract_part_a) LIKE ?
#                                   OR UPPER(abstract_part_b) LIKE ?)
#                               order by year DESC" ); 


    my $sth6 = $self->{'db'}->prepare(
                              q[
                                 
                                  SELECT reference.reference_id from reference
                                  LEFT JOIN reference_abstract
                                  ON
                                  reference.reference_id = reference_abstract.reference_id
                                  WHERE UPPER(title) LIKE ?
                                  OR UPPER(abstract_part_a) LIKE ?
                                  OR UPPER(abstract_part_b) LIKE ?                        
                                  order by year DESC

                               ]
                             );


    $sth6->bind_param( 1, $word );
    $sth6->bind_param( 2, $word );
    $sth6->bind_param( 3, $word );
    
    $sth6->execute();
    
    while( $ref_id = $sth6->fetchrow_array ) {
        @ref_ids = ( @ref_ids, $ref_id );
    }

    $sth6->finish;
    return @ref_ids;
    
}


sub source_to_source_id {
    my ($self,$source,$year) = @_;
    my ( $source_id, $source_name );
    my ( @source_ids, @source_names );


    my $sth8 = $self->{'db'}->prepare( "SELECT source_id, source_name FROM source
                               WHERE UPPER(source_name) LIKE ?
                               UNION
                               SELECT source_id, source_synonym FROM source_synonym
                               WHERE UPPER(source_synonym) LIKE ?
                               ORDER BY 2" );
   
    $sth8->bind_param( 1, $source );
    $sth8->bind_param( 2, $source );
    $sth8->execute();
    while( ( $source_id, $source_name ) = $sth8->fetchrow_array ) {
        my $unique = 1;
        my $i = 0;
	while( ( $unique ) && ( $i <= $#source_ids ) ) {
	  if( $source_id == $source_ids[$i] ) {
	      $unique = 0;
	  }
	  $i++;
	}
	if( $unique ) {
            @source_ids = ( @source_ids, $source_id );
	    @source_names = ( @source_names, $source_name );
	}
    }
    $sth8->finish;
    if( $year == 0 ) {
        return ( \@source_ids, \@source_names );
      } else {

	

	    my $found_source_id;
	    my @found_source_ids;
	    my @found_source_names;

	    my $sth9 = $self->{'db'}->prepare( "SELECT source_id FROM reference 
                                       WHERE source_id = ?
                                       AND year = ?" );
	    for( my $i=0; $i<=$#source_ids; $i++ ) {
                                  
	        $sth9->bind_param( 1, $source_ids[$i] );
		$sth9->bind_param( 2, $year );
		$sth9->execute();
		$found_source_id = $sth9->fetchrow_array; 

	        if( $found_source_id ) {
		    @found_source_names = ( @found_source_names, $source_names[$i] );
		    @found_source_ids = ( @found_source_ids, $source_ids[$i] );
		}
	    }
	    $sth9->finish;
	    return ( \@found_source_ids, \@found_source_names );

	  }

}
	    


sub source_id_to_ref {
    my ($self,$source_id,$year) = @_;
    my ( $ref_id, @ref_ids );
    my $sth10;

    if( $year ) {

    
         $sth10 = $self->{'db'}->prepare( "SELECT reference_id FROM reference 
                                   WHERE source_id = ?
                                   AND year = ?
                                   ORDER BY volume DESC" ); 
	$sth10->bind_param( 1, $source_id );
	$sth10->bind_param( 2, $year );
    } else {
	 $sth10 = $self->{'db'}->prepare( "SELECT reference_id FROM reference 
                                   WHERE source_id = ?
                                   ORDER BY year DESC" );
                                  
	$sth10->bind_param( 1, $source_id );
    }
    $sth10->execute();

    while( $ref_id = $sth10->fetchrow_array ) {
        @ref_ids = ( @ref_ids, $ref_id );

    }
    $sth10->finish;
    return @ref_ids;

}


sub ref_id_to_author {
    my ($self,$ref_id) = @_;
    my ( $person_id, @person_ids, $author, @authors );
    
    my $sth12 = $self->{'db'}->prepare( "SELECT contributor_id FROM author
                                WHERE reference_id = ?
                                ORDER BY authorship_position" );
    my $sth13 = $self->{'db'}->prepare( "SELECT contributor_name FROM contributor
                                WHERE contributor_id = ?" );
    $sth12->bind_param( 1, $ref_id );
    $sth12->execute();
    while( $person_id = $sth12->fetchrow_array() ) {
        @person_ids = ( @person_ids, $person_id );
        $sth13->bind_param( 1, $person_id );
	$sth13->execute();
	$author = $sth13->fetchrow_array();
	@authors = ( @authors, $author );
    }
    $sth12->finish;
    $sth13->finish;
    return (\@person_ids, \@authors);
}


sub ref_id_to_url {
    my ($self,$ref_id) = @_;
    my ( $url, $label, @urls, @labels );
    my $sth14 = $self->{'db'}->prepare( "SELECT reference_url, url_label
				FROM reference_url
				WHERE reference_id = ?" );
    $sth14->bind_param( 1, $ref_id );
    $sth14->execute();
    while( ( $url, $label ) = $sth14->fetchrow_array() ) {
        @urls = ( @urls, $url );
	@labels = ( @labels, $label );
    }
    $sth14->finish;
    return (\@urls, \@labels);
}

sub ref_id_to_comment {
    my ($self,$ref_id) = @_;
    my ( $comment );
    my $sth15 = $self->{'db'}->prepare( "SELECT reference_comment
				FROM reference_comment
				WHERE reference_id = ?" );
    $sth15->bind_param( 1, $ref_id );
    $sth15->execute();
    $comment = $sth15->fetchrow_array();
    $sth15->finish; 
    return $comment;
}


sub ref_id_to_xref {
    my ($self, $ref_id) = @_;
    my ( $db_name, $acc, @db_names, @accs );
 
   my $sth1 = $self->{'db'}->prepare("SELECT xref_dbname, xref_key
                             FROM dbxref DBX, objectxref OBX
                             WHERE DBX.dbxref_id = OBX.dbxref_id
                             AND UPPER(xref_dbname) = 'PUBMED'
                             AND table_name = 'gramene.literature' 
                             AND row_id = ?");                      



    $sth1->bind_param( 1, $ref_id );
    $sth1->execute();

    while( ( $db_name, $acc ) = $sth1->fetchrow_array ) {
        @db_names = ( @db_names, $db_name );
	@accs = ( @accs, $acc );
	
    }
    $sth1->finish;
    
    return ( \@db_names, \@accs );
}


###################

#sub get_annotation {
#    my $ref_id = $_[1];
#    my ( $dbxref, $ann, @dbxrefs, @anns );
#    my $sth18 = $self->{'db'}->prepare( "SELECT dbxref_id, annotation
#				FROM reference_annotation
#				WHERE reference_id = ?" );
#                              
#    
#    $sth18->bind_param( 1, $ref_id );
#    $sth18->execute();

#    while( ( $dbxref, $ann ) = $sth18->fetchrow_array() ) {
#        
#	@dbxrefs = ( @dbxrefs, $dbxref );
#	@anns = ( @anns, $ann );

#    }
#    $sth18->finish;
#    return ( \@dbxrefs, \@anns );
#}


#####################

sub get_xref {
    my ($self,$dbxref_id) = @_;
    my ( $key, $type, $name );
    my $sth19 = $self->{'db'}->prepare( "SELECT xref_key, xref_keytype, xref_dbname
				FROM dbxref
				WHERE dbxref_id = ?" );
                              
    
    $sth19->bind_param( 1, $dbxref_id );
    $sth19->execute();

    ( $key, $type, $name ) = $sth19->fetchrow_array();
        
    $sth19->finish;
    return ( $key, $type, $name );
}
######################


sub get_all_refs {
     my $self = $_[0];
     my $author_a = $_[1];
     my $author_b = $_[2];
     my $keyword = $_[3];
     my $source = $_[4];

     my $sth2 = $self->{'db'}->prepare( "select reference_id from reference_extra
                                where UPPER(author) like ?
                                or UPPER(author) like ?" );
     $sth2->bind_param( 1, $author_a );
     $sth2->bind_param( 2, $author_b );
    
     $sth2->execute();

     my $c_id = $sth2->fetchrow_array();

     
     if( $c_id ) {
         #print( "get contributor!\n" );
         #$keyword = "%"." ".$keyword." "."%";
         $keyword = "%".$keyword."%";  
     } else {
         #print( "no contributor!\n" );
         #$keyword = "%"." ".$keyword."%";
         $keyword = "%".$keyword."%"; 
     }
     $sth2->finish;

     my ( $ref_id, @ref_ids );
     my $sth1 = $self->{'db'}->prepare( "select reference_id from reference_extra
                                where UPPER(author) like ?
                                or UPPER(author) like ?
                                or UPPER(title) LIKE ?
                                or UPPER(abstract_part_a) LIKE ?
                                or UPPER(abstract_part_b) LIKE ?
                                or UPPER(source) = ?
                                order by year DESC, author" );

     $sth1->bind_param( 1, $author_a );
     $sth1->bind_param( 2, $author_b );
     $sth1->bind_param( 3, $keyword );
     $sth1->bind_param( 4, $keyword );
     $sth1->bind_param( 5, $keyword );
     $sth1->bind_param( 6, $source );
   
     $sth1->execute();

     while( $ref_id = $sth1->fetchrow_array ) {
         @ref_ids = ( @ref_ids, $ref_id );
     }

     $sth1->finish;
     return @ref_ids;

}
     
###################

sub get_person_name {
    my ($self,$person_id) = @_;
    
    my $sth1 = $self->{'db'}->prepare( "select contributor_name from contributor
                               where contributor_id = ?" );
    $sth1->bind_param( 1, $person_id );
    $sth1->execute();
    my $person_name = $sth1->fetchrow_array;

    $sth1->finish;
    return $person_name;
}


sub validate_id {

    my ($self,$id) = @_;
    my $p_id;

    unless ( $id =~ /\D/ ) { 
    
        my $sth1 = $self->{'db'}->prepare( "select reference_id from reference
                               where reference_id = ?" );
	$sth1->bind_param( 1, $id );
	$sth1->execute();
	$p_id = $sth1->fetchrow_array;

	$sth1->finish;

    }
    return $p_id;
}


sub acedb_to_ref_id {

    my ($self,$acedb) = @_;
    my $ref_id;

#    my $sth1 = $self->{'db'}->prepare( "select row_id from objectxref
#                               where dbxref_id =
#                                     (select dbxref_id from dbxref
#                                      where UPPER(xref_key) = ?
#                                      and xref_dbname = ?)" );

    my $sth1 = $self->{'db'}->prepare( "select row_id 
                               from objectxref OBX, dbxref DBX
                               where OBX.dbxref_id = DBX.dbxref_id
                                and   UPPER(xref_key) = ?
                                and xref_dbname = ?"
                             );




    $sth1->bind_param( 1, $acedb );
    $sth1->bind_param( 2, "gramene_acedb" );
    $sth1->execute();
    $ref_id = $sth1->fetchrow_array;

    $sth1->finish;
    return $ref_id;
}

########################


sub ref_id_to_protein {
    
    my ($self,$ref_id) = @_;


    my ( @accs, @names );

    my $xref_dbname ='gramene.protein';
    my $xref_keytype = 'acc';

    @accs = get_xref_keys($self,$ref_id,$xref_dbname,$xref_keytype); 

    my $sth = $self->{'protein_db'}->prepare( "select gene_product_full_name 
                               from gene_product_helper GPH,
			       gene_product H
                               where H.gene_product_id = GPH.gene_product_id
			       and swissprot_acc = ?");

    foreach my $acc (@accs ){
	$sth->execute(($acc));
        my ($name) = $sth->fetchrow_array ;
	@names = ( @names, $name );
	
    }
    $sth->finish;
    
    return (  \@accs, \@names );
}



########################

sub ref_id_to_gene {
    
    my ($self,$ref_id) = @_;
    my ( @accs, @names );

    my $xref_dbname ='gramene.genes';
    my $xref_keytype = 'acc';

    my @gene_accs = get_xref_keys($self,$ref_id,$xref_dbname,$xref_keytype); 
 
    my $sth = $self->{'gene_db'}->prepare( "select name
                               from gene_gene 
                               where accession = ?" );

    foreach my $acc ( @gene_accs ) {

        $sth->bind_param( 1, $acc );
	$sth->execute();
	my ($name) = $sth->fetchrow_array;
	
	@accs = ( @accs, $acc );
	@names = ( @names, $name );
	
    }
    $sth->finish;
    
    return ( \@accs, \@names );
}



#####################


sub ref_id_to_qtl {

    my ( $self, $ref_id ) = @_;

    my $xref_dbname  = 'gramene.QTL';
    my $xref_keytype = 'acc';

    my @accs   = get_xref_keys( $self, $ref_id, $xref_dbname, $xref_keytype );
    my $qtl_db = $self->{'qtl_db'} or croak('No QTL db handle');
    my $sth    = $qtl_db->prepare(
        q[
            select t.trait_symbol, t.trait_name, qtl.published_symbol
            from   qtl, qtl_trait t
            where  qtl.qtl_accession_id=?
            and    qtl.qtl_trait_id=t.qtl_trait_id
            order by 1,2,3
        ]
    );

    my @symbols;
    for my $acc ( @accs ) {
        $sth->bind_param( 1, $acc );
        $sth->execute();

        push @symbols, $sth->fetchrow_hashref;
    }
    $sth->finish;

    return ( \@accs, \@symbols );
}


sub ref_id_to_marker {
    
    my ($self,$ref_id) = @_;
    my (@ids,@types, @names );

 

    my $xref_dbname ='gramene.markers';
    my $xref_keytype = 'id';

    @ids = get_xref_keys($self,$ref_id,$xref_dbname,$xref_keytype); 

  
    my $sth = $self->{'marker_db'}->prepare(
	q[
	    SELECT marker_name, marker_type
	    FROM   marker M, marker_synonym MS, marker_type MT
	    WHERE  M.display_synonym_id = MS.marker_synonym_id
	    AND    M.marker_type_id = MT.marker_type_id
            AND    M.marker_id = ?
	]);


    foreach my $id (@ids){

        $sth->bind_param( 1, $id );
	$sth->execute();
	my ($name,$type) = $sth->fetchrow_array; # use only one name
	
	@names = ( @names, $name );
        @types = ( @types, $type );	
    }
    $sth->finish;
    
    return ( \@ids,\@types, \@names );
}

########################
sub ref_id_to_diversity {
    
    my ($self,$ref_id) = @_;
    my ( @ids, @names );

    my $xref_dbname ='gramene.diversity.experiment';
    my $xref_keytype = 'id';

    my @div_exp_ids = get_xref_keys($self,$ref_id,$xref_dbname,$xref_keytype); 
 
    my $sth = $self->{'diversity_rice_db'}->prepare( "select name
                               from div_experiment 
                               where div_experiment_id = ?" );

    foreach my $id ( @div_exp_ids ) {

        $sth->bind_param( 1, $id );
	$sth->execute();
	my ($name) = $sth->fetchrow_array;
	
	@ids = ( @ids, $id );
	@names = ( @names, $name );
	
    }
    $sth->finish;
    
    return ( \@ids, \@names );
}

sub get_xref_keys {
    my ($self,$ref_id, $xref_dbname, $xref_keytype) = @_;
    my $sth = $self->{'db'}->prepare(
	q[
	    SELECT DISTINCT xref_key 
	    FROM   dbxref DX, objectxref OX
	    WHERE  OX.dbxref_id = DX.dbxref_id
	    AND    OX.table_name = ? 
	    AND    OX.row_id = ?
	    AND    DX.xref_dbname = ?
	    AND    DX.xref_keytype = ?
	]);

    my $table_name = 'gramene.literature';

    $sth->execute(($table_name, $ref_id, $xref_dbname, $xref_keytype));

    my @xref_keys;
    while(my ($xref_key) = $sth->fetchrow_array){
	push @xref_keys, $xref_key;
    }

    return @xref_keys;

}
1;	

