package Gramene::FAQ;

#Gramene::FAQ, copyright and (c) 2005 James A Thomason III
#Gramene::FAQ is distributed under the terms of the Perl Artistic License.

$VERSION = '1.00';

use base qw(Gramene::Web);

use Gramene::FAQ::FAQ;
use Gramene::FAQ::Question;

use strict;
use warnings;

sub prompt {
	my $self = shift;

	$self->template('/login.tpl');
	
	return $self->output;
}

sub init {
	my $self = shift;

	$self = $self->SUPER::init(@_) or return;

	# the case could be made to triplicate out this call, but fuck it.
	$self->args->{'faqs'} = Gramene::FAQ::FAQ->load_all({'order by' => 'name'});
	$self->template('/faqs.tpl');

	return $self;
}

sub start { return shift->display_faqs }

sub view { 
	my $self = shift;
	$self->template('/question.tpl');
	return $self->display_question;
};

sub display_faqs {
	my $self = shift;
	
	#put in a junk question, if there isn't one.
	$self->args->{'question'} ||= Gramene::FAQ::Question->new();
	
	return $self->output;
	
}

sub display_faq {
	my $self = shift;

	my $faq = $self->args->{'faq'} = Gramene::FAQ::FAQ->load($self->extract('faq_id'));
	$self->args->{'faq_id'} = $faq->faq_id;

	$self->args->{'question'} ||= Gramene::FAQ::Question->new(
		'number' => 1,
		'question' => 'Where are all the questions?',
		'answer' => 'This FAQ is empty.',
	);

    $self->args->{'display_all_in_faq'} = $self->extract('display_all_in_faq');
    if ($self->extract('display_only_faq')) {
        $self->args->{'faqs'} = [$faq];
        $self->args->{'display_only_faq'} = 1;
    };


	return $self->output;
	
}

sub display_question {
	my $self = shift;
	
	$self->args->{'question'}	||= Gramene::FAQ::Question->load($self->extract('faq_question_id'));
	$self->args->{'faq_id'}		= $self->args->{'question'}->faq_id;
	
	$self->template('/question.tpl') if $self->extract('ajax');
	
	return $self->display_faq;
	
}

sub new_obj {
	my $self = shift;
	
	return $self->error("Break in attempt") if $self->user->is_nobody;
	
	$self->using_editor(1);
	
	$self->args->{'question'} = Gramene::FAQ::Question->new(
		'faq_id' => $self->extract('faq_id'),
	);

	return $self->display_question;
}

sub save {
	my $self = shift;
	
	return $self->error("Break in attempt") if $self->user->is_nobody;
	
	$self->template('/question.tpl');	
	$self->using_editor(1);
	
	my $args = $self->extract_into_hash_and_save(
		qw(faq_question_id faq_id question answer)
	);
	
	my $question = $self->args->{'question'} = Gramene::FAQ::Question->load_or_new($args->{'faq_question_id'});
	my $faq = $self->args->{'faq'} = Gramene::FAQ::FAQ->load($args->{'faq_id'});
	
	if (! $question->loaded) {
		$question->number($faq->max_number + 1);
	}
	elsif (! $self->user->write_access($faq)) {
		$self->args->{'error'} = 'Cannot edit - not owner';
		return $self->display_question;
	}

	$question->perform(
		'methods'	=> [keys %$args],
		'values'	=> [values %$args],
		'continue'	=> 1,
	);
	
	$question->commit or do {
		$self->args->{'error'} = $question->errstring;
		return $self->display_question;
	};
	
	$self->args->{'msg'} = 'Question saved at ' . $self->now();
	
	return $self->display_question;
	
}

sub delete {
	my $self = shift;
	
	return $self->error("Break in attempt") if $self->user->is_nobody;
	
	$self->template('/question.tpl');	
	$self->using_editor(1);
	
	my $question = $self->args->{'question'} = Gramene::FAQ::Question->load($self->extract('faq_question_id'));
	
	if ($self->user->write_access($question->faq)) {
		if ($question->delete) {
			$self->args->{'msg'} = 'Question deleted';
			$self->args->{'faq_id'} = $question->faq_id;
			$self->args->{'deleted_faq_id'} = $question->faq_question_id;
			$self->state('new_obj');	#cheat and claim it's a new object.
			return $self->new_obj;
		}
		else {
			$self->args->{'error'} = $question->errstring;
		}
	} else {
		$self->args->{'error'} = 'Cannot delete question - not owner';
	}
	
	return $self->display_question;
}

sub new_faq {
	my $self = shift;
	
	return $self->error("Break in attempt") if $self->user->is_nobody;
	
	$self->using_editor(1);
	
	my $faq = Gramene::FAQ::FAQ->new(
		'user_id'	=> $self->user->user_id,
		'name'		=> $self->extract('name'),
	);
	
	if ($faq->commit) {
		$self->args->{'faq_msg'} = "faq " . $faq->name . " created";

		#reload the faqs
		$self->args->{'faqs'} = Gramene::FAQ::FAQ->load_all({'order by' => 'lower(name)'});
	}
	else {
		$self->args->{'faq_error'} = $faq->errstring;
	}
	
	return $self->display_faqs;
	
}

sub search {
	my $self = shift;
	
	my $string = $self->extract_and_save('string');
	
	$string =~ s/\s/%/g;
	
	$self->template('/search_results.tpl');
		
	#look for faq questions
	$self->args->{'questions'} = Gramene::FAQ::Question->load_where(
		[
			[ 'question'	=> {'like' => "%$string%"} ],
			[ 'answer'		=> {'like' => "%$string%"} ],
		],
		{ 'order by' => 'question, answer' }
	);
	
	return $self->output;
}


1;
