package Gramene::Apache::WrapHTML;

use strict;
use vars qw($VERSION);
use base 'LWP::UserAgent';
use Apache::Constants qw(:common);
use Apache::File;
use Gramene::Page;
use Gramene::Apache::TipGenerator;
use LWP::UserAgent(); 

$VERSION = '1.02';

use constant HEADER_HEIGHT_PIXELS => 64;

my $UA;


=head1 Docs

Some explanation of how this is supposed to work is in Gramene::Page

=cut

sub handler {
    my $r  = shift;
    my $fh = undef;

    return DECLINED if  ($r->args && $r->args =~ /\b bare \b/x) ;
        #if used path_info then when decline apache  can't find path/bare


    if( ! -e $r->finfo && $r->dir_config('GET_FROM')) { #try to get from
                                                        #other system
        unless($UA) {
            $UA = __PACKAGE__->new;
            $UA->agent(join "/",__PACKAGE__, $VERSION);
        }
        
        warn "\n=========\n".$r->as_string."\n----------\n" 
               if  $r->dir_config('TRACE_WrapHTML') ;

        warn $r->dir_config->{'GET_FROM'}.$r->uri."?bare" if  $r->dir_config('TRACE_WrapHTML') ;
        my $request=HTTP::Request->new($r->method
                     , $r->dir_config->{'GET_FROM'}.$r->uri."?bare");

        $r->headers_in->do(   sub { $request->header(@_) unless $_[0] eq 'Host'; 
                                       return 1; }   );
                            #without this return it just does the first one
        #$r->headers_in->do(   sub { warn join(' +++ ',@_); }   );

        if($r->method eq 'POST') {
            my $len=$r->header_in('Content-length');
            my $buf;
            $r->read($buf,$len);
            $request->content($buf);
        }

        #warn "request\n".$request->headers_as_string."\n---------\n";

        my $response=$UA->request($request);

        warn "response\n".$response->headers_as_string."\n---------\n"
               if  $r->dir_config('TRACE_WrapHTML') ;

        if($response->is_error) {
            warn "LWP response error code=".$response->code." "
                  .$response->message; 
        } 
        $r->content_type($response->header('Content-type'));

        $r->status($response->code);
        $r->status_line(join " ", $response->code, $response->message);
        $response->scan( sub { $r->header_out(@_); }  );

        warn $r->status_line." ".length($response->content)
                                     ." bytes\n=========\n\n"
               if  $r->dir_config('TRACE_WrapHTML') ;
        $r->update_mtime($response->header('Last-Modified'));
        $r->content_type($response->header('Content-Type'));

        #if($r->header_only) {
        #    $r->send_http_header();
        #    return OK;
        #}

        my $content=\$response->content;
        open $fh,"<",$content or warn "open content:$!";


    } else { #Local File 


        if ( $r->filename =~ /\.pod$/ ) {

            # pod2html creates temp files in the current directory
            my $tmpdir = $r->dir_config('TMPDIR') || '/var/tmp';
            chdir $tmpdir or print STDERR "chdir $tmpdir:$!\n";
            if (
                $fh = Apache::File->new(
                    '/usr/local/bin/pod2html --infile=' . $r->filename . '|'
                )
              )
            {
                $r->content_type('text/html');
            } else {
                warn($r->filename.":$!");
                return DECLINED;   
            }
        } else {

            my $only_this=$r->dir_config('WRAP_ONLY');
            return DECLINED if($only_this 
                             and $r->filename !~ m:${only_this}[^/]*$: ); 
            $r->filename($r->document_root."/empty.html")
                if( ! -e $r->filename && $r->filename =~ /EMPTY.html$/);
        }

        #NB: $fh should be open only if was .pod so that 
        #   set content_type to text/html
        #warn $r->content_type;
        return DECLINED unless $r->content_type eq 'text/html';

        if ( ( my $rc = $r->discard_request_body ) != OK ) {
            close $fh if $fh;
            warn $rc if  $r->dir_config('TRACE_WrapHTML') ;
            return $rc;
        }

        if ($fh) {    # pipe 
            #print STDERR $r->filename, " @", ( stat $r->filename )[9], "\n";
            # shouldn't be necessary, but otherwise $r->mtime is 0
            $r->update_mtime( ( stat $r->filename )[9] );
        } elsif(-e $r->finfo ) { #a nice file
            $fh = Apache::File->new( $r->filename ) || return DECLINED;
            # shouldn't be necessary, but otherwise $r->mtime is 0
            $r->update_mtime( ( stat $fh )[9] );       
        } else {
            return DECLINED;    #should lead to 404 error
        }
    } #at this point have set $fh whatever the source of the file is


    my $page = Gramene::Page->new($r);

    # This code handles the "If-Modified-Since" code.
    $r->update_mtime( $page->modified );

    $r->set_last_modified;

    my $rc = $r->meets_conditions; 
    unless ($rc == OK) {
        #warn($rc);
        close $fh;
        return $rc;
    }

    $r->send_http_header;
    if ($r->header_only) {
        #warn("header_only");
        close $fh;
        return OK if $r->header_only;
    }

    warn localtime()." wrapping ".$r->filename if $r->dir_config('TRACE_WrapHTML');

    my $insert = $r->filename;
    $insert =~ s![^/]*$!top_insert.html!;
    my $ifh;
    if ( ( -r $insert ) && ( $ifh = Apache::File->new($insert) ) ) {
        $r->update_mtime( ( stat $ifh )[9] );
        $insert = join '', <$ifh>;
    }
    else {
        $insert = '';
    }

    my ( $header_found, $body_found, $body_ended, $frames_found,
                $frames_ended );
    my $footer_text = 
        qq(<div id="grm_lastmod"><p align="left">Last modified: )
      . localtime( ( stat( $r->filename ) )[9] )
      . qq(</p></div>);

    my $extra_line_traced=0;
    while (<$fh>) {
        warn $_ if  $r->dir_config('TRACE_WrapHTML') && !$extra_line_traced++;
        if (m!(.*)(</head[^>]*>)(.*)!i) {
            warn "</head: $_" if  $r->dir_config('TRACE_WrapHTML') ;
            $r->print($1);
            $r->print( $page->stylesheet_link );
            $r->print($2);
            $_ = $3;
            $header_found++;
        }

        if (m!(.*)<body[^>]*>(.*)!i) {
            warn "<body: $_" if  $r->dir_config('TRACE_WrapHTML') ;
            $r->print($1);
            $r->print( $page->stylesheet, "</head>" ) unless $header_found;
            $r->print( $page->start_body );
            $r->print($insert);
            $_ = $2;
            $body_found++;
        }

        #Add an empty frame at the top to contain the navbar.
        if (! $frames_found && m!(.*?)(<frameset[^>]*>)(.*)!i) {
            warn "<frameset: $_" if  $r->dir_config('TRACE_WrapHTML') ;
            $r->print($1);
            $r->print( $page->stylesheet, "</head>" ) unless $header_found;
            $header_found=1;
            $r->print( qq(<frameset rows="@{[HEADER_HEIGHT_PIXELS]},*"> <frame src=")
                        .$r->uri.qq(EMPTY.html">) );
                        #append on this junk so that feedback link and 
                        #header text will be correct
            $r->print($2);
            $_ = $3;
            $frames_found++;
        }

        #and close it
        if($frames_found && ! $frames_ended && 
                  ( m!(.*)(<noframes>.*)!i || m!(.*)(<body>.*)!i ) ) {
            warn "frame end: $_" if  $r->dir_config('TRACE_WrapHTML') ;
            $r->print($1);
            $r->print(</frameset>);
            $_ = $2;
            $frames_ended++;
        }

        #
        # This is a crude SSI implementation
        # e.g., matches:
        # <!--# Gramene::Apache::TipGenerator::tip_generator -->>
        #
        # added KYC 11/2/04
        #
        if (m[^\s*<!--#\s*([\w:]+)\s*-->]) {
            warn "SSI: $_" if $r->dir_config('TRACE_WrapHTML') ;
            my $sub = $1;
            no strict 'refs';
            my $ret;
            eval { $ret = *{ $sub }->() };
            print STDERR "SSI error: $@\n" if $@;
            $r->print( $ret ) unless $@;
        }

        if (m!(.*)</body!i) {
            warn "</body: $_" if  $r->dir_config('TRACE_WrapHTML') ;
            $r->print($1);
            $r->print( $page->end_body($footer_text) );
            $body_ended++;
            last;    #since end_body includes </html>
        }
        elsif ( !$body_found &&  m!<h\d+>!i ) {    # oops, in body
            warn "oops body: $_" if  $r->dir_config('TRACE_WrapHTML') ;
            $r->print( $page->stylesheet_link );
            $r->print( $page->start_body );
            $r->print($insert);
            $r->print($_);
            $header_found++;
            $body_found++;
        }
        else {
            print $_;
        }
    }
    close $fh;
    warn "body_ended=$body_ended" if  $r->dir_config('TRACE_WrapHTML') ;

    $r->print( $page->end_body($footer_text) ) unless $body_ended;
    return OK;
}

1;
