package Basset::Extractor;

#Basset::Extractor, copyright and (c) 2004 James A Thomason III

$VERSION = '1.00';

use Basset::Object;
our @ISA = Basset::Object->pkg_for_type('object');

use strict;
use warnings;

=pod

=head1 METHODS

=cut

=pod

=over

=cut

=pod

=item extract

=cut

sub extract {
	die 'Superclass extract called';
}

=pod

=begin btest extract

=end btest

=cut

=pod

=item extract_all

=cut

sub extract_all {
	die 'Superclass extract_all called';
}

=pod

=begin btest extract_all

=end btest

=cut


=pod

=item extract_these

=cut

sub extract_these {
	my $self = shift;
	my @values = @_;
	
	my @return = ();
	
	foreach my $val (@values) {
		push @return, $self->extract($val);
	};
	
	return @return;
};

=pod

=begin btest extract_these

=end btest

=cut


=pod

=item extract_match

=cut

sub extract_match {
	my $self = shift;
	my $regex = shift;
	
	#if it's not a quoted regex, then we'll just extract it normally
#	return {$regex, $self->extract($regex)} unless ref $regex;
	
	my $return = {};
	
	my $all = $self->extract_all;
	
	foreach my $key (keys %$all) {
		if ($key =~ /$regex/) {
			my $k = $1 ? $1 : $key;
			my $v = $2 ? [$all->{$key}, $2] : $all->{$key};
			$return->{$k} = $v;
		}
	}

	return $return;
}

=pod

=begin btest extract_match

=end btest

=cut


=pod

=item extract_into_object

=cut

sub extract_into_object {
	my $self = shift;
	
	my %init = @_;
	
	return $self->error("Cannot extract into w/o params", "BE-01") unless $init{'params'};
	return $self->error("Cannot extract into w/o object", "BE-02") unless $init{'object'};
	
	foreach my $param (@{$init{'params'}}) {
		my $value = $self->extract($param);
		if ($init{'object'}->can($param)) {
			my $rc = $init{'object'}->$param($value);
			#return $self->error($init{'object'}->errvals) unless defined $rc;
		} else {
			return $self->error("Cannot extract into : object doesn't understand $param", "BE-03");
		}
	}
	
	return $init{'object'};
}

=pod

=begin btest extract_into_object

=end btest

=cut


1;


=pod

=back

=cut