function wrapHttpRequest (o) {
	makeHttpRequest(
		o.url,
		o.callback,
		o.method,
		o.data_form,
		o.target
	);
}

function makeHttpRequest(url, callback, method, data_form, target) {

	if (callback == null) {
		callback = defaultHttpHandler;
	}
	
	if (method == null) {
		method = 'get';
	}
	
	var data = '';

	if (data_form != null) {
		var data = '';
		var i = 0;
		for (i = 0; i < data_form.elements.length; i++) {
			if (data_form.elements[i].name && (data_form.elements[i].type != 'checkbox' || data_form.elements[i].checked)) {
				data += (data ? '&' : '') + encodeURIComponent(data_form.elements[i].name) + '=' + encodeURIComponent(data_form.elements[i].value);
			}
		}
	}
	
	var httpReq = false;
	
	if (window.XMLHttpRequest) {
		try {
			httpReq = new XMLHttpRequest();
		}
		catch (e) {
			httpReq = false;
		}
	}
	else if (window.ActiveXObject) {
		try {
			httpReq = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e) {
			try {
				httpReq = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch(e) {
				httpReq = false;
			}
		}
	}

	if (httpReq) {
		callback.xmlHttpRequest = httpReq;
	
		httpReq.open(method, url, true);
		if (method.toLowerCase() == 'post') {
			httpReq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		}
	
		httpReq.onreadystatechange = function () {
			callback(httpReq, target);
		}
	
		httpReq.send(data);
	}

	return false;
}

function defaultHttpHandler (http, target) {
	if (http.readyState == 4) {
		target.innerHTML = http.responseText;
	}
}

function toggleVisible(tag, displayStyle) {
	if (displayStyle == null) {
		displayStyle = 'block';
	};

	tag.style.display = ! tag.style.display || tag.style.display == 'none' ? displayStyle : 'none';
}

//used by the disclosure widget

var _openImg;
var _openDiv;

function disclose(img, div, closer) {

	if (div.style.display == 'none') {
		if (closer && _openImg != null && _openDiv != null) {
			_openImg.src = '/faq/img/disclosure/closed.png';
			_openDiv.style.display = 'none';
		}
		img.src = '/faq/img/disclosure/open.png';
		div.style.display = 'block';
		if (closer) {
			_openImg = img;
			_openDiv = div;
		}
	}
	else {
		img.src = '/faq/img/disclosure/closed.png';
		div.style.display = 'none';
		if (closer) {
			_openImg = null;
			_openDiv = null;
		}
	}
}
//end disclosure widget



//used by the toolbar widget

function save(button, link, target, form, callback) {

	button.parentNode.setAttribute('class', 'toolbarmsg');
	button.parentNode.innerHTML = 'Saving...';

	wrapHttpRequest( {
		url : link,
		method : 'post',
		data_form : form,
		target : target,
		callback: callback
	} );
	
}

function edit(button, link, target, callback) {
	generic_tool(button, 'Launching Editor...', link, target, callback);
}

function view(button, link, target, callback) {
	if (confirm("Discard changes and view instead?")) {
		generic_tool(button, 'Loading...', link, target, callback);
	}
}

function reset(button, form) {
	if (confirm("Really start over?")) {
		form.reset();
	}
}

function trash(button, link, target, callback) {
	if (confirm("Really delete?")) {
		generic_tool(button, 'Deleting...', link, target, callback);
	}
}

function generic_tool(button, msg, link, target, callback) {
	button.parentNode.setAttribute('class', 'toolbarmsg');
	button.parentNode.innerHTML = msg;
	
	wrapHttpRequest( {
		url			: link,
		target		: target,
		callback	: callback
	} );
	
}

//end toolbar widget

function offsetDimensions (d) {

	var p = d.offsetParent;
	var offsetLeft = 0;
	var offsetTop = 0;

	while (p != null && p.nodeName != 'BODY') {
		offsetLeft += p.offsetLeft;
		offsetTop += p.offsetTop;
		p = p.offsetParent;
	}
	
	var offsetArray = new Array();
	offsetArray[0] = offsetLeft;
	offsetArray[1] = offsetTop;

	return offsetArray;
}

// tooltips

var _toolTipMouseCurrentlyOver;
var _toolTipImages = new Object();
var _toolTipCurrentlyOver;
var _toolTipTimer;

var _toolTipLastTime;

function enterToolTip(tag, tip, e, img_o) {

	_toolTipMouseCurrentlyOver = tag;

	if (img_o) {

		if (! _toolTipImages[img_o]) {
			_toolTipImages[img_o] = new preImage(img_o);
		}

		tag.src = _toolTipImages[img_o].src;

	}

	var d = new Date();	
	var nowTime = d.getTime();
	
	var timeOut = 1000;

	if (_toolTipTimer != null) {
		clearTimeout(_toolTipTimer);
	}

	if (nowTime - _toolTipLastTime < 300) {
		timeOut = 0;
	}

	e.cancelBubble = true;

	_toolTipTimer = setTimeout(fireToolTip, timeOut, tag, tip, e.pageX, e.pageY);
}

function fireToolTip(tag, tip, x, y) {

	if (_toolTipTimer != null) {
		clearTimeout(_toolTipTimer);
	}

	if (_toolTipCurrentlyOver != tag) {
		_toolTipCurrentlyOver = tag;
		
		var offsets = offsetDimensions(_toolTipCurrentlyOver);

		tip.style.left = x - offsets[0];
		tip.style.top = y - offsets[1];
		tip.style.display = 'block';
	}
}

function clearToolTip(tip, e, img) {

	if (_toolTipMouseCurrentlyOver && img) {

		if (! _toolTipImages[img]) {
			_toolTipImages[img] = new preImage(img);
		}
		
		_toolTipMouseCurrentlyOver.src = _toolTipImages[img].src;

	}

	var d = new Date();	
	var nowTime = d.getTime();
	
	_toolTipLastTime = nowTime;

	if (_toolTipTimer != null) {
		clearTimeout(_toolTipTimer);
	}

	tip.style.display = 'none';				
	_toolTipCurrentlyOver = null;
	_toolTipMouseCurrentlyOver = null;
}

//end tooltips

// toggle

function preImage(where){
	var temp = new Image();
	temp.src = where;
	return temp;
};

function toggle(name, image){
	if (document.images){name.src = image.src};
};

// end toggle

function link(url) {
	document.href = url;
}
